/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.ExpandDeploy;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EarEntry;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppEntry;
import com.caucho.vfs.Path;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarDeploy
extends ExpandDeploy<EarEntry> {
    private String _urlPrefix = "";
    private ApplicationContainer _parentContainer;
    private EarConfig _earDefault;

    public EarDeploy(DeployContainer<EarEntry> deployContainer, ApplicationContainer parentContainer) {
        super((DeployContainer)deployContainer);
        this._parentContainer = parentContainer;
    }

    ApplicationContainer getContainer() {
        return this._parentContainer;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setURLPrefix(String prefix) {
        this._urlPrefix = prefix;
    }

    public EarConfig createEarDefault() {
        this._earDefault = new EarConfig();
        return this._earDefault;
    }

    @Override
    protected String pathNameToEntryName(String name) {
        if (name.startsWith("_ear_")) {
            return name.substring(5);
        }
        return null;
    }

    @Override
    protected String archiveNameToEntryName(String archiveName) {
        if (!archiveName.endsWith(".ear")) {
            return null;
        }
        return archiveName.substring(0, archiveName.length() - 4);
    }

    public WebAppEntry findWebAppEntry(String name) {
        ArrayList entries = this.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            EarEntry ear = (EarEntry)entries.get(i);
            WebAppEntry entry = ear.findWebAppEntry(name);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Override
    public EarEntry createEntry(String name) throws Exception {
        Path rootDirectory = this.getExpandDirectory().lookup(new StringBuffer().append("_ear_").append(name).toString());
        EarEntry entry = new EarEntry(this._parentContainer, null);
        entry.setName(name);
        entry.setRootDirectory(rootDirectory);
        Path jarPath = this.getArchiveDirectory().lookup(new StringBuffer().append(name).append(".ear").toString());
        entry.setArchivePath(jarPath);
        entry.addEarDefault(this._earDefault);
        return entry;
    }
}

