/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.BuilderProgram;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.log.Log;
import com.caucho.server.deploy.ExpandEntry;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EnterpriseApplication;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppEntry;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarEntry
extends ExpandEntry<EnterpriseApplication> {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/e_app/EarEntry"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/e_app/EarEntry"));
    private ApplicationContainer _container;
    private String _name = "";
    private EarConfig _config;
    private BuilderProgram _initProgram;
    private VariableResolver _variableResolver;
    private HashMap<String, Object> _variableMap = new HashMap();
    private Path _earRootDir;
    private boolean _isInit;
    private ArrayList<EarConfig> _eAppDefaults = new ArrayList();

    EarEntry(ApplicationContainer container, EarConfig config) {
        this._container = container;
        this._config = config;
        VariableResolver parentResolver = EL.getEnvironment(this.getParentClassLoader());
        this._variableResolver = new MapVariableResolver(this._variableMap, parentResolver);
    }

    @Override
    public void setName(String name) {
        this._variableMap.put("name", name);
        super.setName(name);
    }

    public EarConfig getEarConfig() {
        return this._config;
    }

    public HashMap<String, Object> getVariableMap() {
        return this._variableMap;
    }

    public VariableResolver getVariableResolver() {
        return this._variableResolver;
    }

    public void addEarDefault(EarConfig earDefault) {
        if (earDefault != null) {
            this._eAppDefaults.add(earDefault);
        }
    }

    public BuilderProgram getInitProgram() {
        return this._initProgram;
    }

    public void setInitProgram(BuilderProgram initProgram) {
        this._initProgram = initProgram;
    }

    public Path getEarRootDir() {
        return this._earRootDir;
    }

    public void setEarRootDir(Path rootDir) {
        this._earRootDir = rootDir;
    }

    public WebAppEntry findWebAppEntry(String name) {
        try {
            EnterpriseApplication eApp = (EnterpriseApplication)this.createLazyRedeployInstance();
            if (eApp != null) {
                return eApp.findWebAppEntry(name);
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    @Override
    protected EnterpriseApplication instantiateDeployInstance() {
        return new EnterpriseApplication(this._container, this, this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInstance(EnterpriseApplication eApp) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        Path rootDir = null;
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            Map<String, Object> varMap = eApp.getVariableMap();
            varMap.putAll(this._variableMap);
            eApp.setEarPath(this.getArchivePath());
            rootDir = this.calculateRootDirectory();
            if (rootDir == null) {
                throw new NullPointerException("Null root-directory");
            }
            eApp.setRootDirectory(rootDir);
            ArrayList<EarConfig> initList = new ArrayList<EarConfig>();
            if (this._container != null) {
                initList.addAll(this._container.getEarDefaultList());
            }
            initList.addAll(this._eAppDefaults);
            if (this._config != null) {
                initList.add(this._config);
            }
            thread.setContextClassLoader(eApp.getClassLoader());
            Vfs.setPwd(rootDir);
            this.addManifestClassPath();
            for (int i = 0; i < initList.size(); ++i) {
                EarConfig config = (EarConfig)initList.get(i);
                BuilderProgram program = config.getBuilderProgram();
                if (program == null) continue;
                program.configure(eApp);
            }
            eApp.init();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected Path calculateRootDirectory() throws ELException {
        Path rootDir = this.getRootDirectory();
        EnterpriseApplication eApp = (EnterpriseApplication)this.getDeployInstance();
        if (rootDir == null && eApp != null) {
            rootDir = eApp.getRootDirectory();
        }
        return rootDir;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EarEntry)) {
            return false;
        }
        EarEntry entry = (EarEntry)o;
        return this.getName().equals(entry.getName());
    }

    @Override
    public String toString() {
        return new StringBuffer().append("EarEntry[").append(this.getName()).append("]").toString();
    }
}

