/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.hmux.HmuxRequest;
import com.caucho.server.host.Host;
import com.caucho.server.resin.ServletServer;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.WebAppEntry;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.Crc64;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmuxDispatchRequest {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/hmux/HmuxDispatchRequest"));
    public static final int HMUX_HOST = 104;
    public static final int HMUX_QUERY_ALL = 113;
    public static final int HMUX_QUERY_URL = 114;
    public static final int HMUX_QUERY_SERVER = 115;
    public static final int HMUX_WEB_APP = 97;
    public static final int HMUX_MATCH = 109;
    public static final int HMUX_IGNORE = 105;
    public static final int HMUX_ETAG = 101;
    public static final int HMUX_NO_CHANGE = 110;
    public static final int HMUX_CLUSTER = 99;
    public static final int HMUX_SRUN = 115;
    public static final int HMUX_SRUN_BACKUP = 98;
    private CharBuffer _cb = new CharBuffer();
    private HmuxRequest _request;
    private ServletServer _server;
    private int _srunIndex;

    public HmuxDispatchRequest(HmuxRequest request) {
        this._request = request;
        this._server = (ServletServer)request.getDispatchServer();
    }

    public boolean handleRequest(ReadStream is, WriteStream os) throws IOException {
        CharBuffer cb = this._cb;
        boolean isLoggable = log.isLoggable(Level.FINE);
        String host = "";
        String etag = null;
        block8: while (true) {
            int len;
            int code = is.read();
            switch (code) {
                case -1: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + "end of file");
                    }
                    return false;
                }
                case 81: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + ": end of request");
                    }
                    os.write(81);
                    return true;
                }
                case 88: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + ": end of socket");
                    }
                    return false;
                }
                case 101: {
                    len = (is.read() << 8) + is.read();
                    this._cb.clear();
                    is.readAll(this._cb, len);
                    etag = this._cb.toString();
                    if (!isLoggable) continue block8;
                    log.fine(this.dbgId() + "etag: " + etag);
                    continue block8;
                }
                case 104: {
                    len = (is.read() << 8) + is.read();
                    this._cb.clear();
                    is.readAll(this._cb, len);
                    host = this._cb.toString();
                    if (!isLoggable) continue block8;
                    log.fine(this.dbgId() + "host: " + host);
                    continue block8;
                }
                case 113: {
                    len = (is.read() << 8) + is.read();
                    this._cb.clear();
                    is.readAll(this._cb, len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + "query: " + this._cb);
                    }
                    this.queryAll(os, host, this._cb.toString(), etag);
                    continue block8;
                }
            }
            len = (is.read() << 8) + is.read();
            if (isLoggable) {
                log.fine(this.dbgId() + (char)code + " " + len + " (dispatch)");
            }
            is.skip(len);
        }
    }

    private void queryAll(WriteStream os, String hostName, String url, String etag) throws IOException {
        int channel = 2;
        boolean isLoggable = log.isLoggable(Level.FINE);
        os.write(67);
        os.write(channel >> 8);
        os.write(channel);
        Host host = this._server.getHost(hostName, 80);
        if (host == null || !host.isActive()) {
            this.queryServer(os);
            this.writeString(os, 110, "");
            if (isLoggable) {
                log.fine(this.dbgId() + "host '" + host + "' not active");
            }
            return;
        }
        if (etag != null) {
            if (etag.equals(host.getConfigETag())) {
                if (isLoggable) {
                    log.fine(this.dbgId() + "host '" + host + "' no change");
                }
                this.writeString(os, 110, "");
                return;
            }
            if (isLoggable) {
                log.fine(this.dbgId() + "host '" + host + "' changed");
            }
        }
        long crc64 = 0L;
        this.queryServer(os);
        this.writeString(os, 104, host.getHostName());
        if (hostName.equals(host.getHostName())) {
            crc64 = this.queryCluster(os, host, crc64);
            WebAppEntry entry = host.findByURI(url);
            if (entry != null) {
                try {
                    entry.createLazyInstance(true);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            ArrayList<WebAppEntry> appList = host.getApplicationList();
            for (int i = 0; i < appList.size(); ++i) {
                String pattern;
                int j;
                WebAppEntry appEntry = appList.get(i);
                if (appEntry.getParent() != null && appEntry.getParent().isDynamicDeploy()) continue;
                this.writeString(os, 97, appEntry.getContextPath());
                if (isLoggable) {
                    log.fine(this.dbgId() + "web-app '" + appEntry.getContextPath() + "'");
                }
                crc64 = Crc64.generate(crc64, appEntry.getContextPath());
                Application app = appEntry.getApplication();
                if (appEntry.isDynamicDeploy()) {
                    this.writeString(os, 109, "/*");
                    crc64 = Crc64.generate(crc64, "/*");
                    if (!isLoggable) continue;
                    log.fine(this.dbgId() + "dynamic '" + appEntry.getContextPath() + "'");
                    continue;
                }
                if (app == null || !app.isActive()) {
                    if (isLoggable) {
                        log.fine(this.dbgId() + "not active '" + appEntry.getContextPath() + "'");
                    }
                    this.writeString(os, 110, "");
                    continue;
                }
                if (isLoggable) {
                    log.fine(this.dbgId() + "active '" + appEntry.getContextPath() + "'");
                }
                ArrayList<String> patternList = app.getServletMappingPatterns();
                for (j = 0; patternList != null && j < patternList.size(); ++j) {
                    pattern = patternList.get(j);
                    this.writeString(os, 109, pattern);
                    crc64 = Crc64.generate(crc64, pattern);
                }
                patternList = app.getServletIgnoreMappingPatterns();
                for (j = 0; patternList != null && j < patternList.size(); ++j) {
                    pattern = patternList.get(j);
                    this.writeString(os, 105, pattern);
                    crc64 = Crc64.generate(crc64, "i");
                    crc64 = Crc64.generate(crc64, pattern);
                }
            }
            CharBuffer cb = CharBuffer.allocate();
            Base64.encode(cb, crc64);
            String newETag = cb.close();
            host.setConfigETag(newETag);
        }
        this.writeString(os, 101, host.getConfigETag());
    }

    private long queryCluster(WriteStream os, Host host, long crc64) throws IOException {
        Cluster cluster = host.getCluster();
        if (cluster == null) {
            return 0L;
        }
        this.writeString(os, 99, cluster.getId());
        crc64 = Crc64.generate(crc64, cluster.getId());
        this.writeString(os, 72, "live-time");
        this.writeString(os, 83, "" + cluster.getClientLiveTime() / 1000L);
        this.writeString(os, 72, "dead-time");
        this.writeString(os, 83, "" + cluster.getClientDeadTime() / 1000L);
        ClusterServer[] servers = cluster.getServerList();
        for (int i = 0; i < servers.length; ++i) {
            ClusterServer server = servers[i];
            if (server == null) continue;
            String srunHost = server.getHost() + ":" + server.getPort();
            if (server.isBackup()) {
                this.writeString(os, 98, srunHost);
            } else {
                this.writeString(os, 115, srunHost);
            }
            crc64 = Crc64.generate(crc64, srunHost);
        }
        return crc64;
    }

    private void queryServer(WriteStream os) throws IOException {
        this.writeString(os, 72, "check-interval");
        this.writeString(os, 83, String.valueOf(this._server.getDependencyCheckInterval() / 1000L));
        this.writeString(os, 72, "cookie");
        this.writeString(os, 83, this._server.getSessionCookie());
        this.writeString(os, 72, "session-url-prefix");
        this.writeString(os, 83, this._server.getSessionURLPrefix());
        this.writeString(os, 72, "alt-session-url-prefix");
        this.writeString(os, 83, this._server.getAlternateSessionURLPrefix());
    }

    void writeString(WriteStream os, int code, String value) throws IOException {
        if (value == null) {
            value = "";
        }
        int len = value.length();
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(value);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (char)code + " " + value);
        }
    }

    void writeString(WriteStream os, int code, CharBuffer value) throws IOException {
        int len = value.length();
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(value);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (char)code + " " + value);
        }
    }

    private String dbgId() {
        return this._request.dbgId();
    }
}

