/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.jmx.Jmx;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.log.Log;
import com.caucho.make.AlwaysModified;
import com.caucho.make.Dependency;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostEntry;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.servlet.jsp.el.VariableResolver;
import org.iso_relax.verifier.Schema;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Host
extends ApplicationContainer
implements EnvironmentBean,
Dependency,
SchemaBean,
DeployInstance {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/host/Host"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/host/Host"));
    private static SoftReference<Schema> _schemaRef;
    private HostContainer _parent;
    private HostEntry _hostEntry;
    private HashMap<String, Object> _variableMap = new HashMap();
    private LinkedHashMap<String, String> _jmxContext;
    private VariableResolver _variableResolver;
    private String _hostName = "";
    private String _url;
    private ObjectName _objectName;
    private String _serverName = "";
    private int _serverPort = 0;
    private String _secureHostName;
    private boolean _isDefaultHost;
    private ArrayList<String> _aliasList = new ArrayList();
    private Throwable _configException;
    private boolean _isRootDirSet;
    private boolean _isDocDirSet;
    private String _configETag = null;
    private final Lifecycle _lifecycle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host(HostContainer parent, HostEntry hostEntry, String hostName) {
        super(new EnhancingClassLoader());
        try {
            this._hostEntry = hostEntry;
            EnvironmentClassLoader classLoader = this.getEnvironmentClassLoader();
            classLoader.setOwner(this);
            this._variableMap.putAll(this._hostEntry.getVariableMap());
            VariableResolver parentResolver = EL.getEnvironment();
            this._variableResolver = new MapVariableResolver(this._variableMap, parentResolver);
            EL.setEnvironment(this._variableResolver, classLoader);
            EL.setVariableMap(this._variableMap, classLoader);
            this.setParent(parent);
            this.setHostName(hostName);
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(classLoader);
                this._jmxContext = Jmx.copyContextProperties();
                if (hostName.equals("")) {
                    this._jmxContext.put("Host", "default");
                } else {
                    this._jmxContext.put("Host", hostName);
                }
                Jmx.setContextProperties(this._jmxContext, this.getEnvironmentClassLoader());
                try {
                    Jmx.register(hostEntry.getMBean(), new ObjectName("resin:type=CurrentHost"), this.getEnvironmentClassLoader());
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
        catch (Throwable e) {
            this._configException = e;
        }
        this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
    }

    private void setHostName(String name) throws ConfigException {
        this._hostName = name;
        if (name.equals("")) {
            this._isDefaultHost = true;
        }
        this.addHostAlias(name);
        this.getEnvironmentClassLoader().setId(new StringBuffer().append("host:").append(name).toString());
        int p = name.indexOf("://");
        if (p >= 0) {
            name = name.substring(p + 3);
        }
        this._serverName = name;
        p = name.lastIndexOf(58);
        if (p > 0) {
            this._serverName = name.substring(0, p);
            boolean isPort = true;
            int port = 0;
            ++p;
            while (p < name.length()) {
                char ch = name.charAt(p);
                if ('0' <= ch && ch <= '9') {
                    port = 10 * port + ch - 48;
                } else {
                    isPort = false;
                }
                ++p;
            }
            if (isPort) {
                this._serverPort = port;
            }
        }
    }

    public String getName() {
        return this._hostEntry.getName();
    }

    @Override
    public String getHostName() {
        return this._hostName;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public String getSecureHostName() {
        return this._secureHostName;
    }

    public void setSecureHostName(String secureHostName) {
        this._secureHostName = secureHostName;
    }

    @Override
    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        super.setEnvironmentClassLoader(loader);
        loader.setOwner(this);
    }

    @Override
    public Schema getSchema() {
        Schema schema = null;
        if (_schemaRef == null || (schema = _schemaRef.get()) == null) {
            String schemaName = "com/caucho/server/host/host.rnc";
            try {
                schema = CompactVerifierFactoryImpl.compileFromResource(schemaName);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
                log.warning(e.toString());
            }
            _schemaRef = new SoftReference<Schema>(schema);
        }
        return schema;
    }

    @Override
    public String getURL() {
        if (this._url != null) {
            return this._url;
        }
        if (this._hostName.equals("")) {
            return "";
        }
        if (this._hostName.startsWith("http:") || this._hostName.startsWith("https:")) {
            return this._hostName;
        }
        return new StringBuffer().append("http://").append(this._hostName).toString();
    }

    public void addHostAlias(String name) {
        if (!this._aliasList.contains(name = name.toLowerCase())) {
            this._aliasList.add(name);
        }
        if (name.equals("") || name.equals("*")) {
            this._isDefaultHost = true;
        }
        this._hostEntry.addExtHostAlias(name);
    }

    public ArrayList<String> getAliasList() {
        return this._aliasList;
    }

    public boolean isDefaultHost() {
        return this._isDefaultHost;
    }

    private void setParent(HostContainer parent) {
        this._parent = parent;
        this.setDispatchServer(parent.getDispatchServer());
        if (!this._isRootDirSet) {
            this.setRootDirectory(parent.getRootDirectory());
            this._isRootDirSet = false;
        }
    }

    public EnvironmentClassLoader getEnvironmentClassLoader() {
        return (EnvironmentClassLoader)this.getClassLoader();
    }

    public HashMap<String, Object> getVariableMap() {
        return this._variableMap;
    }

    public VariableResolver getVariableResolver() {
        return this._variableResolver;
    }

    @Override
    public void setRootDirectory(Path rootDir) {
        super.setRootDirectory(rootDir);
        this._isRootDirSet = true;
        if (!this._isDocDirSet) {
            this.setDocumentDirectory(rootDir);
            this._isDocDirSet = false;
        }
    }

    @Override
    public void setDocumentDirectory(Path docDir) {
        super.setDocumentDirectory(docDir);
        this._isDocDirSet = true;
    }

    @Override
    public void setConfigException(Throwable e) {
        this._configException = e;
        this.getEnvironmentClassLoader().addDependency(AlwaysModified.create());
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    public Cluster getCluster() {
        return Cluster.getCluster(this.getClassLoader());
    }

    public String getConfigETag() {
        return this._configETag;
    }

    public void setConfigETag(String etag) {
        this._configETag = etag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.getURL().equals("") && this._parent != null) {
            this._url = this._parent.getURL();
        }
        EnvironmentClassLoader loader = this.getEnvironmentClassLoader();
        loader.setId(new StringBuffer().append("host:").append(this.getURL()).toString());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            if (!this._lifecycle.toStarting()) {
                return;
            }
            super.start();
            loader.start();
            this._lifecycle.toActive();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildInvocation(Invocation invocation) throws Exception {
        invocation.setHostName(this._serverName);
        invocation.setPort(this._serverPort);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            if (this._configException == null) {
                super.buildInvocation(invocation);
            } else {
                invocation.setFilterChain(new ExceptionFilterChain(this._configException));
                invocation.setDependency(AlwaysModified.create());
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public boolean isModified() {
        return this.isDestroyed() || this.getEnvironmentClassLoader().isModified();
    }

    @Override
    public boolean isModifiedForAutomaticRedeploy() {
        return this.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            EnvironmentClassLoader envLoader = this.getEnvironmentClassLoader();
            thread.setContextClassLoader(envLoader);
            if (!this._lifecycle.toStopping()) {
                boolean bl = false;
                return bl;
            }
            super.stop();
            envLoader.stop();
            boolean bl = true;
            return bl;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            this._lifecycle.toStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (this.isDestroyed()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        EnvironmentClassLoader classLoader = this.getEnvironmentClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            super.destroy();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            classLoader.destroy();
        }
    }

    public String toString() {
        return new StringBuffer().append("Host[").append(this.getHostName()).append("]").toString();
    }
}

