/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.types.PathBuilder;
import com.caucho.config.types.StringBuilder;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.make.AlwaysModified;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.dispatch.DispatchBuilder;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.host.DomainName;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostEntry;
import com.caucho.server.host.HostExpandDeploy;
import com.caucho.server.host.HostRegexpDeploy;
import com.caucho.server.host.HostSingleDeploy;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostContainer
implements DispatchBuilder {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/host/HostContainer"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/host/HostContainer"));
    private EnvironmentClassLoader _classLoader;
    private DispatchServer _dispatchServer;
    private String _url = "";
    private Path _rootDir;
    private boolean _isRootDirSet;
    private ArrayList<HostConfig> _hostDefaultList = new ArrayList();
    private DeployContainer<HostEntry> _hostDeploy = new DeployContainer();
    private ArrayList<HostEntry> _hostList = new ArrayList();
    private HashMap<String, HostEntry> _hostMap = new HashMap();
    private HostEntry _defaultHost;
    private ArrayList<HostConfig> _hostRegexpList = new ArrayList();
    private ArrayList<WebAppConfig> _webAppDefaultList = new ArrayList();
    private Throwable _configException;
    private final Lifecycle _lifecycle = new Lifecycle();

    public HostContainer() {
        this._classLoader = new EnvironmentClassLoader();
        this._rootDir = Vfs.lookup();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setClassLoader(EnvironmentClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setURL(String url) {
        this._url = url;
    }

    public String getURL() {
        return this._url;
    }

    public void setDispatchServer(DispatchServer server) {
        this._dispatchServer = server;
    }

    public DispatchServer getDispatchServer() {
        return this._dispatchServer;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    public void setRootDirectory(Path path) {
        this._rootDir = path;
        this._isRootDirSet = true;
    }

    public void setRootDir(Path path) {
        this.setRootDirectory(path);
    }

    public void addHostDefault(HostConfig init) {
        this._hostDefaultList.add(init);
    }

    public ArrayList<HostConfig> getHostDefaultList() {
        return this._hostDefaultList;
    }

    public HostExpandDeploy createHostDeploy() {
        return new HostExpandDeploy(this._hostDeploy, this);
    }

    public void addHostDeploy(HostExpandDeploy hostDeploy) {
        this._hostDeploy.add(hostDeploy);
    }

    public void addHost(HostConfig hostConfig) throws Exception {
        if (hostConfig.getRegexp() != null) {
            this._hostDeploy.add(new HostRegexpDeploy(this._hostDeploy, this, hostConfig));
            return;
        }
        HostSingleDeploy deploy = new HostSingleDeploy(this._hostDeploy, this, hostConfig);
        this._hostDeploy.add(deploy);
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._webAppDefaultList.add(init);
    }

    public ArrayList<WebAppConfig> getWebAppDefaultList() {
        return this._webAppDefaultList;
    }

    public void clearCache() {
        this._dispatchServer.clearCache();
    }

    @Override
    public void buildInvocation(Invocation invocation) throws Throwable {
        String rawHost = invocation.getHost();
        int rawPort = invocation.getPort();
        String hostName = rawHost == null ? "" : DomainName.fromAscii(rawHost);
        invocation.setHostName(hostName);
        Host host = this.getHost(hostName, rawPort);
        if (host != null) {
            host.buildInvocation(invocation);
        } else {
            ErrorFilterChain chain = new ErrorFilterChain(404);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
        }
    }

    public Host getHost(String hostName, int port) {
        try {
            HostEntry entry = this.findHost(hostName, port);
            if (entry != null) {
                return (Host)entry.createLazyRedeployInstance();
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostEntry findHost(String rawHost, int rawPort) throws Exception {
        if (rawHost == null) {
            rawHost = "";
        }
        int p = rawHost.indexOf(58);
        String shortHost = rawHost;
        if (p > 0) {
            shortHost = rawHost.substring(0, p);
        }
        String fullHost = new StringBuffer().append(shortHost).append(':').append(rawPort).toString();
        HostEntry hostEntry = null;
        HashMap<String, HostEntry> hashMap = this._hostMap;
        synchronized (hashMap) {
            hostEntry = this._hostMap.get(fullHost);
            if (hostEntry != null && !hostEntry.isDestroyed()) {
                return hostEntry;
            }
        }
        if (hostEntry == null || hostEntry.isDestroyed()) {
            hostEntry = this._hostMap.get(shortHost);
        }
        if (hostEntry == null || hostEntry.isDestroyed()) {
            hostEntry = this.findHost(fullHost);
        }
        if (hostEntry == null || hostEntry.isDestroyed()) {
            hostEntry = this.findHost(shortHost);
        }
        if (hostEntry == null || hostEntry.isDestroyed()) {
            hostEntry = this.findHost("");
        }
        hashMap = this._hostMap;
        synchronized (hashMap) {
            if (hostEntry != null && !hostEntry.isDestroyed()) {
                this._hostMap.put(fullHost, hostEntry);
            } else {
                hostEntry = null;
                this._hostMap.remove(fullHost);
            }
        }
        return hostEntry;
    }

    private HostEntry findHost(String hostName) throws Exception {
        return this._hostDeploy.findEntry(hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HostEntry createUniqueHost(HostEntry host) throws Exception {
        String rootDir;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClassLoader());
        VariableResolver env = host.getVariableResolver();
        HostConfig hostConfig = host.getHostConfig();
        String rawHostName = hostConfig.getHostName();
        if (rawHostName != null && !rawHostName.equals("")) {
            host.setHostName(StringBuilder.evalString(rawHostName, env));
        }
        ArrayList<String> rawAliases = hostConfig.getHostAliases();
        for (int i = 0; i < rawAliases.size(); ++i) {
            String rawAlias = rawAliases.get(i);
            host.addHostAlias(StringBuilder.evalString(rawAlias, env));
        }
        ArrayList<HostEntry> arrayList = this._hostList;
        synchronized (arrayList) {
            int oldHostIndex = this._hostList.indexOf(host);
            if (oldHostIndex >= 0) {
                HostEntry hostEntry = this._hostList.get(oldHostIndex);
                // MONITOREXIT @DISABLED, blocks:[0, 5, 11] lbl20 : MonitorExitStatement: MONITOREXIT : var8_9
                thread.setContextClassLoader(oldLoader);
                return hostEntry;
            }
            rootDir = hostConfig.getRootDirectory();
            if (rootDir == null) break block13;
        }
        {
            block13: {
                Path path = PathBuilder.lookupPath(rootDir, env);
                host.setCfgRootDirectory(path);
                if (hostConfig.getRegexp() != null && !path.isDirectory()) {
                    HostEntry hostEntry = null;
                    // MONITOREXIT @DISABLED, blocks:[5, 10] lbl29 : MonitorExitStatement: MONITOREXIT : var8_9
                    thread.setContextClassLoader(oldLoader);
                    return hostEntry;
                }
            }
            try {
                if (host.getHostName().equals("")) {
                    this._defaultHost = host;
                }
                this._hostList.add(host);
                host.init();
                return host;
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
    }

    public void start() {
        if (!this._lifecycle.toStarting()) {
            return;
        }
        this._classLoader.start();
        this._lifecycle.toActive();
        this._hostDeploy.start();
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        this._hostDeploy.stop();
        this._classLoader.stop();
    }

    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._hostDeploy.destroy();
        this._classLoader.destroy();
    }
}

