/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

public class ContentLengthStream
extends StreamImpl {
    private ReadStream _next;
    private int _length;

    void init(ReadStream next, int length) {
        this._next = next;
        this._length = length;
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this._length < length) {
            length = this._length;
        }
        if (length <= 0) {
            return -1;
        }
        int len = this._next.read(buffer, offset, length);
        this._length = len > 0 ? (this._length -= len) : -1;
        return len;
    }

    public int getAvailable() throws IOException {
        int available = this._next.available();
        if (this._length <= 0) {
            return 0;
        }
        if (this._length < available) {
            return this._length;
        }
        return available;
    }
}

