/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.log;

import com.caucho.config.types.Bytes;
import com.caucho.config.types.InitProgram;
import com.caucho.config.types.Period;
import com.caucho.loader.CloseListener;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessLog
extends AbstractAccessLog
implements AlarmListener {
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/log/AccessLog"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/log/AccessLog"));
    private static final long ROLLOVER_SIZE = 0x2000000L;
    private static final long DAY = 86400000L;
    private static final long ROLLOVER_CHECK_TIME = 600000L;
    private static final int BUFFER_SIZE = 65536;
    private static final int BUFFER_GAP = 8192;
    private QDate _calendar = QDate.createLocal();
    private String _timeFormat;
    private int _timeFormatSecondOffset = -1;
    private WriteStream _os;
    private Object _streamLock = new Object();
    private String _format;
    private Segment[] _segments;
    private String _rolloverPrefix;
    private String _archiveFormat;
    private long _rolloverPeriod = -1L;
    private long _rolloverSize = 0x2000000L;
    private long _rolloverCheckTime = 600000L;
    private long _nextTime = -1L;
    private final byte[] _bufferA = new byte[65536];
    private int _bufferALength;
    private final byte[] _bufferB = new byte[65536];
    private int _bufferBLength;
    private boolean _isBufferA;
    private Object _bufferLock = new Object();
    private final CharBuffer _cb = new CharBuffer();
    private final CharBuffer _timeCharBuffer = new CharBuffer();
    private final ByteBuffer _timeBuffer = new ByteBuffer();
    private long _lastTime;
    private Alarm _alarm = new Alarm(this);

    public void setFormat(String format) {
        this._format = format;
    }

    public void setArchiveFormat(String format) {
        this._archiveFormat = format;
    }

    public void setRolloverPeriod(Period period) {
        this._rolloverPeriod = period.getPeriod();
        if (this._rolloverPeriod > 0L) {
            this._rolloverPeriod += 3599999L;
            this._rolloverPeriod -= this._rolloverPeriod % 3600000L;
        } else {
            this._rolloverPeriod = -1L;
        }
    }

    public void setRolloverSize(Bytes bytes) {
        long size = bytes.getBytes();
        this._rolloverSize = size < 0L ? 0x3FFFFFFFL : size;
    }

    public void setRolloverCheckTime(long period) {
        if (period > 1000L) {
            this._rolloverCheckTime = period;
        } else if (period > 0L) {
            this._rolloverCheckTime = 1000L;
        }
    }

    public void addInit(InitProgram init) throws Throwable {
        init.init(this);
    }

    @Override
    public void init() throws ServletException, IOException {
        Environment.addClassLoaderListener(new CloseListener(this));
        if (this._path == null) {
            throw new ServletConfigException(L.l("access-log needs a path"));
        }
        this._path.getParent().mkdirs();
        this._rolloverPrefix = this._path.getTail();
        long now = Alarm.getCurrentTime();
        long lastModified = this._path.getLastModified();
        if (lastModified <= 0L) {
            lastModified = now;
        }
        this._calendar.setGMTTime(lastModified);
        long zone = this._calendar.getZoneOffset();
        if (this._rolloverPeriod < 0L) {
            this._nextTime = now + this._rolloverCheckTime;
        } else {
            this._nextTime = Period.periodEnd(lastModified, this._rolloverPeriod);
            if (log.isLoggable(Level.FINE)) {
                log.fine(new StringBuffer().append(this._path).append(": next rollover at ").append(QDate.formatLocal(this._nextTime)).toString());
            }
            if (this._nextTime <= now) {
                this.rolloverLog(now);
            }
        }
        this.openLog();
        if (this._format == null) {
            this._format = "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        ArrayList<Segment> segments = this.parseFormat(this._format);
        this._segments = new Segment[segments.size()];
        segments.toArray(this._segments);
        if (this._timeFormat == null || this._timeFormat.equals("")) {
            this._timeFormat = "[%d/%b/%Y:%H:%M:%S %z]";
            this._timeFormatSecondOffset = 18;
        }
        this._alarm.queue(60000L);
    }

    private ArrayList<Segment> parseFormat(String format) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        CharBuffer cb = new CharBuffer();
        int i = 0;
        block4: while (i < this._format.length()) {
            char ch;
            if ((ch = this._format.charAt(i++)) != '%' || i >= this._format.length()) {
                cb.append(ch);
                continue;
            }
            String arg = null;
            if ((ch = this._format.charAt(i++)) == '>') {
                ch = this._format.charAt(i++);
            } else if (ch == '{') {
                if (cb.length() > 0) {
                    segments.add(new Segment(this, 0, cb.toString()));
                }
                cb.clear();
                while (i < this._format.length() && this._format.charAt(i++) != '}') {
                    cb.append(this._format.charAt(i - 1));
                }
                arg = cb.toString();
                cb.clear();
                ch = this._format.charAt(i++);
            }
            switch (ch) {
                case 'T': 
                case 'U': 
                case 'b': 
                case 'c': 
                case 'h': 
                case 'i': 
                case 'l': 
                case 'n': 
                case 'o': 
                case 'r': 
                case 's': 
                case 'u': {
                    if (cb.length() > 0) {
                        segments.add(new Segment(this, 0, cb.toString()));
                    }
                    cb.clear();
                    segments.add(new Segment(this, ch, arg));
                    continue block4;
                }
                case 't': {
                    if (cb.length() > 0) {
                        segments.add(new Segment(this, 0, cb.toString()));
                    }
                    cb.clear();
                    if (arg != null) {
                        this._timeFormat = arg;
                    }
                    segments.add(new Segment(this, ch, arg));
                    continue block4;
                }
            }
            cb.append('%');
            --i;
        }
        cb.append(CauchoSystem.getNewlineString());
        segments.add(new Segment(this, 0, cb.toString()));
        return segments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(HttpServletRequest req, HttpServletResponse res, ServletContext application) throws IOException {
        AbstractHttpRequest request = (AbstractHttpRequest)req;
        AbstractHttpResponse response = (AbstractHttpResponse)res;
        long now = Alarm.getCurrentTime();
        if (this._nextTime < now) {
            this.rolloverLog(now);
        }
        Object writeBuffer = null;
        boolean writeLength = false;
        while (true) {
            Object object = this._bufferLock;
            synchronized (object) {
                if (this._isBufferA) {
                    byte[] bufferA = this._bufferA;
                    int lengthA = this._bufferALength;
                    if (lengthA + 8192 <= 65536) {
                        byte[] byArray = bufferA;
                        synchronized (bufferA) {
                            this._bufferALength = lengthA = this.log(request, response, bufferA, lengthA, 65536);
                            // ** MonitorExit[var13_12] (shouldn't be in output)
                            return;
                        }
                    }
                } else {
                    byte[] bufferB = this._bufferB;
                    int lengthB = this._bufferBLength;
                    if (lengthB + 8192 <= 65536) {
                        byte[] byArray = bufferB;
                        synchronized (bufferB) {
                            this._bufferBLength = lengthB = this.log(request, response, bufferB, lengthB, 65536);
                            // ** MonitorExit[var13_13] (shouldn't be in output)
                            return;
                        }
                    }
                }
            }
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int log(AbstractHttpRequest request, AbstractHttpResponse response, byte[] buffer, int offset, int length) throws IOException {
        block21: for (Segment segment : this._segments) {
            String value = null;
            Object cbValue = null;
            CharSegment csValue = null;
            switch (segment._code) {
                case 0: {
                    int sublen = segment._data.length;
                    byte[] data = segment._data;
                    for (int j = 0; j < sublen; ++j) {
                        buffer[offset++] = data[j];
                    }
                    continue block21;
                }
                case 1: {
                    buffer[offset++] = segment._ch;
                    continue block21;
                }
                case 98: {
                    if (response.getStatusCode() == 304) {
                        buffer[offset++] = 45;
                        continue block21;
                    }
                    offset = this.print(buffer, offset, response.getContentLength());
                    continue block21;
                }
                case 99: {
                    Cookie cookie = request.getCookie(segment._string);
                    if (cookie == null) {
                        cookie = response.getCookie(segment._string);
                    }
                    if (cookie == null) {
                        buffer[offset++] = 45;
                        continue block21;
                    }
                    offset = this.print(buffer, offset, cookie.getValue());
                    continue block21;
                }
                case 2: {
                    ArrayList cookies = response.getCookies();
                    if (cookies == null || cookies.size() == 0) {
                        buffer[offset++] = 45;
                        continue block21;
                    }
                    this._cb.clear();
                    response.fillCookie(this._cb, (Cookie)cookies.get(0), 0L, 0);
                    offset = this.print(buffer, offset, this._cb.getBuffer(), 0, this._cb.getLength());
                    continue block21;
                }
                case 104: {
                    offset = request.printRemoteAddr(buffer, offset);
                    continue block21;
                }
                case 105: {
                    csValue = request.getHeaderBuffer(segment._string);
                    if (csValue == null) {
                        buffer[offset++] = 45;
                        continue block21;
                    }
                    offset = this.print(buffer, offset, csValue);
                    continue block21;
                }
                case 108: {
                    buffer[offset++] = 45;
                    continue block21;
                }
                case 110: {
                    Object oValue = request.getAttribute(segment._string);
                    if (oValue == null) {
                        buffer[offset++] = 45;
                        continue block21;
                    }
                    offset = this.print(buffer, offset, String.valueOf(oValue));
                    continue block21;
                }
                case 111: {
                    value = response.getHeader(segment._string);
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block21;
                    }
                    offset = this.print(buffer, offset, value);
                    continue block21;
                }
                case 114: {
                    offset = this.print(buffer, offset, request.getMethod());
                    buffer[offset++] = 32;
                    byte[] data = request.getUriBuffer();
                    int sublen = request.getUriLength();
                    for (int j = sublen - 1; j >= 0; --j) {
                        buffer[offset + j] = data[j];
                    }
                    offset += sublen;
                    buffer[offset++] = 32;
                    offset = this.print(buffer, offset, request.getProtocol());
                    continue block21;
                }
                case 115: {
                    int status = response.getStatusCode();
                    buffer[offset++] = (byte)(48 + status / 100 % 10);
                    buffer[offset++] = (byte)(48 + status / 10 % 10);
                    buffer[offset++] = (byte)(48 + status % 10);
                    continue block21;
                }
                case 116: {
                    long date = Alarm.getCurrentTime();
                    if (date / 1000L != this._lastTime / 1000L) {
                        this.fillTime(date);
                    }
                    int sublen = this._timeBuffer.getLength();
                    byte[] data = this._timeBuffer.getBuffer();
                    ByteBuffer byteBuffer = this._timeBuffer;
                    synchronized (byteBuffer) {
                        System.arraycopy(data, 0, buffer, offset, sublen);
                    }
                    offset += sublen;
                    continue block21;
                }
                case 84: {
                    long startTime = request.getStartTime();
                    long now = Alarm.getCurrentTime();
                    offset = this.print(buffer, offset, (int)((now - startTime + 500L) / 1000L));
                    continue block21;
                }
                case 117: {
                    value = request.getRemoteUser(false);
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block21;
                    }
                    buffer[offset++] = 34;
                    offset = this.print(buffer, offset, value);
                    buffer[offset++] = 34;
                    continue block21;
                }
                case 85: {
                    offset = this.print(buffer, offset, request.getRequestURI());
                    continue block21;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rolloverLog(long now) {
        Object object = this._streamLock;
        synchronized (object) {
            String savedName = null;
            if (this._rolloverPeriod > 0L) {
                savedName = this.getArchiveName(this._nextTime - 1L);
            } else if (this._rolloverPeriod < 0L && this._rolloverSize <= this._path.getLength()) {
                savedName = this.getArchiveName(this._nextTime - 1L);
            }
            if (this._rolloverPeriod > 0L) {
                this._nextTime = Period.periodEnd(now, this._rolloverPeriod);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(new StringBuffer().append(this._path).append(": next rollover at ").append(QDate.formatLocal(this._nextTime)).toString());
                }
            } else {
                this._nextTime = now + this._rolloverCheckTime;
            }
            if (savedName != null) {
                try {
                    if (this._os != null) {
                        this.flush();
                    }
                    this._os = null;
                    String tail = this._path.getTail();
                    Path newPath = this._path.getParent().lookup(savedName);
                    try {
                        newPath.getParent().mkdirs();
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                    try {
                        WriteStream os = newPath.openWrite();
                        OutputStream out = savedName.endsWith(".gz") ? new GZIPOutputStream(os) : (savedName.endsWith(".zip") ? new ZipOutputStream(os) : os);
                        try {
                            this._path.writeToStream(out);
                        }
                        finally {
                            try {
                                out.close();
                            }
                            catch (Throwable e) {
                                log.log(Level.WARNING, e.toString(), e);
                            }
                            os.close();
                        }
                        this._path.remove();
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
                catch (IOException e) {
                    log.log(Level.INFO, e.toString(), e);
                }
                this.openLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openLog() {
        try {
            this._path.getParent().mkdirs();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        Object object = this._streamLock;
        synchronized (object) {
            for (int i = 0; i < 3 && this._os == null; ++i) {
                try {
                    this._os = this._path.openAppend();
                    continue;
                }
                catch (IOException e) {
                    log.log(Level.INFO, e.toString(), e);
                }
            }
            if (this._os == null) {
                log.warning(L.l("Can't open access log file '{0}'.", this._path));
            }
        }
    }

    protected String getArchiveName(long time) {
        if (time <= 0L) {
            time = Alarm.getCurrentTime();
        }
        if (this._archiveFormat != null) {
            return QDate.formatLocal(time, this._archiveFormat);
        }
        if (this._rolloverPeriod % 86400000L == 0L) {
            return new StringBuffer().append(this._rolloverPrefix).append(".").append(QDate.formatLocal(time, "%Y%m%d")).toString();
        }
        return new StringBuffer().append(this._rolloverPrefix).append(".").append(QDate.formatLocal(time, "%Y%m%d.%H")).toString();
    }

    private int print(byte[] buffer, int offset, CharSegment cb) {
        char[] charBuffer = cb.getBuffer();
        int cbOffset = cb.getOffset();
        int length = cb.getLength();
        if (buffer.length - offset - 256 < length) {
            length = buffer.length - offset - 256;
        }
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)charBuffer[cbOffset + i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, String s) {
        int length = s.length();
        this._cb.ensureCapacity(length);
        char[] cBuf = this._cb.getBuffer();
        s.getChars(0, length, cBuf, 0);
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)cBuf[i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, char[] cb, int cbOff, int length) {
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)cb[cbOff + i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, int v) {
        if (v == 0) {
            buffer[offset] = 48;
            return offset + 1;
        }
        if (v < 0) {
            buffer[offset++] = 45;
            v = -v;
        }
        int length = 0;
        int exp = 10;
        while (v >= exp) {
            exp = 10 * exp;
            ++length;
        }
        offset += length;
        for (int i = 0; i <= length; ++i) {
            buffer[offset - i] = (byte)(v % 10 + 48);
            v /= 10;
        }
        return offset + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush() throws IOException {
        byte[] writeBuffer;
        int writeLength;
        if (this._os == null) {
            this.openLog();
        }
        Object object = this._bufferLock;
        synchronized (object) {
            boolean isBufferA = this._isBufferA;
            if (this._isBufferA) {
                writeLength = this._bufferALength;
                if (writeLength == 0 || writeLength < 32768 && this._bufferBLength > 0) {
                    return;
                }
                writeBuffer = this._bufferA;
                this._bufferALength = 0;
                this._isBufferA = false;
            } else {
                writeLength = this._bufferBLength;
                if (writeLength == 0 || writeLength < 32768 && this._bufferALength > 0) {
                    return;
                }
                writeBuffer = this._bufferB;
                this._bufferBLength = 0;
                this._isBufferA = true;
            }
        }
        object = this._streamLock;
        synchronized (object) {
            WriteStream os = this._os;
            if (os == null) return;
            byte[] byArray = writeBuffer;
            synchronized (writeBuffer) {
                os.write(writeBuffer, 0, writeLength);
                os.flush();
                // ** MonitorExit[var6_7] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        try {
            this.flush();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            alarm = this._alarm;
            if (alarm != null) {
                alarm.queue(60000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws IOException {
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        Object object = this._streamLock;
        synchronized (object) {
            this.flush();
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTime(long date) throws IOException {
        if (date / 1000L == this._lastTime / 1000L) {
            return;
        }
        ByteBuffer byteBuffer = this._timeBuffer;
        synchronized (byteBuffer) {
            if (this._timeFormatSecondOffset >= 0 && date / 60000L == this._lastTime / 60000L) {
                byte[] bBuf = this._timeBuffer.getBuffer();
                int sec = (int)(date / 1000L % 60L);
                bBuf[this._timeFormatSecondOffset + 0] = (byte)(48 + sec / 10);
                bBuf[this._timeFormatSecondOffset + 1] = (byte)(48 + sec % 10);
            }
            this._timeCharBuffer.clear();
            QDate.formatLocal(this._timeCharBuffer, date, this._timeFormat);
            char[] cBuf = this._timeCharBuffer.getBuffer();
            int length = this._timeCharBuffer.getLength();
            this._timeBuffer.setLength(length);
            byte[] bBuf = this._timeBuffer.getBuffer();
            for (int i = length - 1; i >= 0; --i) {
                bBuf[i] = (byte)cBuf[i];
            }
        }
        this._lastTime = date;
    }

    static class Segment {
        static final int TEXT = 0;
        static final int CHAR = 1;
        static final int SET_COOKIE = 2;
        int _code;
        byte[] _data;
        byte _ch;
        String _string;
        AccessLog _log;

        Segment(AccessLog log, int code, String string) {
            this._log = log;
            this._code = code;
            this._string = string;
            if (string != null) {
                if (code == 111 && string.equalsIgnoreCase("Set-Cookie")) {
                    this._code = 2;
                }
                this._data = this._string.getBytes();
                if (code == 0 && this._string.length() == 1) {
                    this._ch = (byte)this._string.charAt(0);
                    this._code = 1;
                }
            }
        }
    }
}

