/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.port;

import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.server.port.Port;
import com.caucho.server.port.PortConnection;
import com.caucho.server.port.ServerRequest;
import com.caucho.util.ThreadPool;
import com.caucho.util.ThreadTask;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpConnection
extends PortConnection
implements ThreadTask {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/port/TcpConnection"));
    private QSocket _socket;
    private boolean _isInUse;
    private boolean _isActive;
    private boolean _isClosed;
    private boolean _isKeepalive;
    private boolean _isDead;
    private static int _g_id;
    private String _id = "tcp-connection-" + _g_id++;

    TcpConnection(Port port, QSocket socket) {
        this.setPort(port);
        this._socket = socket;
    }

    public void initSocket() throws IOException {
        this._isClosed = false;
        this._isInUse = true;
        this._isKeepalive = false;
        this.getWriteStream().init(this._socket.getStream());
        this.getReadStream().init(this._socket.getStream(), this.getWriteStream());
        if (log.isLoggable(Level.FINE)) {
            Port port = this.getPort();
            if (port != null) {
                log.fine("starting connection " + this + ", total=" + port.getTotalConnectionCount());
            } else {
                log.fine("starting connection " + this);
            }
        }
    }

    public QSocket getSocket() {
        return this._socket;
    }

    public QSocket startSocket() {
        this._isClosed = false;
        return this._socket;
    }

    public boolean readNonBlock() throws IOException {
        Port port = this.getPort();
        if (port.isClosed()) {
            return false;
        }
        if (this.getReadStream().getAvailable() > 0) {
            return true;
        }
        QSocket socket = this._socket;
        if (socket != null) {
            int freeThreadCount = ThreadPool.getFreeThreadCount();
            if (freeThreadCount < 50) {
                return false;
            }
            int timeout = 100;
            boolean hasData = socket.readNonBlock(timeout);
            return hasData;
        }
        return false;
    }

    public boolean isSecure() {
        if (this._isClosed) {
            return false;
        }
        return this._socket.isSecure();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void setActive(boolean isActive) {
        this._isActive = isActive;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public InetAddress getLocalAddress() {
        try {
            return this._socket.getLocalAddress();
        }
        catch (Exception e) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (Exception e1) {
                try {
                    return InetAddress.getByName("127.0.0.1");
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this._socket.getRemoteAddress();
    }

    public String getRemoteHost() {
        return this._socket.getRemoteHost();
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        return this._socket.getRemoteAddress(buffer, offset, length);
    }

    public int getRemotePort() {
        return this._socket.getRemotePort();
    }

    public String getVirtualHost() {
        return this.getPort().getVirtualHost();
    }

    public void keepalive() {
        Port port = this.getPort();
        port.keepaliveBegin(this);
        port.keepalive(this);
    }

    public void kill() {
        this._isDead = true;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Port port = this.getPort();
        boolean isKeepalive = this._isKeepalive;
        this._isKeepalive = false;
        boolean isFirst = !isKeepalive;
        ServerRequest request = this.getRequest();
        Thread thread = Thread.currentThread();
        if (isKeepalive) {
            port.keepaliveEnd(this);
        }
        port.threadBegin(this);
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        try {
            while (!this._isDead) {
                if (!isKeepalive && !port.accept(this, isFirst)) {
                    return;
                }
                isFirst = false;
                try {
                    do {
                        thread.interrupted();
                        isKeepalive = false;
                        isKeepalive = request.handleRequest();
                        thread.setContextClassLoader(systemLoader);
                    } while (isKeepalive && this.readNonBlock() && !port.isClosed());
                    if (!isKeepalive) continue;
                    return;
                }
                catch (ClientDisconnectException e) {
                    isKeepalive = false;
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.finer("[" + this.getId() + "] " + e);
                }
                catch (IOException e) {
                    isKeepalive = false;
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "[" + this.getId() + "] " + e, e);
                }
                finally {
                    if (!isKeepalive) {
                        this.closeImpl();
                    }
                    thread.setContextClassLoader(systemLoader);
                }
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            isKeepalive = false;
        }
        finally {
            port.threadEnd(this);
            if (isKeepalive) {
                this._isKeepalive = true;
                this.keepalive();
            } else {
                this.free();
            }
        }
    }

    public void closeOnShutdown() {
        QSocket socket = this._socket;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl() {
        boolean isClosed;
        QSocket socket = this._socket;
        TcpConnection tcpConnection = this;
        synchronized (tcpConnection) {
            isClosed = this._isClosed;
            this._isClosed = true;
        }
        if (!isClosed) {
            this._isActive = false;
            boolean isKeepalive = this._isKeepalive;
            this._isKeepalive = false;
            Port port = this.getPort();
            if (isKeepalive) {
                port.keepaliveEnd(this);
            }
            if (log.isLoggable(Level.FINE) && this._isInUse) {
                Object serverId = Environment.getAttribute("caucho.server-id");
                String prefix = "";
                if (serverId != null) {
                    prefix = "[" + serverId + "] ";
                }
                if (port != null) {
                    log.fine(prefix + "closing connection " + this + ", total=" + port.getTotalConnectionCount());
                } else {
                    log.fine(prefix + "closing connection " + this);
                }
            }
            this._isInUse = false;
            try {
                this.getWriteStream().close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                this.getReadStream().close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    public final void close() {
        this.closeImpl();
    }

    public final void free() {
        this.closeImpl();
        if (!this._isDead) {
            this.getPort().free(this);
        }
    }

    public String toString() {
        if (this._isActive) {
            return "TcpConnection[id=" + this._id + ",socket=" + this._socket + ",active]";
        }
        return "TcpConnection[id=" + this._id + ",socket=" + this._socket + ",port=" + this.getPort() + "]";
    }

    public void finalize() {
        this.closeImpl();
    }
}

