/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.functions.FmtFunctions;
import com.caucho.config.types.Bytes;
import com.caucho.el.AbstractVariableResolver;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.el.SystemPropertiesResolver;
import com.caucho.jmx.Jmx;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ServerListener;
import com.caucho.server.resin.ResinServerListener;
import com.caucho.server.resin.ServletServer;
import com.caucho.server.resin.ThreadPoolConfig;
import com.caucho.server.resin.mbean.ResinServerMBean;
import com.caucho.transaction.cfg.TransactionManagerConfig;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.iso_relax.verifier.Schema;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResinServer
implements EnvironmentBean,
SchemaBean,
ServerListener,
ResinServerMBean {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/resin/ResinServer"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/resin/ResinServer"));
    private static SoftReference<Schema> _schemaRef;
    private final EnvironmentLocal<String> _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    private ClassLoader _classLoader;
    private ObjectName _objectName;
    private String _serverId;
    private String _configFile;
    private String _userName;
    private String _groupName;
    private long _minFreeMemory = 0x200000L;
    private HashMap<String, Object> _variableMap = new HashMap();
    private ArrayList<ServletServer> _servers = new ArrayList();
    private ArrayList<ResinServerListener> _listeners = new ArrayList();
    private boolean _isClosing;
    private boolean _isClosed;
    private long _initialStartTime;
    private long _startTime;

    public ResinServer() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader instanceof EnvironmentClassLoader) {
            this._classLoader = (EnvironmentClassLoader)loader;
        }
        Environment.init();
        this._startTime = Alarm.getCurrentTime();
        this._variableMap.put("resinHome", CauchoSystem.getResinHome());
        this._variableMap.put("serverRoot", CauchoSystem.getServerRoot());
        this._variableMap.put("resin-home", CauchoSystem.getResinHome());
        this._variableMap.put("server-root", CauchoSystem.getServerRoot());
        Vfs.setPwd(CauchoSystem.getServerRoot());
        AbstractVariableResolver varResolver = new SystemPropertiesResolver();
        varResolver = new MapVariableResolver(this._variableMap, varResolver);
        EL.setEnvironment(varResolver);
        EL.setVariableMap(this._variableMap, loader);
        this._variableMap.put("fmt", new FmtFunctions());
        try {
            Jmx.register((Object)this, "resin:type=ResinServer");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._classLoader = loader;
    }

    @Override
    public Schema getSchema() {
        Schema schema = null;
        if (_schemaRef == null || (schema = _schemaRef.get()) == null) {
            String schemaName = "com/caucho/server/resin/resin.rnc";
            try {
                schema = CompactVerifierFactoryImpl.compileFromResource(schemaName);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
                log.warning(e.toString());
            }
            _schemaRef = new SoftReference<Schema>(schema);
        }
        return schema;
    }

    public void setServerId(String serverId) {
        this._serverId = serverId;
        this._serverIdLocal.set(serverId);
    }

    @Override
    public String getServerId() {
        return this._serverId;
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    @Override
    public String getConfigFile() {
        return this._configFile;
    }

    public ServletServer createServer() throws Exception {
        if (Alarm.isTest() && this._servers.size() == 1) {
            return this._servers.get(0);
        }
        ServletServer server = new ServletServer();
        server.setServerId(this._serverId);
        this._servers.add(server);
        server.addServerListener(this);
        return server;
    }

    public ArrayList<ServletServer> getServerList() {
        return this._servers;
    }

    public ThreadPoolConfig createThreadPool() throws Exception {
        return new ThreadPoolConfig();
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    public void setMinFreeMemory(Bytes minFreeMemory) {
        this._minFreeMemory = minFreeMemory.getBytes();
    }

    public long getMinFreeMemory() {
        return this._minFreeMemory;
    }

    public void addTransactionManager(TransactionManagerConfig tm) throws ConfigException {
        tm.start();
    }

    public void setSecurityManager(boolean useSecurityManager) {
        if (useSecurityManager && System.getSecurityManager() == null) {
            SecurityManager manager = new SecurityManager();
            System.setSecurityManager(manager);
        }
    }

    public ServletServer createHttpServer() throws Exception {
        return this.createServer();
    }

    public void addSecurityProvider(Class providerClass) throws Exception {
        if (!ClassLiteral.getClass((String)"java/security/Provider").isAssignableFrom(providerClass)) {
            throw new ConfigException(L.l("security-provider {0} must implement java.security.Provider", providerClass.getName()));
        }
        Security.addProvider((Provider)providerClass.newInstance());
    }

    public JspPropertyGroup createJsp() {
        return new JspPropertyGroup();
    }

    void setInitialStartTime(long now) {
        this._initialStartTime = now;
    }

    @Override
    public Date getInitialStartTime() {
        return new Date(this._initialStartTime);
    }

    @Override
    public Date getStartTime() {
        return new Date(this._startTime);
    }

    public void init() {
    }

    public void bindPorts() throws Exception {
        ArrayList<ServletServer> servers = this._servers;
        for (int i = 0; i < servers.size(); ++i) {
            ServletServer server = servers.get(i);
            server.bindPorts();
        }
    }

    public void start() throws Throwable {
        int uid;
        System.gc();
        this.bindPorts();
        if (this._userName != null && (uid = CauchoSystem.setUser(this._userName, this._groupName)) >= 0) {
            log.info(L.l("Running as {0}(uid={1})", (Object)this._userName, new StringBuffer().append("").append(uid).toString()));
        }
        ArrayList<ServletServer> servers = this._servers;
        for (int i = 0; i < servers.size(); ++i) {
            ServletServer server = servers.get(i);
            server.start();
        }
        Environment.start(this.getClassLoader());
    }

    public void addListener(ResinServerListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void closeEvent(DispatchServer server) {
        log.info("Received close event");
        this.destroy();
    }

    public boolean isClosing() {
        return this._isClosing;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        int i;
        ResinServer resinServer = this;
        synchronized (resinServer) {
            if (this._isClosing) {
                return;
            }
            this._isClosing = true;
        }
        try {
            ArrayList<ServletServer> servers = this._servers;
            for (i = 0; i < servers.size(); ++i) {
                ServletServer server = servers.get(i);
                server.destroy();
            }
            Environment.closeGlobal();
        }
        finally {
            this._isClosed = true;
        }
        ArrayList<ResinServerListener> listeners = this._listeners;
        for (i = 0; i < listeners.size(); ++i) {
            ResinServerListener listener = listeners.get(i);
            listener.closeEvent(this);
        }
    }
}

