/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.config.ConfigException;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.security.AbstractLogin;
import com.caucho.server.webapp.Application;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FormLogin
extends AbstractLogin {
    static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/security/FormLogin"));
    public static final String LOGIN_SAVED_PATH = "com.caucho.servlet.login.path";
    public static final String LOGIN_SAVED_QUERY = "com.caucho.servlet.login.query";
    protected String _loginPage;
    protected String _errorPage;
    protected boolean _internalForward;
    protected boolean _formURIPriority;

    public void setFormLoginPage(String formLoginPage) throws ConfigException {
        this._loginPage = formLoginPage;
        int colon = formLoginPage.indexOf(58);
        int slash = formLoginPage.indexOf(47);
        if ((colon <= 0 || colon >= slash) && slash != 0) {
            throw new ConfigException(L.l("form-login-page `{0}' must start with '/'.  The form-login-page is relative to the web-app root.", formLoginPage));
        }
    }

    public String getFormLoginPage() {
        return this._loginPage;
    }

    public void setFormErrorPage(String formErrorPage) throws ConfigException {
        this._errorPage = formErrorPage;
        if (!formErrorPage.startsWith("/")) {
            throw new ConfigException(L.l("form-error-page `{0}' must start with '/'.  The form-error-page is relative to the web-app root.", formErrorPage));
        }
    }

    public String getFormErrorPage() {
        return this._errorPage;
    }

    public boolean getInternalForward() {
        return this._internalForward;
    }

    public void setInternalForward(boolean internalForward) {
        this._internalForward = internalForward;
    }

    public boolean getFormURIPriority() {
        return this._formURIPriority;
    }

    public void setFormURIPriority(boolean formPriority) {
        this._formURIPriority = formPriority;
    }

    public void init() throws ServletException {
        super.init();
        if (this._errorPage == null) {
            this._errorPage = this._loginPage;
        }
        if (this._loginPage == null) {
            this._loginPage = this._errorPage;
        }
        if (this._loginPage == null) {
            throw new ServletException("FormLogin needs an form-login-page");
        }
    }

    public String getAuthType() {
        return "Form";
    }

    public Principal authenticate(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        Principal user = this.getUserPrincipal(request, response, application);
        if (user != null) {
            return user;
        }
        String path = request.getServletPath();
        if (path == null) {
            path = request.getPathInfo();
        } else if (request.getPathInfo() != null) {
            path = path + request.getPathInfo();
        }
        if (path.equals("")) {
            path = request.getContextPath() + "/";
            response.sendRedirect(response.encodeRedirectURL(path));
            return null;
        }
        Application app = (Application)application;
        String uri = request.getRequestURI();
        if (path.endsWith("/j_security_check")) {
            RequestDispatcher disp = application.getNamedDispatcher("j_security_check");
            if (disp == null) {
                throw new ServletException(L.l("j_security_check servlet must be defined to use form-based login."));
            }
            disp.forward(request, response);
            return null;
        }
        if (uri.equals(this._loginPage) || uri.equals(this._errorPage)) {
            request.getRequestDispatcher(path).forward(request, response);
            return null;
        }
        HttpSession session = request.getSession();
        session.putValue(LOGIN_SAVED_PATH, path);
        session.putValue(LOGIN_SAVED_QUERY, request.getQueryString());
        if (response instanceof CauchoResponse) {
            ((CauchoResponse)response).killCache();
            ((CauchoResponse)response).setNoCache(true);
        } else {
            response.setHeader("Cache-Control", "no-cache");
        }
        if (!this._loginPage.startsWith("/")) {
            response.sendRedirect(response.encodeRedirectURL(this._loginPage));
            return null;
        }
        request.setAttribute("caucho.login", "login");
        RequestDispatcher disp = app.getRequestDispatcher(this._loginPage);
        disp.forward(request, response);
        if (log.isLoggable(Level.FINE)) {
            log.fine("the form request has no authenticated user");
        }
        return null;
    }
}

