/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.log.Log;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.security.AbstractAuthenticator;
import com.caucho.server.security.CachingPrincipal;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

public class JdbcAuthenticator
extends AbstractAuthenticator {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/security/JdbcAuthenticator"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/security/JdbcAuthenticator"));
    private DataSource _dataSource;
    private String _passwordQuery = "SELECT password FROM LOGIN WHERE username=?";
    private String _cookieUpdate = "UPDATE LOGIN SET cookie=? WHERE username=?";
    private String _cookieQuery = "SELECT username FROM LOGIN where cookie=?";
    private boolean _cookieLogout;
    private String _roleQuery;
    protected boolean _useCookie;
    protected int _cookieVersion = -1;
    protected String _cookieDomain;
    protected long _cookieMaxAge = 31536000000L;
    private CharBuffer _cb = new CharBuffer();

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public String getPasswordQuery() {
        return this._passwordQuery;
    }

    public void setPasswordQuery(String query) {
        this._passwordQuery = query;
    }

    public String getCookieAuthQuery() {
        return this._cookieQuery;
    }

    public void setCookieAuthQuery(String query) {
        this._cookieQuery = query;
    }

    public String getCookieAuthUpdate() {
        return this._cookieUpdate;
    }

    public void setCookieAuthUpdate(String query) {
        this._cookieUpdate = query;
    }

    public void setCookieLogout(boolean cookieLogout) {
        this._cookieLogout = cookieLogout;
    }

    public String getRoleQuery() {
        return this._roleQuery;
    }

    public void setRoleQuery(String query) {
        this._roleQuery = query;
    }

    public boolean getUseCookie() {
        return this._useCookie;
    }

    public void setUseCookie(boolean useCookie) {
        this._useCookie = useCookie;
    }

    public int getCookieVersion() {
        return this._cookieVersion;
    }

    public void setCookieVersion(int version) {
        this._cookieVersion = version;
    }

    public String getCookieDomain() {
        return this._cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this._cookieDomain = cookieDomain;
    }

    public long getCookieMaxAge() {
        return this._cookieMaxAge;
    }

    public void setCookieMaxAge(long cookieMaxAge) {
        this._cookieMaxAge = cookieMaxAge;
    }

    public void init() throws ServletException {
        int i;
        super.init();
        if (this._dataSource == null) {
            try {
                InitialContext ic = new InitialContext();
                this._dataSource = (DataSource)ic.lookup("java:comp/env/jdbc/db-pool");
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            if (this._dataSource == null) {
                throw new ServletConfigException(L.l("Unknown database pool jdbc/db-pool."));
            }
        }
        if ((i = this._passwordQuery.indexOf(63)) < 0) {
            throw new ServletConfigException(L.l("`{0}' expects a parameter", "password-query"));
        }
        if (this._cookieQuery != null && (i = this._cookieQuery.indexOf(63)) < 0) {
            throw new ServletConfigException(L.l("`{0}' expects a parameter", "cookie-auth-query"));
        }
        if (this._cookieUpdate != null) {
            i = this._cookieUpdate.indexOf(63);
            if (i < 0) {
                throw new ServletConfigException(L.l("`{0}' expects two parameters", "cookie-auth-update"));
            }
            int j = this._cookieUpdate.indexOf(63, i + 1);
            if (j < 0) {
                throw new ServletConfigException(L.l("`{0}' expects two parameters", "cookie-auth-update"));
            }
        }
        if (this._cookieUpdate != null && this._cookieQuery == null) {
            throw new ServletConfigException(L.l("<{0}> expects `{1}'", (Object)"cookie-auth-update", "cookie-query"));
        }
        if (this._roleQuery != null && (i = this._roleQuery.indexOf(63)) < 0) {
            throw new ServletConfigException(L.l("`{0}' expects a parameter", "role-query"));
        }
    }

    public Principal loginImpl(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String password) throws ServletException {
        Principal user = this.loginImpl(username, password);
        if (this._cookieQuery == null || user == null) {
            return user;
        }
        String cookieAuth = (String)request.getAttribute("j_use_cookie_auth");
        if (cookieAuth == null) {
            cookieAuth = request.getParameter("j_use_cookie_auth");
        }
        if ("true".equals(cookieAuth) || "on".equals(cookieAuth) || this._useCookie && cookieAuth == null) {
            this.addAuthCookie(request, response, application, user);
        }
        return user;
    }

    protected void addAuthCookie(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user) {
        Application app = (Application)application;
        SessionManager sm = app.getSessionManager();
        String id = sm.createSessionId(request);
        if (this.updateCookie(user, id)) {
            Cookie cookie = new Cookie("resinauthid", id);
            cookie.setPath("/");
            if (this.getCookieVersion() >= 0) {
                cookie.setVersion(this.getCookieVersion());
            } else {
                cookie.setVersion(sm.getCookieVersion());
            }
            if (this._cookieDomain != null) {
                cookie.setDomain(this._cookieDomain);
            } else if (this.getCookieDomain() != null) {
                cookie.setDomain(this.getCookieDomain());
            } else {
                cookie.setDomain(sm.getCookieDomain());
            }
            if (this._cookieMaxAge > 0L) {
                cookie.setMaxAge((int)(this._cookieMaxAge / 1000L));
            }
            response.addCookie(cookie);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal loginImpl(String username, String password) throws ServletException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._passwordQuery);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("no such user:" + username);
                }
                Principal principal = null;
                return principal;
            }
            String dbPassword = rs.getString(1);
            if (dbPassword != null && dbPassword.equals(password)) {
                CachingPrincipal cachingPrincipal = new CachingPrincipal(username);
                return cachingPrincipal;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("mismatched password:" + username);
            }
            Principal principal = null;
            return principal;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    protected String getDigestPassword(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String realm) throws ServletException {
        String string;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String dbPassword;
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._passwordQuery);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("no such user:" + username);
                }
                String string2 = null;
                return string2;
            }
            string = dbPassword = rs.getString(1);
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
        return string;
    }

    protected Principal getUserPrincipalImpl(HttpServletRequest request, ServletContext application) throws ServletException {
        if (this._cookieQuery == null) {
            return null;
        }
        Cookie cookie = null;
        if (request instanceof CauchoRequest) {
            cookie = ((CauchoRequest)request).getCookie("resinauthid");
        } else {
            Cookie[] cookies = request.getCookies();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("resinauthid")) continue;
                cookie = cookies[i];
                break;
            }
        }
        if (cookie == null) {
            return null;
        }
        return this.authenticateCookie(cookie.getValue());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal authenticateCookie(String cookieValue) throws ServletException {
        if (this._cookieQuery == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._cookieQuery);
            stmt.setString(1, cookieValue);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                Principal principal = null;
                return principal;
            }
            String user = rs.getString(1);
            if (user != null) {
                CachingPrincipal cachingPrincipal = new CachingPrincipal(user);
                return cachingPrincipal;
            }
            Principal principal = null;
            return principal;
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCookie(Principal user, String cookieValue) {
        if (this._cookieUpdate == null || user == null || cookieValue == null) {
            return true;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._cookieUpdate);
            stmt.setString(1, cookieValue);
            stmt.setString(2, user.getName());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal principal, String role) {
        Boolean isInRole;
        if (this._roleQuery == null) {
            return principal != null && "user".equals(role);
        }
        if (principal == null || role == null) {
            return false;
        }
        CachingPrincipal cachingPrincipal = null;
        if (principal instanceof CachingPrincipal && (isInRole = (cachingPrincipal = (CachingPrincipal)principal).isInRole(role)) != null) {
            return isInRole.equals(Boolean.TRUE);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._roleQuery);
            stmt.setString(1, principal.getName());
            boolean inRole = false;
            rs = stmt.executeQuery();
            while (rs.next()) {
                String dbRole = rs.getString(1);
                if (cachingPrincipal != null) {
                    cachingPrincipal.addRole(dbRole);
                }
                if (!role.equals(dbRole)) continue;
                inRole = true;
            }
            boolean bl = inRole;
            return bl;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user) throws ServletException {
        super.logout(request, response, application, user);
        if (this._cookieLogout) {
            this.updateCookie(user, "");
        }
    }
}

