/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.config.ConfigException;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.security.MessageDigest;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PasswordDigest {
    private final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/security/PasswordDigest"));
    private String _algorithm = "MD5";
    private String _format = "base64";
    private String _realm = null;
    private MessageDigest _digest;
    private byte[] _digestBytes = new byte[256];
    private boolean _isOldEncoding;

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public String getFormat() {
        return this._format;
    }

    public void setRealm(String realm) {
        this._realm = realm;
    }

    public String getRealm() {
        return this._realm;
    }

    public void setOldEncoding(boolean isOldEncoding) {
        this._isOldEncoding = isOldEncoding;
    }

    public void addText(String value) throws ConfigException {
        int p = value.indexOf(45);
        if (p > 0) {
            String algorithm = value.substring(0, p);
            String format = value.substring(p + 1);
            this.setAlgorithm(algorithm);
            this.setFormat(format);
        } else if (value.equals("none")) {
            this.setAlgorithm(null);
            this.setAlgorithm(null);
        } else {
            throw new ConfigException(this.L.l("{0} is an illegal algorithm.  Espected MD5-hex64 or none.", value));
        }
    }

    public synchronized void init() throws ServletException {
        if (this._algorithm == null) {
            return;
        }
        try {
            this._digest = MessageDigest.getInstance(this._algorithm);
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public String getPasswordDigest(String password) throws ServletException {
        return this.getPasswordDigest(null, null, null, password, this._realm);
    }

    public String getPasswordDigest(String user, String password) throws ServletException {
        return this.getPasswordDigest(null, null, null, user, password, this._realm);
    }

    public String getPasswordDigest(String user, String password, String realm) throws ServletException {
        return this.getPasswordDigest(null, null, null, user, password, realm);
    }

    public String getPasswordDigest(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String password) throws ServletException {
        return this.getPasswordDigest(request, response, app, user, password, this._realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPasswordDigest(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String password, String realm) throws ServletException {
        if (this._digest == null) {
            this.init();
        }
        try {
            MessageDigest messageDigest = this._digest;
            synchronized (messageDigest) {
                this._digest.reset();
                this.updateDigest(this._digest, user, password, realm);
                int len = this._digest.digest(this._digestBytes, 0, this._digestBytes.length);
                return this.digestToString(this._digestBytes, len);
            }
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    protected void updateDigest(MessageDigest digest, String user, String password, String realm) {
        if (user != null) {
            PasswordDigest.addDigestUTF8(digest, user);
            digest.update((byte)58);
        }
        if (realm != null && !realm.equals("none")) {
            PasswordDigest.addDigestUTF8(digest, realm);
            digest.update((byte)58);
        }
        PasswordDigest.addDigestUTF8(digest, password);
    }

    protected static void addDigestUTF8(MessageDigest digest, String string) {
        if (string == null) {
            return;
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                digest.update((byte)ch);
                continue;
            }
            if (ch < '\u0800') {
                digest.update((byte)(192 + (ch >> 6)));
                digest.update((byte)(128 + (ch & 0x3F)));
                continue;
            }
            digest.update((byte)(224 + (ch >> 12)));
            digest.update((byte)(128 + (ch >> 6 & 0x3F)));
            digest.update((byte)(128 + (ch & 0x3F)));
        }
    }

    protected byte[] stringToDigest(String s) {
        String decode = Base64.decode(s);
        byte[] digest = new byte[decode.length()];
        for (int i = 0; i < decode.length(); ++i) {
            digest[i] = (byte)decode.charAt(i);
        }
        return digest;
    }

    protected String digestToString(byte[] digest, int len) {
        if (!this._format.equals("base64")) {
            return PasswordDigest.digestToHex(digest, len);
        }
        if (this._isOldEncoding) {
            return PasswordDigest.digestToOldBase64(digest, len);
        }
        return PasswordDigest.digestToBase64(digest, len);
    }

    protected static String digestToBase64(byte[] digest, int len) {
        CharBuffer cb = CharBuffer.allocate();
        Base64.encode(cb, digest, 0, len);
        return cb.close();
    }

    protected static String digestToOldBase64(byte[] digest, int len) {
        CharBuffer cb = CharBuffer.allocate();
        Base64.oldEncode(cb, digest, 0, len);
        return cb.close();
    }

    protected static String digestToHex(byte[] digest, int len) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < len; ++i) {
            int d1 = digest[i] >> 4 & 0xF;
            int d2 = digest[i] & 0xF;
            if (d1 >= 10) {
                cb.append((char)(d1 + 97 - 10));
            } else {
                cb.append((char)(d1 + 48));
            }
            if (d2 >= 10) {
                cb.append((char)(d2 + 97 - 10));
                continue;
            }
            cb.append((char)(d2 + 48));
        }
        return cb.close();
    }
}

