/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.security.BasicPrincipal;
import com.caucho.server.security.AbstractAuthenticator;
import com.caucho.util.Alarm;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XmlAuthenticator
extends AbstractAuthenticator {
    private Path _path;
    private Hashtable<String, User> _userMap = new Hashtable();
    private long _lastModified;
    private long _lastLength;
    private long _lastCheck;

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void addUser(User user) {
        this._userMap.put(user.getName(), user);
    }

    public synchronized void init() throws ServletException {
        super.init();
        if (this._path == null) {
            return;
        }
        try {
            Registry root = Registry.parse(this._path);
            RegistryNode registry = root.getTop();
            registry = registry.lookup("authenticator");
            if (registry == null) {
                throw new ServletException("missing auth");
            }
            Iterator<RegistryNode> iter = registry.select("user");
            while (iter.hasNext()) {
                RegistryNode node = iter.next();
                String name = node.getString("name", null);
                if (name == null && node.getValue() != null && !node.getValue().equals("")) {
                    User user = new User();
                    user.addText(node.getValue());
                    this.addUser(user);
                    continue;
                }
                String password = node.getString("password", null);
                User user = new User(name, password, new BasicPrincipal(name));
                Iterator<RegistryNode> roleIter = node.select("role");
                while (roleIter.hasNext()) {
                    RegistryNode roleNode = roleIter.next();
                    String role = roleNode.getValue();
                    if (role == null || role.equals("")) continue;
                    user.addRoles(role);
                }
                this._userMap.put(name, user);
            }
            this._lastCheck = Alarm.getCurrentTime();
            this._lastModified = this._path.getLastModified();
            this._lastLength = this._path.getLength();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    protected Principal loginImpl(HttpServletRequest request, HttpServletResponse response, ServletContext application, String userName, String password) throws ServletException {
        User user;
        if (this.isModified()) {
            this.init();
        }
        if ((user = this._userMap.get(userName)) == null) {
            return null;
        }
        if (user.getPassword().equals(password)) {
            return user.getPrincipal();
        }
        return null;
    }

    protected String getDigestPassword(HttpServletRequest request, HttpServletResponse response, ServletContext application, String userName, String realm) throws ServletException {
        User user;
        if (this.isModified()) {
            this.init();
        }
        if ((user = this._userMap.get(userName)) == null) {
            return null;
        }
        return user.getPassword();
    }

    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal principal, String role) throws ServletException {
        if (principal == null) {
            return false;
        }
        String name = principal.getName();
        User user = this._userMap.get(name);
        if (user == null) {
            return false;
        }
        String[] roles = user.getRoles();
        for (int i = roles.length - 1; i >= 0; --i) {
            if (!roles[i].equals(role)) continue;
            return true;
        }
        return false;
    }

    private boolean isModified() {
        if (this._path == null) {
            return false;
        }
        if (Alarm.getCurrentTime() < this._lastCheck + 5000L) {
            return false;
        }
        if (this._lastModified != this._path.getLastModified()) {
            return true;
        }
        if (this._lastLength != this._path.getLength()) {
            return true;
        }
        this._lastCheck = Alarm.getCurrentTime();
        return false;
    }

    public static class User {
        private String _name;
        private String _password;
        private Principal _principal;
        private String[] _roles = new String[0];

        public User() {
        }

        User(String name, String password, Principal principal) {
            this._name = name;
            this._password = password;
            this._principal = principal;
        }

        public void setName(String name) {
            this._name = name;
            if (this._principal == null) {
                this._principal = new BasicPrincipal(name);
            }
        }

        String getName() {
            return this._name;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        String getPassword() {
            return this._password;
        }

        public void setPassword(Principal principal) {
            this._principal = this._principal;
        }

        Principal getPrincipal() {
            return this._principal;
        }

        public void addRoles(String roles) {
            int head = 0;
            int length = roles.length();
            while (head < length) {
                int tail;
                char ch;
                while (head < length && ((ch = roles.charAt(head)) == ' ' || ch == ',')) {
                    ++head;
                }
                if (head >= length) {
                    return;
                }
                for (tail = head; tail < length && (ch = roles.charAt(tail)) != ' ' && ch != ','; ++tail) {
                }
                String role = roles.substring(head, tail);
                this.addRole(role);
                head = tail;
            }
        }

        void addRole(String role) {
            String[] newRoles = new String[this._roles.length + 1];
            System.arraycopy(this._roles, 0, newRoles, 0, this._roles.length);
            newRoles[this._roles.length] = role;
            this._roles = newRoles;
        }

        String[] getRoles() {
            return this._roles;
        }

        public void addText(String userParam) {
            String roles;
            String password;
            int p1 = userParam.indexOf(58);
            if (p1 < 0) {
                return;
            }
            String name = userParam.substring(0, p1);
            int p2 = userParam.indexOf(58, p1 + 1);
            if (p2 < 0) {
                password = userParam.substring(p1 + 1);
                roles = "user";
            } else {
                password = userParam.substring(p1 + 1, p2);
                roles = userParam.substring(p2 + 1);
            }
            this.setName(name);
            this.setPassword(password);
            this.addRoles(roles);
        }
    }
}

