/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.log.Log;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.Store;
import com.caucho.server.security.AbstractAuthenticator;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.server.session.SessionManager;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.L10N;
import com.caucho.vfs.IOExceptionWrapper;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements HttpSession,
CacheListener {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/session/SessionImpl"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/session/SessionImpl"));
    static final String LOGIN = "caucho.login";
    private String _id;
    protected SessionManager _manager;
    protected Map<String, Object> _values;
    private long _creationTime;
    long _accessTime;
    long _maxInactiveInterval;
    private boolean _isNew = true;
    boolean _isValid = true;
    boolean _isInvalidating = false;
    boolean _needsLoad;
    private int _useCount;
    private boolean _isChanged;
    private ClusterObject _clusterObject;
    private Principal _user;
    private int _srunIndex = -1;

    public SessionImpl(SessionManager manager, String id, long creationTime) {
        this._manager = manager;
        this._creationTime = creationTime;
        this._accessTime = creationTime;
        this._maxInactiveInterval = manager.getSessionTimeout();
        this._id = id;
        char ch = id.charAt(0);
        if (ch >= 'a' && ch <= 'z') {
            this._srunIndex = ch - 97;
        }
        this._values = this.createValueMap();
        if (log.isLoggable(Level.FINE)) {
            log.fine(new StringBuffer().append("create session ").append(id).toString());
        }
    }

    @Override
    public long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public String getId() {
        return this._id;
    }

    int getSrunIndex() {
        return this._srunIndex;
    }

    void setClusterObject(ClusterObject clusterObject) {
        this._clusterObject = clusterObject;
    }

    @Override
    public long getLastAccessedTime() {
        return this._accessTime;
    }

    @Override
    public int getMaxInactiveInterval() {
        if (0x3FFFFFFFFFFFFFFFL <= this._maxInactiveInterval) {
            return -1;
        }
        return (int)(this._maxInactiveInterval / 1000L);
    }

    @Override
    public void setMaxInactiveInterval(int value) {
        this._maxInactiveInterval = value < 0 ? 0x3FFFFFFFFFFFFFFFL : (long)value * 1000L;
    }

    @Override
    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Override
    public ServletContext getServletContext() {
        return this._manager.getApplication();
    }

    public SessionManager getManager() {
        return this._manager;
    }

    public ServletAuthenticator getAuthenticator() {
        return this._manager.getApplication().getAuthenticator();
    }

    public Principal getUser() {
        if (this._user != null) {
            return this._user;
        }
        if (this._isValid) {
            this._user = (Principal)this.getAttribute(LOGIN);
        }
        return this._user;
    }

    public void setUser(Principal user) {
        this._user = user;
        this.setAttribute(LOGIN, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("Can't call getAttribute() when session is no longer valid."));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            return this._values.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, Object value) {
        ArrayList<HttpSessionAttributeListener> listeners;
        HttpSessionBindingListener listener;
        Object oldValue;
        if (!this._isValid) {
            throw new IllegalStateException(L.l("Can't call setAttribute(String, Object) when session is no longer valid."));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            oldValue = value != null ? this._values.put(name, value) : this._values.remove(name);
        }
        if (this._clusterObject != null && value != oldValue) {
            this._clusterObject.change();
        }
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent(this, name, oldValue));
        }
        if (value instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)value;
            listener.valueBound(new HttpSessionBindingEvent(this, name, value));
        }
        if ((listeners = this._manager.getAttributeListeners()) != null) {
            HttpSessionBindingEvent event = oldValue != null ? new HttpSessionBindingEvent(this, name, oldValue) : new HttpSessionBindingEvent(this, name, value);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener2 = listeners.get(i);
                if (oldValue != null) {
                    listener2.attributeReplaced(event);
                    continue;
                }
                listener2.attributeAdded(event);
            }
        }
    }

    protected Map<String, Object> createValueMap() {
        return new Hashtable<String, Object>(8);
    }

    @Override
    public void removeAttribute(String name) {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("Can't call removeAttribute(String) when session is no longer valid."));
        }
        Object oldValue = this._values.remove(name);
        if (this._clusterObject != null && oldValue != null) {
            this._clusterObject.change();
        }
        this.notifyValueUnbound(name, oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration getAttributeNames() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (!this._isValid) {
                throw new IllegalStateException(L.l("Can't call getAttributeNames() when session is no longer valid."));
            }
            return Collections.enumeration(this._values.keySet());
        }
    }

    @Override
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Override
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Override
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getValueNames() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (!this._isValid) {
                throw new IllegalStateException(L.l("Can't call getValueNames() when session is no longer valid."));
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] s = new String[this._values.size()];
            Enumeration e = this.getAttributeNames();
            int count = 0;
            while (e.hasMoreElements()) {
                s[count++] = (String)e.nextElement();
            }
            return s;
        }
    }

    @Override
    public boolean isNew() {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("Can't call isNew() when session is no longer valid."));
        }
        return this._isNew;
    }

    public boolean isValid() {
        return this._isValid;
    }

    void setValid(boolean isValid) {
        this._isValid = isValid;
    }

    @Override
    public void removeEvent() {
        boolean isValid = this._isValid;
        this._manager.decrementSessionCount();
        if (log.isLoggable(Level.FINE)) {
            log.fine(new StringBuffer().append("remove session ").append(this._id).toString());
        }
        long now = Alarm.getCurrentTime();
        Store store = this._manager.getSessionStore();
        if (this._isInvalidating || store == null || this._accessTime + store.getMaxIdleTime() < now) {
            this.notifyDestroy();
        }
        this.invalidateLocal();
    }

    private void notifyDestroy() {
        ArrayList<HttpSessionListener> listeners = this._manager.getListeners();
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent(this);
            for (int i = listeners.size() - 1; i >= 0; --i) {
                HttpSessionListener listener = listeners.get(i);
                listener.sessionDestroyed(event);
            }
        }
    }

    @Override
    public void invalidate() {
        this._isInvalidating = true;
        this.invalidate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(boolean isLRU) {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("Can't call invalidate() when session is no longer valid."));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(new StringBuffer().append("invalidate session ").append(this._id).toString());
        }
        ServletAuthenticator auth = this.getAuthenticator();
        if (!isLRU || !(auth instanceof AbstractAuthenticator) || ((AbstractAuthenticator)auth).getLogoutOnSessionTimeout()) {
            this.logout();
        }
        try {
            this._manager.removeSession(this);
            this.invalidateImpl();
            this._isValid = false;
        }
        finally {
            this._isValid = false;
        }
    }

    public void logout() {
        if (this._user != null) {
            if (this._isValid) {
                this.removeAttribute(LOGIN);
            }
            Principal user = this._user;
            this._user = null;
            try {
                ServletAuthenticator auth = this.getAuthenticator();
                if (auth != null) {
                    auth.logout(this._manager.getApplication(), this._id, user);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    void invalidateImpl() {
        boolean invalidateAfterListener = this._manager.isInvalidateAfterListener();
        if (!invalidateAfterListener) {
            this._isValid = false;
        }
        try {
            ClusterObject clusterObject = this._clusterObject;
            this._clusterObject = null;
            if (clusterObject != null) {
                clusterObject.remove();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.invalidateLocal();
    }

    private void invalidateLocal() {
        ClusterObject clusterObject = this._clusterObject;
        if (this._isValid && !this._isInvalidating && clusterObject != null) {
            clusterObject.update();
            if (this._manager.getSaveOnlyOnShutdown()) {
                try {
                    clusterObject.store(this);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Can't serialize session", e);
                }
            }
        }
        this.unbind();
    }

    void create(long now) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(new StringBuffer().append("create session ").append(this._id).toString());
        }
        if (this._isValid) {
            this.unbind();
        }
        this._isValid = true;
        this._isNew = true;
        this._accessTime = now;
        this._creationTime = now;
    }

    public boolean inUse() {
        return this._useCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUse() {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            ++this._useCount;
        }
    }

    void reset(long now) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(new StringBuffer().append("reset session ").append(this._id).toString());
        }
        this.unbind();
        this._isValid = true;
        this._isNew = true;
        this._accessTime = now;
        this._creationTime = now;
    }

    public boolean load() {
        if (this._clusterObject != null) {
            return this._clusterObject.load(this);
        }
        return true;
    }

    public void passivate() {
        this.unbind();
    }

    public void unbind() {
        if (this._values.size() == 0) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this._values.keySet()) {
            names.add(name);
        }
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            Object value = null;
            value = this._values.remove(name);
            this.notifyValueUnbound(name, value);
        }
        this._values.clear();
    }

    private void notifyValueUnbound(String name, Object oldValue) {
        ArrayList<HttpSessionAttributeListener> listeners;
        if (oldValue == null) {
            return;
        }
        if (oldValue instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent(this, name, oldValue));
        }
        if ((listeners = this._manager.getAttributeListeners()) != null) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, name, oldValue);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener = listeners.get(i);
                listener.attributeRemoved(event);
            }
        }
    }

    void setAccess(long now) {
        this._isNew = false;
        if (this._clusterObject != null) {
            this._clusterObject.access();
        }
        this._accessTime = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        int count;
        this._accessTime = Alarm.getCurrentTime();
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            count = --this._useCount;
        }
        if (count > 0) {
            return;
        }
        if (count < 0) {
            throw new IllegalStateException();
        }
        if (this._manager != null && this._manager.getSaveOnlyOnShutdown()) {
            return;
        }
        try {
            ClusterObject clusterObject = this._clusterObject;
            if (clusterObject != null) {
                clusterObject.store(this);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Can't serialize session", e);
        }
    }

    void storeOnShutdown() {
        try {
            ClusterObject clusterObject = this._clusterObject;
            if (clusterObject != null) {
                clusterObject.change();
                clusterObject.store(this);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Can't serialize session", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ObjectInputStream in) throws IOException {
        Map<String, Object> map = this._values;
        synchronized (map) {
            int i;
            this.unbind();
            try {
                int size = in.readInt();
                for (i = 0; i < size; ++i) {
                    String key = in.readUTF();
                    Object value = in.readObject();
                    if (value == null) continue;
                    this.setAttribute(key, value);
                }
            }
            catch (Exception e) {
                throw IOExceptionWrapper.create(e);
            }
            ArrayList<HttpSessionActivationListener> listeners = this._manager.getActivationListeners();
            for (i = 0; listeners != null && i < listeners.size(); ++i) {
                HttpSessionActivationListener listener = listeners.get(i);
                HttpSessionEvent event = new HttpSessionEvent(this);
                listener.sessionDidActivate(event);
            }
        }
    }

    public boolean isEmpty() {
        return this._values == null || this._values.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ObjectOutputStream out) throws IOException {
        Map<String, Object> map = this._values;
        synchronized (map) {
            Set set = this.getEntrySet();
            int size = set == null ? 0 : set.size();
            out.writeInt(size);
            if (size == 0) {
                return;
            }
            ArrayList<HttpSessionActivationListener> listeners = this._manager.getActivationListeners();
            for (int i = 0; listeners != null && i < listeners.size(); ++i) {
                HttpSessionActivationListener listener = listeners.get(i);
                HttpSessionEvent event = new HttpSessionEvent(this);
                listener.sessionWillPassivate(event);
            }
            boolean ignoreNonSerializable = this.getManager().getIgnoreSerializationErrors();
            for (Map.Entry entry : set) {
                Object value = entry.getValue();
                out.writeUTF((String)entry.getKey());
                if (ignoreNonSerializable && !(value instanceof Serializable)) {
                    out.writeObject(null);
                    continue;
                }
                try {
                    out.writeObject(value);
                }
                catch (NotSerializableException e) {
                    log.warning(L.l("Failed storing persistent session attribute `{0}'.  Persistent session values must extend java.io.Serializable.\n{1}", entry.getKey(), String.valueOf(e)));
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getEntrySet() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (!this._isValid) {
                throw new IllegalStateException(L.l("Can't call getEntrySet() when session is no longer valid."));
            }
            return this._values.entrySet();
        }
    }

    public boolean canLog() {
        return log.isLoggable(Level.FINE);
    }

    public void log(String value) {
        log.fine(value);
    }

    public String toString() {
        return new StringBuffer().append("SessionImpl[").append(this.getId()).append("]").toString();
    }
}

