/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.config.ConfigException;
import com.caucho.config.types.JndiBuilder;
import com.caucho.config.types.Period;
import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.FileStore;
import com.caucho.server.cluster.ObjectManager;
import com.caucho.server.cluster.Store;
import com.caucho.server.cluster.StoreManager;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.webapp.Application;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager
implements ObjectManager,
AlarmListener {
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/session/SessionManager"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/session/SessionManager"));
    private static int FALSE = 0;
    private static int COOKIE = 1;
    private static int TRUE = 2;
    private static int[] DECODE = new int[128];
    private Application _application;
    private LruCache<String, SessionImpl> _sessions;
    private int _totalSessions;
    private Iterator<SessionImpl> _sessionIter;
    private ArrayList<SessionImpl> _sessionList = new ArrayList();
    private int sessionCount;
    private boolean _enableSessionCookies = true;
    private boolean _enableSessionUrls = true;
    private boolean _isInvalidateAfterListener;
    private int _sessionMax = 4096;
    private long _sessionTimeout = 1800000L;
    private String _cookieName = "JSESSIONID";
    private String _sessionSuffix = ";jsessionid=";
    private String _sessionPrefix;
    private int _cookieVersion;
    private String _cookieDomain;
    private long _cookieMaxAge;
    private boolean _cookieSecure;
    private String _cookiePort;
    private int _reuseSessionId = COOKIE;
    private int _cookieLength = 12;
    private int _distributedPort;
    private StoreManager _persistentStore;
    private StoreManager _storeManager;
    private Store _sessionStore;
    private boolean _alwaysLoadSession;
    private boolean _alwaysSaveSession;
    private boolean _saveOnlyOnShutdown;
    private boolean _distributedRing;
    private Path _persistentPath;
    private long _lastDistributedFail;
    private ArrayList<HttpSessionListener> _listeners;
    private ArrayList<HttpSessionActivationListener> _activationListeners;
    private ArrayList<HttpSessionAttributeListener> _attributeListeners;
    private boolean _ignoreSerializationErrors = false;
    private int _srunIndex;
    private boolean _isClosed;
    private String _distributionId;
    private Cluster _cluster;
    private ClusterServer[] _srunGroup = new ClusterServer[0];
    private Alarm _alarm = new Alarm(this);

    public SessionManager(Application app) throws Exception {
        String name;
        this._application = app;
        DispatchServer server = app.getDispatchServer();
        if (server != null) {
            InvocationDecoder decoder = server.getInvocationDecoder();
            this._sessionSuffix = decoder.getSessionURLPrefix();
            this._sessionPrefix = decoder.getAlternateSessionURLPrefix();
            this._cookieName = decoder.getSessionCookie();
        }
        String hostName = app.getHostName();
        String contextPath = app.getContextPath();
        if (hostName == null || hostName.equals("")) {
            hostName = "default";
        }
        this._distributionId = name = new StringBuffer().append(hostName).append(contextPath).toString();
        this._persistentPath = Vfs.lookup("WEB-INF/sessions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Cluster getCluster() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this._cluster == null) {
                this._cluster = Cluster.getLocal();
                ClusterServer selfServer = null;
                if (this._cluster != null && (selfServer = this._cluster.getSelfServer()) != null) {
                    this._srunGroup = selfServer.getGroup().getServerList();
                    this._srunIndex = selfServer.getIndex();
                }
            }
        }
        return this._cluster;
    }

    public String getSessionPrefix() {
        return this._sessionSuffix;
    }

    public String getAlternateSessionPrefix() {
        return this._sessionPrefix;
    }

    public int getCookieVersion() {
        return this._cookieVersion;
    }

    public void setCookieVersion(int cookieVersion) {
        this._cookieVersion = cookieVersion;
    }

    public void setCookiePort(String port) {
        this._cookiePort = port;
    }

    public String getCookiePort() {
        return this._cookiePort;
    }

    public Logger getDebug() {
        return log;
    }

    Application getApplication() {
        return this._application;
    }

    ServletAuthenticator getAuthenticator() {
        return this._application.getAuthenticator();
    }

    public void setPersistentStore(JndiBuilder store) throws NamingException, ConfigException {
        this._persistentStore = (StoreManager)store.getObject();
        if (this._persistentStore == null) {
            throw new ConfigException(L.l("{0} is an unknown persistent store.", store.getJndiName()));
        }
    }

    boolean getAlwaysSaveSession() {
        return this._alwaysSaveSession;
    }

    public void setAlwaysSaveSession(boolean save) {
        this._alwaysSaveSession = save;
    }

    boolean getAlwaysLoadSession() {
        return this._alwaysLoadSession;
    }

    public void setAlwaysLoadSession(boolean load) {
        this._alwaysLoadSession = load;
    }

    public boolean getSaveOnlyOnShutdown() {
        return this._saveOnlyOnShutdown;
    }

    public void setSaveOnlyOnShutdown(boolean save) {
        this._saveOnlyOnShutdown = save;
    }

    public void setSaveOnShutdown(boolean save) {
        log.warning("<save-on-shutdown> is deprecated.  Use <save-only-on-shutdown> instead");
        this.setSaveOnlyOnShutdown(save);
    }

    public void setInvalidateAfterListener(boolean inv) {
        this._isInvalidateAfterListener = inv;
    }

    public boolean isInvalidateAfterListener() {
        return this._isInvalidateAfterListener;
    }

    public int getActiveSessionCount() {
        if (this._sessions == null) {
            return -1;
        }
        return this._sessions.size();
    }

    public void addListener(HttpSessionListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    ArrayList<HttpSessionListener> getListeners() {
        return this._listeners;
    }

    public void addActivationListener(HttpSessionActivationListener listener) {
        if (this._activationListeners == null) {
            this._activationListeners = new ArrayList();
        }
        this._activationListeners.add(listener);
    }

    ArrayList<HttpSessionActivationListener> getActivationListeners() {
        return this._activationListeners;
    }

    public void addAttributeListener(HttpSessionAttributeListener listener) {
        if (this._attributeListeners == null) {
            this._attributeListeners = new ArrayList();
        }
        this._attributeListeners.add(listener);
    }

    ArrayList<HttpSessionAttributeListener> getAttributeListeners() {
        return this._attributeListeners;
    }

    boolean getIgnoreSerializationErrors() {
        return this._ignoreSerializationErrors;
    }

    public void setIgnoreSerializationErrors(boolean ignore) {
        this._ignoreSerializationErrors = ignore;
    }

    public int getReuseSessionId() {
        return this._reuseSessionId;
    }

    public boolean reuseSessionId(boolean fromCookie) {
        int reuseSessionId = this._reuseSessionId;
        return reuseSessionId == TRUE || fromCookie && reuseSessionId == COOKIE;
    }

    public void setReuseSessionId(String reuse) throws ConfigException {
        if (reuse == null) {
            this._reuseSessionId = COOKIE;
        } else if (reuse.equalsIgnoreCase("true") || reuse.equalsIgnoreCase("yes") || reuse.equalsIgnoreCase("cookie")) {
            this._reuseSessionId = COOKIE;
        } else if (reuse.equalsIgnoreCase("false") || reuse.equalsIgnoreCase("no")) {
            this._reuseSessionId = FALSE;
        } else if (reuse.equalsIgnoreCase("all")) {
            this._reuseSessionId = TRUE;
        } else {
            throw new ConfigException(L.l("'{0}' is an invalid value for reuse-session-id.  'true' or 'false' are the allowed values.", reuse));
        }
    }

    ClusterServer getServer(int index) {
        Cluster cluster = this.getCluster();
        if (cluster != null) {
            return cluster.getServer(index);
        }
        return null;
    }

    int getSrunIndex() {
        return this._srunIndex;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public FileStore createFileStore() {
        FileStore store = new FileStore();
        store.setPath(Vfs.getPwd().lookup("WEB-INF/sessions"));
        this._storeManager = store;
        return store;
    }

    public StoreManager createJdbcStore() throws ConfigException {
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new ConfigException(L.l("<jdbc-store> needs a defined <cluster>."));
        }
        this._storeManager = cluster.createJdbcStore();
        return this._storeManager;
    }

    public StoreManager createTcpStore() throws Exception {
        return this.createClusterStore();
    }

    public StoreManager createClusterStore() throws Exception {
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new ConfigException(L.l("<cluster-store> needs a defined <cluster>."));
        }
        StoreManager store = cluster.getStore();
        if (store == null) {
            throw new ConfigException(L.l("cluster-store in <session-config> requires a configured cluster-store in the <cluster>"));
        }
        this._storeManager = store;
        return store;
    }

    public void setUsePersistentStore(boolean enable) throws Exception {
        if (!enable) {
            return;
        }
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new ConfigException(L.l("<use-persistent-store> needs a defined <cluster>."));
        }
        StoreManager store = cluster.getStore();
        if (store == null) {
            try {
                InitialContext ic = new InitialContext();
                store = (StoreManager)ic.lookup("java:comp/env/caucho/persistent-store");
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        if (store == null) {
            throw new ConfigException(L.l("use-persistent-store in <session-config> requires a configured <persistent-store> in the <server>"));
        }
        this._persistentStore = this._storeManager = store;
    }

    public void setPersistentPath(Path path) {
        this._persistentPath = path;
    }

    public String getDistributionId() {
        return this._distributionId;
    }

    public long getSessionTimeout() {
        return this._sessionTimeout;
    }

    public void setSessionTimeout(long timeout) {
        this._sessionTimeout = timeout <= 0L || 0x3FFFFFFFL < timeout ? 0x3FFFFFFFFFFFFFFFL : 60000L * timeout;
    }

    public int getSessionMax() {
        return this._sessionMax;
    }

    public void setSessionMax(int max) {
        this._sessionMax = max;
    }

    public boolean enableSessionCookies() {
        return this._enableSessionCookies;
    }

    public void setEnableCookies(boolean enableCookies) {
        this._enableSessionCookies = enableCookies;
    }

    public boolean enableSessionUrls() {
        return this._enableSessionUrls;
    }

    public void setEnableUrlRewriting(boolean enableUrls) {
        this._enableSessionUrls = enableUrls;
    }

    public String getCookieName() {
        return this._cookieName;
    }

    public String getCookieDomain() {
        return this._cookieDomain;
    }

    public void setCookieDomain(String domain) {
        this._cookieDomain = domain;
    }

    public long getCookieMaxAge() {
        return this._cookieMaxAge;
    }

    public void setCookieMaxAge(Period maxAge) {
        this._cookieMaxAge = maxAge.getPeriod();
    }

    public boolean getCookieSecure() {
        return this._cookieSecure;
    }

    public void setCookieSecure(boolean secure) {
        this._cookieSecure = secure;
    }

    public void setCookieLength(int cookieLength) {
        if (cookieLength < 7) {
            cookieLength = 7;
        }
        this._cookieLength = cookieLength;
    }

    public void start() throws Exception {
        this._sessions = new LruCache(this._sessionMax);
        this._sessionIter = this._sessions.values();
        if (this._cluster == null) {
            this.getCluster();
        }
        if (this._persistentStore != null) {
            this._storeManager = this._persistentStore;
        } else if (this._storeManager != null) {
            this._storeManager.setAlwaysLoad(this._alwaysLoadSession);
            this._storeManager.setAlwaysSave(this._alwaysSaveSession);
            this._storeManager.setMaxIdleTime(new Period(this._sessionTimeout));
            this._storeManager.init();
        }
        if (this._storeManager != null) {
            this._sessionStore = this._storeManager.createStore(this._distributionId, this);
        }
        this._alarm.queue(60000L);
    }

    Store getSessionStore() {
        return this._sessionStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionImpl createSession(String oldId, long now, HttpServletRequest request, boolean fromCookie) {
        SessionImpl session;
        String id = oldId;
        if (id == null || id.length() < 4 || !this.isInSessionGroup(id) || !this.reuseSessionId(fromCookie)) {
            id = this.createSessionId(request, true);
        }
        if ((session = this.create(id, now)) == null) {
            return null;
        }
        this.handleCreateListeners(session);
        SessionImpl sessionImpl = session;
        synchronized (sessionImpl) {
            if (this._sessionStore != null && id.equals(oldId)) {
                this.load(session, now);
            }
        }
        return session;
    }

    public String createSessionId(HttpServletRequest request) {
        return this.createSessionId(request, false);
    }

    public String createSessionId(HttpServletRequest request, boolean create) {
        String id;
        do {
            CharBuffer cb = CharBuffer.allocate();
            int index = this._srunIndex;
            if (index < 0) {
                index = 0;
            }
            cb.append(SessionManager.convert(index));
            long random = RandomUtil.getRandomLong();
            int i = 0;
            for (i = 0; i < 11 && i < this._cookieLength - 1 && i < 11; ++i) {
                cb.append(SessionManager.convert(random));
                random >>= 6;
            }
            long time = Alarm.getCurrentTime();
            while (i < this._cookieLength - 1) {
                cb.append(SessionManager.convert(time));
                time >>= 6;
                ++i;
            }
            id = cb.close();
        } while (create && this.getSession(id, 0L, create, true) != null);
        if (id == null || id.equals("")) {
            throw new RuntimeException();
        }
        return id;
    }

    public SessionImpl getSession(String key, long now, boolean create, boolean fromCookie) {
        boolean isNew = false;
        boolean killSession = false;
        if (this._sessions == null) {
            return null;
        }
        SessionImpl session = this._sessions.get(key);
        if (session != null && !session.getId().equals(key)) {
            throw new IllegalStateException(new StringBuffer().append(key).append(" != ").append(session.getId()).toString());
        }
        if (session != null) {
            if (session.inUse()) {
                return session;
            }
        } else if (now > 0L && this._sessionStore != null) {
            if (!this.isInSessionGroup(key)) {
                return null;
            }
            session = this.create(key, now);
            isNew = true;
        }
        if (session == null) {
            return null;
        }
        if (isNew) {
            isNew = killSession = !this.load(session, now);
        } else if (!this.getSaveOnlyOnShutdown() && !session.load()) {
            session.reset(now);
            isNew = true;
        }
        if (!(!killSession || create && this.reuseSessionId(fromCookie))) {
            session._isValid = false;
            this._sessions.remove(key);
            return null;
        }
        if (isNew) {
            this.handleCreateListeners(session);
        } else {
            session.setAccess(now);
        }
        return session;
    }

    private boolean isInSessionGroup(String id) {
        int group = id.charAt(0) - 97;
        if (this._srunGroup.length == 0) {
            return true;
        }
        for (int i = this._srunGroup.length - 1; i >= 0; --i) {
            ClusterServer server = this._srunGroup[i];
            if (server == null || group != server.getIndex()) continue;
            return true;
        }
        return false;
    }

    private SessionImpl create(String key, long now) {
        SessionImpl session = new SessionImpl(this, key, now);
        if (!key.equals((session = this._sessions.putIfNew(key, session)).getId())) {
            throw new IllegalStateException(new StringBuffer().append(key).append(" != ").append(session.getId()).toString());
        }
        if (this._sessionStore != null) {
            ClusterObject clusterObject = this._sessionStore.createClusterObject(key);
            session.setClusterObject(clusterObject);
        }
        return session;
    }

    @Override
    public void notifyRemove(String id) {
        SessionImpl session = this._sessions.remove(id);
        if (session != null) {
            session.invalidateImpl();
        }
    }

    @Override
    public void notifyUpdate(String id) {
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    static int decode(int code) {
        return DECODE[code & 0x7F];
    }

    private void handleCreateListeners(SessionImpl session) {
        if (this._listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent(session);
            for (int i = 0; i < this._listeners.size(); ++i) {
                HttpSessionListener listener = this._listeners.get(i);
                listener.sessionCreated(event);
            }
        }
    }

    private boolean load(SessionImpl session, long now) {
        try {
            if (session.inUse()) {
                return true;
            }
            if (now <= 0L) {
                return false;
            }
            if (session.load()) {
                session.setAccess(now);
                return true;
            }
            session.create(now);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            session.reset(now);
        }
        return false;
    }

    void addSession(SessionImpl session) {
        this._sessions.put(session.getId(), session);
    }

    public void invalidateSession(SessionImpl session) {
        this.removeSession(session);
        if (this._sessionStore != null) {
            try {
                this._sessionStore.remove(session.getId());
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void removeSession(SessionImpl session) {
        this._sessions.remove(session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementSessionCount() {
        LruCache<String, SessionImpl> lruCache = this._sessions;
        synchronized (lruCache) {
            --this.sessionCount;
        }
    }

    @Override
    public void load(ObjectInputStream in, Object obj) throws IOException {
        SessionImpl session = (SessionImpl)obj;
        session.load(in);
    }

    @Override
    public boolean isEmpty(Object obj) {
        SessionImpl session = (SessionImpl)obj;
        return session.isEmpty();
    }

    @Override
    public void store(ObjectOutputStream out, Object obj) throws IOException {
        SessionImpl session = (SessionImpl)obj;
        session.store(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        try {
            SessionImpl session;
            this._sessionList.clear();
            int liveSessions = 0;
            if (this._isClosed) {
                return;
            }
            long now = Alarm.getCurrentTime();
            LruCache<String, SessionImpl> lruCache = this._sessions;
            synchronized (lruCache) {
                this._sessionIter = this._sessions.values(this._sessionIter);
                while (this._sessionIter.hasNext()) {
                    session = this._sessionIter.next();
                    if (session.inUse()) {
                        ++liveSessions;
                        continue;
                    }
                    if (session._accessTime + session._maxInactiveInterval < now) {
                        this._sessionList.add(session);
                        continue;
                    }
                    ++liveSessions;
                }
            }
            for (int i = 0; i < this._sessionList.size(); ++i) {
                session = this._sessionList.get(i);
                try {
                    if (this._storeManager == null) {
                        session.invalidate(true);
                        continue;
                    }
                    if (session.getSrunIndex() != this._srunIndex && this._srunIndex >= 0) {
                        this._sessions.remove(session.getId());
                        continue;
                    }
                    if (session._accessTime + this._storeManager.getMaxIdleTime() < now) {
                        session.invalidate(true);
                        continue;
                    }
                    this._sessions.remove(session.getId());
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
        finally {
            if (!this._isClosed) {
                this._alarm.queue(60000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SessionImpl session;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        if (this._sessions == null) {
            return;
        }
        this._alarm.dequeue();
        this._sessionList.clear();
        ArrayList<SessionImpl> list = new ArrayList<SessionImpl>();
        boolean isError = false;
        LruCache<String, SessionImpl> lruCache = this._sessions;
        synchronized (lruCache) {
            this._sessionIter = this._sessions.values(this._sessionIter);
            while (this._sessionIter.hasNext()) {
                session = this._sessionIter.next();
                if (!session.isValid()) continue;
                list.add(session);
            }
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            session = (SessionImpl)list.get(i);
            if (log.isLoggable(Level.FINE)) {
                log.fine(new StringBuffer().append("close session ").append(session.getId()).toString());
            }
            try {
                if (session.isValid()) {
                    SessionImpl sessionImpl = session;
                    synchronized (sessionImpl) {
                        if (!session.isEmpty()) {
                            session.storeOnShutdown();
                        }
                    }
                }
                this._sessions.remove(session.getId());
                continue;
            }
            catch (Exception e) {
                if (!isError) {
                    log.log(Level.WARNING, new StringBuffer().append("Can't store session: ").append(e).toString(), e);
                }
                isError = true;
            }
        }
    }

    static {
        for (int i = 0; i < 64; ++i) {
            SessionManager.DECODE[SessionManager.convert((long)((long)i))] = i;
        }
    }
}

