/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.core.ResinImport;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.InitProgram;
import com.caucho.config.types.PathBuilder;
import com.caucho.config.types.Period;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.jmx.Jmx;
import com.caucho.jsp.JspServlet;
import com.caucho.jsp.cfg.JspConfig;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.jsp.cfg.JspTaglib;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.log.Log;
import com.caucho.make.AlwaysModified;
import com.caucho.make.Dependency;
import com.caucho.make.DependencyContainer;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.server.cache.AbstractCache;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.deploy.Deploy;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.server.dispatch.DispatchBuilder;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.FilterChainBuilder;
import com.caucho.server.dispatch.FilterConfigImpl;
import com.caucho.server.dispatch.FilterManager;
import com.caucho.server.dispatch.FilterMapper;
import com.caucho.server.dispatch.FilterMapping;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.ServletMapper;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.dispatch.ServletRegexp;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.host.Host;
import com.caucho.server.log.AccessLog;
import com.caucho.server.security.AbstractLogin;
import com.caucho.server.security.ConstraintManager;
import com.caucho.server.security.LoginConfig;
import com.caucho.server.security.SecurityConstraint;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.server.security.TransportConstraint;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.CacheMapping;
import com.caucho.server.webapp.DispatchFilterChain;
import com.caucho.server.webapp.EjbLocalRef;
import com.caucho.server.webapp.EjbRef;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.Listener;
import com.caucho.server.webapp.LocaleEncodingMappingList;
import com.caucho.server.webapp.MimeMapping;
import com.caucho.server.webapp.MultipartForm;
import com.caucho.server.webapp.NamedDispatcherImpl;
import com.caucho.server.webapp.PathMapping;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.ServletContextImpl;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppEntry;
import com.caucho.server.webapp.WebAppExpandDeploy;
import com.caucho.server.webapp.WebAppFilterChain;
import com.caucho.server.webapp.WebAppSingleDeploy;
import com.caucho.server.webapp.WelcomeFileList;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.el.VariableResolver;
import org.iso_relax.verifier.Schema;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends ServletContextImpl
implements Dependency,
EnvironmentBean,
SchemaBean,
DispatchBuilder,
DeployInstance {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/webapp/Application"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/Application"));
    private static EnvironmentLocal<AccessLog> _accessLogLocal = new EnvironmentLocal("caucho.server.access-log");
    private static EnvironmentLocal<Application> _appLocal = new EnvironmentLocal("caucho.application");
    static String[] _classLoaderHackPackages = new String[]{"java.", "javax.servlet.", "javax.naming.", "javax.sql.", "javax.transaction."};
    private ClassLoader _parentClassLoader;
    private EnhancingClassLoader _classLoader;
    private ApplicationContainer _parent;
    private WebAppEntry _applicationEntry;
    private String _contextPath;
    private String _description;
    private LinkedHashMap<String, String> _jmxContext;
    private MapVariableResolver _varResolver;
    private String _servletVersion;
    private Path _appDir;
    private boolean _isAppDirSet;
    private boolean _isDynamicDeploy;
    private ArrayList<Deploy> _appGenerators;
    private ServletManager _servletManager;
    private ServletMapper _servletMapper;
    private boolean _isStrictMapping;
    private boolean _servletAllowEL;
    private FilterManager _filterManager;
    private FilterMapper _filterMapper;
    private FilterMapper _loginFilterMapper;
    private FilterMapper _includeFilterMapper;
    private FilterMapper _forwardFilterMapper;
    private FilterMapper _errorFilterMapper;
    private TransactionManagerImpl _tm;
    private SessionManager _sessionManager;
    private boolean _isInheritSession;
    private AbstractCache _cache;
    private UrlMap<CacheMapping> _cacheMappingMap;
    private LruCache<String, RequestDispatcher> _dispatcherCache;
    private AbstractLogin _loginManager;
    private ConstraintManager _constraintManager;
    private boolean _isSecure;
    private ErrorPageManager _errorPageManager;
    private Throwable _configException;
    private UrlMap<String> _pathMapping;
    private HashMap<String, String> _mimeMapping;
    private HashMap<String, String> _localeMapping;
    private ArrayList<ServletContextListener> _applicationListeners;
    private ArrayList<ServletContextAttributeListener> _attributeListeners;
    private ArrayList<ServletRequestListener> _requestListeners;
    private ServletRequestListener[] _requestListenerArray;
    private ArrayList<ServletRequestAttributeListener> _requestAttributeListeners;
    private ServletRequestAttributeListener[] _requestAttributeListenerArray;
    private DependencyContainer _invocationDependency;
    private AccessLog _accessLog;
    private Path _tempDir;
    private JspPropertyGroup _jsp;
    private ArrayList<JspTaglib> _taglibList;
    private HashMap<String, Object> _extensions;
    private MultipartForm _multipartForm;
    private Var _appVar;
    private ArrayList<String> _regexp;
    private final Object _countLock;
    private int _requestCount;
    private long _shutdownWaitTime;
    private long _activeWaitTime;
    private final Lifecycle _lifecycle;

    public Application() {
        this(null, null, "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application(ApplicationContainer parent, WebAppEntry entry, String contextPath) {
        block12: {
            this._contextPath = "";
            this._description = "";
            this._servletVersion = "2.4";
            this._appGenerators = new ArrayList();
            this._servletAllowEL = false;
            this._cacheMappingMap = new UrlMap();
            this._pathMapping = new UrlMap();
            this._mimeMapping = new HashMap();
            this._localeMapping = new HashMap();
            this._applicationListeners = new ArrayList();
            this._attributeListeners = new ArrayList();
            this._requestListeners = new ArrayList();
            this._requestListenerArray = new ServletRequestListener[0];
            this._requestAttributeListeners = new ArrayList();
            this._requestAttributeListenerArray = new ServletRequestAttributeListener[0];
            this._extensions = new HashMap();
            this._appVar = new Var();
            this._countLock = new Object();
            this._shutdownWaitTime = 15000L;
            this._activeWaitTime = 15000L;
            try {
                JspServlet.initStatic();
                this._parentClassLoader = Thread.currentThread().getContextClassLoader();
                this._classLoader = new EnhancingClassLoader(this._parentClassLoader);
                this._classLoader.setOwner(this);
                this._applicationEntry = entry;
                this._classLoader.addParentPriorityPackages(_classLoaderHackPackages);
                _appLocal.set(this, this._classLoader);
                VariableResolver parentResolver = EL.getEnvironment(this._parentClassLoader);
                HashMap<String, Object> map = new HashMap<String, Object>();
                this._varResolver = new MapVariableResolver(map, parentResolver);
                EL.setVariableMap(map, this._classLoader);
                EL.setEnvironment(this._varResolver, this._classLoader);
                map.put("app", this._appVar);
                this._jmxContext = Jmx.copyContextProperties();
                this._jmxContext.put("WebApp", contextPath);
                this._appDir = Vfs.lookup();
                this._servletManager = new ServletManager();
                this._servletMapper = new ServletMapper();
                this._servletMapper.setServletContext(this);
                this._servletMapper.setServletManager(this._servletManager);
                this._filterManager = new FilterManager();
                this._filterMapper = new FilterMapper();
                this._filterMapper.setServletContext(this);
                this._filterMapper.setFilterManager(this._filterManager);
                this._loginFilterMapper = new FilterMapper();
                this._loginFilterMapper.setServletContext(this);
                this._loginFilterMapper.setFilterManager(this._filterManager);
                this._includeFilterMapper = new FilterMapper();
                this._includeFilterMapper.setServletContext(this);
                this._includeFilterMapper.setFilterManager(this._filterManager);
                this._forwardFilterMapper = new FilterMapper();
                this._forwardFilterMapper.setServletContext(this);
                this._forwardFilterMapper.setFilterManager(this._filterManager);
                this._errorFilterMapper = new FilterMapper();
                this._errorFilterMapper.setServletContext(this);
                this._errorFilterMapper.setFilterManager(this._filterManager);
                this._constraintManager = new ConstraintManager();
                this._errorPageManager = new ErrorPageManager();
                this._errorPageManager.setApplication(this);
                this._invocationDependency = new DependencyContainer();
                this._invocationDependency.add(this);
                if (entry != null && entry.isRedeployManual()) {
                    this._classLoader.setEnableDependencyCheck(false);
                }
                this.setParent(parent);
                if (contextPath != null) {
                    this.setContextPathId(contextPath);
                }
                Thread thread = Thread.currentThread();
                ClassLoader loader = thread.getContextClassLoader();
                if (entry == null) break block12;
                try {
                    thread.setContextClassLoader(this._classLoader);
                    Jmx.setContextProperties(this._jmxContext);
                    ObjectName name = new ObjectName("resin:type=CurrentWebApp");
                    Jmx.register(this._applicationEntry.getMBean(), name);
                    thread.setContextClassLoader(loader);
                }
                catch (Throwable e) {
                    try {
                        log.log(Level.FINER, e.toString(), e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        thread.setContextClassLoader(loader);
                    }
                }
            }
            catch (Throwable e) {
                this.setConfigException(e);
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
            }
        }
    }

    public void setParent(ApplicationContainer parent) {
        this._parent = parent;
        if (parent == null) {
            return;
        }
        if (!this._isAppDirSet) {
            this.setAppDir(parent.getDocumentDirectory());
            Vfs.setPwd(parent.getDocumentDirectory(), this._classLoader);
            this._isAppDirSet = false;
        }
        this._errorPageManager.setParent(parent.getErrorPageManager());
    }

    public void setDynamicDeploy(boolean isDynamicDeploy) {
        this._isDynamicDeploy = isDynamicDeploy;
    }

    public boolean isDynamicDeploy() {
        return this._isDynamicDeploy;
    }

    public ApplicationContainer getParent() {
        return this._parent;
    }

    public static Application getLocal() {
        return _appLocal.get();
    }

    public DispatchServer getDispatchServer() {
        if (this._parent != null) {
            return this._parent.getDispatchServer();
        }
        return null;
    }

    public void setId(String id) {
    }

    private void setContextPathId(String id) {
        if (!id.equals("") && !id.startsWith("/")) {
            id = new StringBuffer().append("/").append(id).toString();
        }
        if (id.endsWith("/")) {
            id = id.substring(0, id.length() - 1);
        }
        this.setContextPath(id);
        if (!this._isAppDirSet && this._parent != null) {
            this.setAppDir(this._parent.getDocumentDirectory().lookup(new StringBuffer().append("./").append(id).toString()));
            this._isAppDirSet = false;
        }
    }

    @Override
    public EnvironmentClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        throw new IllegalStateException();
    }

    public EnvironmentClassLoader getEnvironmentClassLoader() {
        return this._classLoader;
    }

    @Override
    public Schema getSchema() {
        String schemaName = "com/caucho/server/webapp/resin-web-xml.rnc";
        try {
            return CompactVerifierFactoryImpl.compileFromResource(schemaName);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            log.warning(e.toString());
            return null;
        }
    }

    @Override
    public Path getAppDir() {
        return this._appDir;
    }

    public DependencyContainer getInvocationDependency() {
        return this._invocationDependency;
    }

    public Map<String, Object> getVariableMap() {
        return this._varResolver.getMap();
    }

    public void setVariableMap(HashMap<String, Object> map) {
        this._varResolver.setMap(map);
    }

    public VariableResolver getVariableResolver() {
        return this._varResolver;
    }

    public void setRegexp(ArrayList<String> regexp) {
        this._regexp = regexp;
    }

    public ArrayList<String> getRegexp() {
        return this._regexp;
    }

    public void setDocumentDirectory(Path appDir) {
        this.setAppDir(appDir);
    }

    public void setAppDir(Path appDir) {
        this._appDir = appDir;
        this._isAppDirSet = true;
        Path workDir = null;
        workDir = appDir instanceof MemoryPath ? Vfs.lookup(new StringBuffer().append("file:/tmp/caucho/qa").append(appDir.getPath()).toString()).lookup("WEB-INF/work") : appDir.lookup("WEB-INF/work");
        this._classLoader.setAttribute("caucho.work-dir", workDir);
    }

    public String getContextPath() {
        return this._contextPath;
    }

    private void setContextPath(String contextPath) {
        String jmxName;
        this._contextPath = contextPath;
        if (this.getServletContextName() == null) {
            this.setDisplayName(contextPath);
        }
        if ((jmxName = contextPath).equals("")) {
            jmxName = "/";
        }
        this._jmxContext.put("WebApp", jmxName);
        this._classLoader.setId(new StringBuffer().append("web-app:").append(this.getURL()).toString());
    }

    public void setVersion(String version) {
        this._servletVersion = version;
    }

    public void setSchemaLocation(String location) {
    }

    public String getURL() {
        if (this._parent != null) {
            return new StringBuffer().append(this._parent.getURL()).append(this._contextPath).toString();
        }
        return this._contextPath;
    }

    public String getHostName() {
        if (this._parent != null) {
            return this._parent.getHostName();
        }
        return null;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setAllowServletEL(boolean allow) {
        this._servletAllowEL = allow;
    }

    public ServletConfigImpl createServlet() throws ServletException {
        ServletConfigImpl config = new ServletConfigImpl();
        config.setAllowEL(this._servletAllowEL);
        return config;
    }

    public void addServlet(ServletConfigImpl config) throws ServletException {
        config.setServletContext(this);
        this._servletManager.addServlet(config);
    }

    public void setStrictMapping(boolean isStrict) throws ServletException {
        this._isStrictMapping = isStrict;
    }

    public ServletMapping createServletMapping() throws ServletException {
        ServletMapping servletMapping = new ServletMapping();
        servletMapping.setStrictMapping(this._isStrictMapping);
        return servletMapping;
    }

    public void addServletMapping(ServletMapping servletMapping) throws ServletException {
        if (servletMapping.getURLRegexp() == null && servletMapping.getServletClass() != null) {
            if (servletMapping.getServletName() == null) {
                servletMapping.setServletName(servletMapping.getURLPattern());
            }
            this.addServlet(servletMapping);
        }
        this._servletMapper.addServletMapping(servletMapping);
    }

    public void addServletRegexp(ServletRegexp servletRegexp) throws ServletException, ClassNotFoundException {
        ServletMapping mapping = new ServletMapping();
        mapping.setURLRegexp(servletRegexp.getURLRegexp());
        mapping.setServletName(servletRegexp.getServletName());
        mapping.setServletClass(servletRegexp.getServletClass());
        mapping.setServletContext(this);
        mapping.setInit(new InitProgram(servletRegexp.getBuilderProgram()));
        this._servletMapper.addServletRegexp(mapping);
    }

    public void addFilter(FilterConfigImpl config) {
        config.setServletContext(this);
        this._filterManager.addFilter(config);
    }

    public void addFilterMapping(FilterMapping filterMapping) throws ServletException {
        filterMapping.setServletContext(this);
        if (filterMapping.isRequest()) {
            this._filterMapper.addFilterMapping(filterMapping);
            this._loginFilterMapper.addFilterMapping(filterMapping);
        }
        if (filterMapping.isInclude()) {
            this._includeFilterMapper.addFilterMapping(filterMapping);
        }
        if (filterMapping.isForward()) {
            this._forwardFilterMapper.addFilterMapping(filterMapping);
        }
        if (filterMapping.isError()) {
            this._errorFilterMapper.addFilterMapping(filterMapping);
        }
    }

    public void setDirectoryServlet(String className) throws Exception {
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletName("directory");
        if (className.equals("none")) {
            config.setServletClass("com.caucho.servlets.ErrorStatusServlet");
        } else {
            config.setServletClass(className);
        }
        this.addServlet(config);
    }

    public void addWelcomeFileList(WelcomeFileList list) {
        ArrayList<String> fileList = list.getWelcomeFileList();
        this._servletMapper.setWelcomeFileList(fileList);
    }

    public LocaleEncodingMappingList createLocaleEncodingMappingList() {
        return new LocaleEncodingMappingList(this);
    }

    public void setInheritSession(boolean isInheritSession) {
        this._isInheritSession = isInheritSession;
    }

    public boolean isInheritSession() {
        return this._isInheritSession;
    }

    public SessionManager createSessionConfig() throws Exception {
        if (this._isInheritSession) {
            return new SessionManager(this);
        }
        return this.getSessionManager();
    }

    public void addSessionConfig(SessionManager manager) throws ConfigException {
        if (this._isInheritSession) {
            manager.close();
        }
    }

    public InitParam createContextParam() {
        InitParam initParam = new InitParam();
        initParam.setAllowEL(this._servletAllowEL);
        return initParam;
    }

    public void addContextParam(InitParam initParam) {
        HashMap<String, String> map = initParam.getParameters();
        for (String key : map.keySet()) {
            String value = map.get(key);
            this.setInitParameter(key, value);
        }
    }

    public void addErrorPage(ErrorPage errorPage) {
        this._errorPageManager.addErrorPage(errorPage);
    }

    public void setAccessLog(AccessLog log) {
        this._accessLog = log;
        _accessLogLocal.set(log);
    }

    public void addMimeMapping(MimeMapping mimeMapping) {
        this._mimeMapping.put(mimeMapping.getExtension(), mimeMapping.getMimeType());
    }

    public void putLocaleEncoding(String locale, String encoding) {
        this._localeMapping.put(locale, encoding);
    }

    public String getLocaleEncoding(Locale locale) {
        String key = locale.toString();
        String encoding = this._localeMapping.get(key.toLowerCase());
        if (encoding != null) {
            return encoding;
        }
        if (locale.getVariant() != null && (encoding = this._localeMapping.get((key = new StringBuffer().append(locale.getLanguage()).append('_').append(locale.getCountry()).toString()).toLowerCase())) != null) {
            return encoding;
        }
        if (locale.getCountry() != null && (encoding = this._localeMapping.get((key = locale.getLanguage()).toLowerCase())) != null) {
            return encoding;
        }
        return Encoding.getMimeName(locale);
    }

    public void addPathMapping(PathMapping pathMapping) throws Exception {
        String urlPattern = pathMapping.getUrlPattern();
        String urlRegexp = pathMapping.getUrlRegexp();
        String realPath = pathMapping.getRealPath();
        if (urlPattern != null) {
            this._pathMapping.addMap(urlPattern, realPath);
        } else if (urlRegexp != null) {
            this._pathMapping.addRegexp(urlRegexp, realPath);
        } else {
            throw new NullPointerException();
        }
    }

    public void setLoginConfig(LoginConfig loginConfig) throws Throwable {
        this._loginManager = loginConfig.getLogin();
    }

    public void addSecurityConstraint(SecurityConstraint constraint) {
        this._constraintManager.addConstraint(constraint);
    }

    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
        if (isSecure) {
            TransportConstraint transConstraint = new TransportConstraint("secure");
            SecurityConstraint constraint = new SecurityConstraint();
            constraint.setURLPattern("/*");
            constraint.addConstraint(transConstraint);
            this._constraintManager.addConstraint(constraint);
        }
    }

    public void addListener(Listener listener) throws Exception {
        this.addListenerObject(listener.getListenerObject());
    }

    public void addListenerObject(Object listenerObj) {
        if (listenerObj instanceof ServletContextListener) {
            ServletContextListener scListener = (ServletContextListener)listenerObj;
            this._applicationListeners.add(scListener);
            if (this._lifecycle.isActive() || this._lifecycle.isStarting()) {
                ServletContextEvent event = new ServletContextEvent(this);
                try {
                    scListener.contextInitialized(event);
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        if (listenerObj instanceof ServletContextAttributeListener) {
            this.addAttributeListener((ServletContextAttributeListener)listenerObj);
        }
        if (listenerObj instanceof ServletRequestListener) {
            this._requestListeners.add((ServletRequestListener)listenerObj);
            this._requestListenerArray = new ServletRequestListener[this._requestListeners.size()];
            this._requestListeners.toArray(this._requestListenerArray);
        }
        if (listenerObj instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners.add((ServletRequestAttributeListener)listenerObj);
            this._requestAttributeListenerArray = new ServletRequestAttributeListener[this._requestAttributeListeners.size()];
            this._requestAttributeListeners.toArray(this._requestAttributeListenerArray);
        }
        if (listenerObj instanceof HttpSessionListener) {
            this.getSessionManager().addListener((HttpSessionListener)listenerObj);
        }
        if (listenerObj instanceof HttpSessionAttributeListener) {
            this.getSessionManager().addAttributeListener((HttpSessionAttributeListener)listenerObj);
        }
        if (listenerObj instanceof HttpSessionActivationListener) {
            this.getSessionManager().addActivationListener((HttpSessionActivationListener)listenerObj);
        }
    }

    public ServletRequestListener[] getRequestListeners() {
        return this._requestListenerArray;
    }

    public ServletRequestAttributeListener[] getRequestAttributeListeners() {
        return this._requestAttributeListenerArray;
    }

    public MultipartForm createMultipartForm() {
        if (this._multipartForm == null) {
            this._multipartForm = new MultipartForm();
        }
        return this._multipartForm;
    }

    public boolean doMultipartForm() {
        return this._multipartForm != null && this._multipartForm.isEnable();
    }

    public long getFormUploadMax() {
        if (this._multipartForm != null) {
            return this._multipartForm.getUploadMax();
        }
        return -1L;
    }

    public AccessLog getAccessLog() {
        return this._accessLog;
    }

    public void setTempDir(Path path) {
        this._tempDir = path;
    }

    public JspPropertyGroup createJsp() {
        if (this._jsp == null) {
            this._jsp = new JspPropertyGroup();
        }
        return this._jsp;
    }

    public JspPropertyGroup getJsp() {
        return this._jsp;
    }

    public void addTaglib(JspTaglib taglib) {
        if (this._taglibList == null) {
            this._taglibList = new ArrayList();
        }
        this._taglibList.add(taglib);
    }

    public ArrayList<JspTaglib> getTaglibList() {
        return this._taglibList;
    }

    public void addJspConfig(JspConfig config) {
        this._extensions.put("jsp-config", config);
    }

    public Object getExtension(String key) {
        return this._extensions.get(key);
    }

    public WebAppExpandDeploy createWebAppDeploy() {
        return this._parent.createWebAppDeploy();
    }

    public void addWebAppDeploy(WebAppExpandDeploy deploy) throws Exception {
        String contextPath = this.getContextPath();
        String prefix = deploy.getURLPrefix();
        deploy.setURLPrefix(new StringBuffer().append(contextPath).append(prefix).toString());
        deploy.setParent(this._applicationEntry);
        deploy.setContainer(this._parent);
        deploy.setParentClassLoader(this.getClassLoader());
        deploy.deploy();
        this._parent.addWebAppDeploy(deploy);
        Environment.addEnvironmentListener(deploy, this.getClassLoader());
        this._appGenerators.add(deploy);
    }

    public void addWebApp(WebAppConfig config) throws Exception {
        String contextPath = this.getContextPath();
        String prefix = config.getId();
        if (prefix == null || prefix.equals("") || prefix.equals("/")) {
            throw new ConfigException(L.l("'{0}' is an illegal sub web-app id.", prefix));
        }
        ApplicationContainer container = this._parent;
        DeployContainer<WebAppEntry> appGenerator = this._parent.getApplicationGenerator();
        WebAppSingleDeploy deploy = new WebAppSingleDeploy(appGenerator, container, config);
        deploy.setURLPrefix(new StringBuffer().append(contextPath).append(prefix).toString());
        deploy.setParentWebApp(this._applicationEntry);
        deploy.setParentClassLoader(this.getClassLoader());
        deploy.setContainer(container);
        String appDir = config.getDocumentDirectory();
        if (appDir == null) {
            appDir = new StringBuffer().append("./").append(prefix).toString();
        }
        Path root = PathBuilder.lookupPath(appDir, null, this.getAppDir());
        deploy.setRootDirectory(root);
        deploy.init();
        this._parent.addDeploy(deploy);
    }

    @Override
    public void setConfigException(Throwable e) {
        this._configException = e;
        this._invocationDependency.add(AlwaysModified.create());
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    public void addEjbRef(EjbRef ref) {
    }

    public void addEjbLocalRef(EjbLocalRef ref) {
    }

    public Cluster getCluster() {
        return Cluster.getCluster(this.getClassLoader());
    }

    public boolean isIgnoreClientDisconnect() {
        DispatchServer server = this.getDispatchServer();
        if (server == null) {
            return true;
        }
        return server.isIgnoreClientDisconnect();
    }

    public void setShutdownWaitMax(Period wait) {
        this._shutdownWaitTime = wait.getPeriod();
    }

    public void addConfigFile(Path path) throws Exception {
        ResinImport rImport = new ResinImport();
        rImport.setPath(path);
        rImport.setOptional(true);
        rImport.setParent(this);
        rImport.init();
        log.config("<config-file> is deprecated.  Please use resin:import.");
    }

    public String getState() {
        return this._lifecycle.getStateName();
    }

    public boolean isInit() {
        return this._lifecycle.isInit() || this._configException != null;
    }

    public boolean isInitializing() {
        return this._lifecycle.isBeforeActive();
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroyed();
    }

    public void init() throws Exception {
        if (!this._lifecycle.toInitializing()) {
            return;
        }
        this._classLoader.setId(new StringBuffer().append("web-app:").append(this.getURL()).toString());
        if (this._tempDir == null) {
            this._tempDir = (Path)Environment.getLevelAttribute("caucho.temp-dir");
        }
        if (this._tempDir == null) {
            this._tempDir = this.getAppDir().lookup("WEB-INF/tmp");
        }
        this._tempDir.mkdirs();
        this.setAttribute("javax.servlet.context.tempdir", new File(this._tempDir.getNativePath()));
        FilterChainBuilder securityBuilder = this._constraintManager.getFilterBuilder();
        if (securityBuilder != null) {
            this._filterMapper.addTopFilter(securityBuilder);
        }
        this._cache = (AbstractCache)Environment.getAttribute("caucho.server.cache");
        for (int i = 0; i < this._appGenerators.size(); ++i) {
            this._parent.addDeploy(this._appGenerators.get(i));
        }
        this._classLoader.setId(new StringBuffer().append("web-app:").append(this.getURL()).toString());
        try {
            InitialContext ic = new InitialContext();
            ServletAuthenticator auth = (ServletAuthenticator)ic.lookup("java:comp/env/caucho/auth");
            this.setAttribute("caucho.authenticator", auth);
        }
        catch (Exception e) {
            log.finest(e.toString());
        }
        WebAppEntry parent = null;
        if (this._applicationEntry != null) {
            parent = this._applicationEntry.getParent();
        }
        if (this._isInheritSession && parent != null && this._sessionManager != parent.getApplication().getSessionManager()) {
            SessionManager sessionManager = this._sessionManager;
            this._sessionManager = parent.getApplication().getSessionManager();
            if (sessionManager != null) {
                sessionManager.close();
            }
        }
        this._lifecycle.toInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this._lifecycle.isInit()) {
            throw new IllegalStateException(L.l("application must be initialized before starting"));
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        boolean isOkay = true;
        try {
            thread.setContextClassLoader(this._classLoader);
            if (!this._lifecycle.toStarting()) {
                return;
            }
            isOkay = false;
            if (this._accessLog == null) {
                this._accessLog = _accessLogLocal.get();
            }
            long interval = this._classLoader.getDependencyCheckInterval();
            this._invocationDependency.setCheckInterval(interval);
            if (this._parent != null) {
                this._invocationDependency.add(this._parent.getApplicationGenerator());
            }
            this._invocationDependency.isModified();
            String serverId = (String)new EnvironmentLocal("caucho.server-id").get();
            if (serverId != null) {
                this.setAttribute("caucho.server-id", serverId);
            }
            this._classLoader.start();
            try {
                this.getSessionManager().start();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            ServletContextEvent event = new ServletContextEvent(this);
            for (int i = 0; i < this._applicationListeners.size(); ++i) {
                ServletContextListener listener = this._applicationListeners.get(i);
                try {
                    listener.contextInitialized(event);
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            try {
                this._servletManager.init();
                this._filterManager.init();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                this.setConfigException(e);
            }
            this._lifecycle.toActive();
            if (this._parent instanceof Host) {
                Host host = (Host)this._parent;
                host.setConfigETag(null);
            }
            if (this._parent != null) {
                this._parent.clearCache();
            }
            isOkay = true;
        }
        finally {
            if (!isOkay) {
                this._lifecycle.toFailed();
            }
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public boolean isModified() {
        return this.isModifiedForAutomaticRedeploy() || this._configException != null;
    }

    @Override
    public boolean isModifiedForAutomaticRedeploy() {
        if (this._lifecycle.isAfterActive()) {
            return true;
        }
        if (this._classLoader.isModified()) {
            return true;
        }
        if (this._configException == null) {
            return false;
        }
        if (!(this._configException instanceof ConfigException)) {
            return true;
        }
        if (this._configException.getCause() == null) {
            return false;
        }
        if (this._configException.getCause() instanceof ConfigException) {
            return false;
        }
        return !(this._configException.getCause() instanceof Error);
    }

    @Override
    public ServletContext getContext(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException(L.l("getContext URI must not be null."));
        }
        if (!uri.startsWith("/")) {
            if (uri.equals("")) {
                uri = "/";
            } else {
                throw new IllegalArgumentException(L.l("getContext URI `{0}' must be absolute.", uri));
            }
        }
        try {
            if (this._parent != null) {
                return this._parent.findApplicationByURI(uri);
            }
            return this;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public String getServletPattern(String uri) {
        return this._servletMapper.getServletPattern(uri);
    }

    public ArrayList<String> getServletMappingPatterns() {
        return this._servletMapper.getURLPatterns();
    }

    public ArrayList<String> getServletIgnoreMappingPatterns() {
        return this._servletMapper.getIgnorePatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildInvocation(Invocation invocation) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClassLoader());
        try {
            if (this._configException != null) {
                ExceptionFilterChain chain = new ExceptionFilterChain(this._configException);
                invocation.setFilterChain(chain);
                invocation.setDependency(AlwaysModified.create());
                return;
            }
            if (!this._lifecycle.waitForActive(this._activeWaitTime)) {
                int code = 503;
                ErrorFilterChain chain = new ErrorFilterChain(code);
                invocation.setFilterChain(chain);
                invocation.setDependency(AlwaysModified.create());
                return;
            }
            FilterChain chain = this._servletMapper.mapServlet(invocation);
            this._filterMapper.buildDispatchChain(invocation, chain);
            chain = invocation.getFilterChain();
            if (this._cache != null) {
                chain = this._cache.createFilterChain(chain, this);
            }
            chain = new WebAppFilterChain(chain, this);
            invocation.setFilterChain(chain);
        }
        catch (Throwable e) {
            FilterChain chain = new ExceptionFilterChain(e);
            chain = new WebAppFilterChain(chain, this);
            invocation.setDependency(AlwaysModified.create());
            invocation.setFilterChain(chain);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void buildIncludeInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._includeFilterMapper);
    }

    public void buildForwardInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._forwardFilterMapper);
    }

    public void buildErrorInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._errorFilterMapper);
    }

    public void buildLoginInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._loginFilterMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDispatchInvocation(Invocation invocation, FilterMapper filterMapper) throws ServletException {
        invocation.setApplication(this);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClassLoader());
        try {
            FilterChain chain;
            if (this._configException != null) {
                chain = new ExceptionFilterChain(this._configException);
                invocation.setDependency(AlwaysModified.create());
            } else {
                chain = this._servletMapper.mapServlet(invocation);
                filterMapper.buildDispatchChain(invocation, chain);
                chain = invocation.getFilterChain();
                chain = new DispatchFilterChain(chain, this);
                if (this._cache != null && filterMapper == this._includeFilterMapper) {
                    chain = this._cache.createFilterChain(chain, this);
                }
            }
            invocation.setFilterChain(chain);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String url) {
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url `{0}' must be absolute", url));
        }
        RequestDispatcher disp = this.getDispatcherCache().get(url);
        if (disp != null) {
            return disp;
        }
        Invocation includeInvocation = new Invocation();
        Invocation forwardInvocation = new Invocation();
        Invocation errorInvocation = new Invocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = this.escapeURL(new StringBuffer().append(this._contextPath).append(url).toString());
        try {
            decoder.splitQuery(includeInvocation, rawURI);
            decoder.splitQuery(forwardInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            if (this._parent != null) {
                this._parent.buildIncludeInvocation(includeInvocation);
                this._parent.buildForwardInvocation(forwardInvocation);
                this._parent.buildErrorInvocation(errorInvocation);
            } else {
                FilterChain chain = this._servletMapper.mapServlet(includeInvocation);
                this._includeFilterMapper.buildDispatchChain(includeInvocation, chain);
                chain = this._servletMapper.mapServlet(forwardInvocation);
                this._forwardFilterMapper.buildDispatchChain(forwardInvocation, chain);
                chain = this._servletMapper.mapServlet(errorInvocation);
                this._errorFilterMapper.buildDispatchChain(errorInvocation, chain);
            }
            disp = new RequestDispatcherImpl(includeInvocation, forwardInvocation, errorInvocation, this);
            this.getDispatcherCache().put(url, disp);
            return disp;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LruCache<String, RequestDispatcher> getDispatcherCache() {
        LruCache<String, RequestDispatcher> cache = this._dispatcherCache;
        if (cache != null) {
            return cache;
        }
        Application application = this;
        synchronized (application) {
            this._dispatcherCache = cache = new LruCache(1024);
            return cache;
        }
    }

    private String escapeURL(String url) {
        return url;
    }

    public RequestDispatcher getLoginDispatcher(String url) {
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url `{0}' must be absolute", url));
        }
        Invocation loginInvocation = new Invocation();
        Invocation errorInvocation = new Invocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = new StringBuffer().append(this._contextPath).append(url).toString();
        try {
            decoder.splitQuery(loginInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            if (this._parent != null) {
                this._parent.buildInvocation(loginInvocation);
                this._parent.buildErrorInvocation(errorInvocation);
            } else {
                FilterChain chain = this._servletMapper.mapServlet(loginInvocation);
                this._filterMapper.buildDispatchChain(loginInvocation, chain);
                chain = this._servletMapper.mapServlet(errorInvocation);
                this._errorFilterMapper.buildDispatchChain(errorInvocation, chain);
            }
            RequestDispatcherImpl disp = new RequestDispatcherImpl(loginInvocation, loginInvocation, errorInvocation, this);
            disp.setLogin(true);
            return disp;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String servletName) {
        FilterChain chain;
        try {
            chain = this._servletManager.createServletChain(servletName);
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
        return new NamedDispatcherImpl(chain, null, this);
    }

    @Override
    public String getRealPath(String uri) {
        String fullURI = new StringBuffer().append(this.getContextPath()).append("/").append(uri).toString();
        try {
            fullURI = InvocationDecoder.normalizeUri(fullURI);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        Application app = (Application)this.getContext(fullURI);
        if (app == null) {
            return null;
        }
        String cp = app.getContextPath();
        String tail = fullURI.substring(cp.length());
        String realPath = app.getRealPathImpl(tail);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(new StringBuffer().append("real-path ").append(uri).append(" -> ").append(realPath).toString());
        }
        return realPath;
    }

    public String getRealPathImpl(String uri) {
        Path path;
        ArrayList<String> regexpVars = new ArrayList<String>();
        String map = this._pathMapping.map(uri, regexpVars);
        if (map == null) {
            path = this.getAppDir().lookup(new StringBuffer().append("./").append(uri).toString());
        } else {
            try {
                path = PathBuilder.lookupPath(map, regexpVars);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                path = this.getAppDir().lookup(map);
            }
            String match = regexpVars.get(0);
            String tail = uri.substring(match.length());
            if (uri.endsWith("/") && !tail.endsWith("/")) {
                tail = new StringBuffer().append(tail).append('/').toString();
            }
            if (tail.startsWith("/")) {
                tail = new StringBuffer().append('.').append(tail).toString();
            }
            if (!tail.equals("")) {
                path = path.lookup(tail);
            }
        }
        String nativePath = path.getNativePath();
        return nativePath;
    }

    @Override
    public String getMimeType(String uri) {
        if (uri == null) {
            return null;
        }
        String fullURI = new StringBuffer().append(this.getContextPath()).append("/").append(uri).toString();
        try {
            fullURI = InvocationDecoder.normalizeUri(fullURI);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        Application app = (Application)this.getContext(fullURI);
        if (app == null) {
            return null;
        }
        int p = uri.lastIndexOf(46);
        if (p < 0) {
            return null;
        }
        return app.getMimeTypeImpl(uri.substring(p));
    }

    public String getMimeTypeImpl(String ext) {
        return this._mimeMapping.get(ext);
    }

    @Override
    public void log(String message, Throwable e) {
        if (e != null) {
            log.log(Level.WARNING, message, e);
        } else {
            log.info(message);
        }
    }

    public AbstractLogin getLogin() {
        return this._loginManager;
    }

    public ServletAuthenticator getAuthenticator() {
        AbstractLogin login = this.getLogin();
        if (login != null) {
            return login.getAuthenticator();
        }
        return null;
    }

    public SessionManager getSessionManager() {
        if (this._sessionManager == null) {
            if (this._isInheritSession && this._parent != null) {
                this._sessionManager = this._parent.getSessionManager();
            }
            if (this._sessionManager == null) {
                try {
                    this._sessionManager = new SessionManager(this);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        return this._sessionManager;
    }

    public ErrorPageManager getErrorPageManager() {
        return this._errorPageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean enterWebApp() {
        Object object = this._countLock;
        synchronized (object) {
            ++this._requestCount;
        }
        return this._lifecycle.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void exitWebApp() {
        Object object = this._countLock;
        synchronized (object) {
            --this._requestCount;
        }
    }

    public int getRequestCount() {
        return this._requestCount;
    }

    public void addCacheMapping(CacheMapping mapping) throws Exception {
        this._cacheMappingMap.addMap(mapping.getUrlPattern(), mapping);
    }

    public long getCacheTime(String uri) {
        CacheMapping map = this._cacheMappingMap.map(uri);
        if (map != null) {
            return map.getExpires();
        }
        return 5000L;
    }

    public long getCacheMaxLength() {
        return 1000000L;
    }

    public String[] getClassLoaderHackPackages() {
        return _classLoaderHackPackages;
    }

    public int getActiveSessionCount() {
        SessionManager manager = this.getSessionManager();
        if (manager != null) {
            return manager.getActiveSessionCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            if (!this._lifecycle.toStopping()) {
                return;
            }
            long beginStop = Alarm.getCurrentTime();
            while (this._requestCount > 0 && Alarm.getCurrentTime() < beginStop + this._shutdownWaitTime && !Alarm.isTest()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable e) {}
            }
            if (this._requestCount > 0) {
                log.warning(L.l("{0} closing with {1} active requests.", (Object)this.toString(), this._requestCount));
            }
            try {
                this._classLoader.stop();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            this._lifecycle.toStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        if (this._parent != null) {
            this._parent.clearCache();
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            for (int i = this._appGenerators.size() - 1; i >= 0; --i) {
                try {
                    Deploy deploy = this._appGenerators.get(i);
                    this._parent.removeWebAppDeploy(deploy);
                    deploy.destroy();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            ServletContextEvent event = new ServletContextEvent(this);
            this._servletManager.destroy();
            this._filterManager.destroy();
            for (int i = this._applicationListeners.size() - 1; i >= 0; --i) {
                ServletContextListener listener = this._applicationListeners.get(i);
                try {
                    listener.contextDestroyed(event);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            SessionManager sessionManager = this._sessionManager;
            this._sessionManager = null;
            if (!(sessionManager == null || this._isInheritSession && this._applicationEntry.getParent() != null)) {
                sessionManager.close();
            }
            if (this._accessLog != null) {
                try {
                    this._accessLog.flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            this._classLoader.destroy();
        }
    }

    public String toString() {
        return new StringBuffer().append("Application[").append(this.getURL()).append("]").toString();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Var {
        public String getURL() {
            return Application.this.getURL();
        }

        public String getId() {
            return this.getName();
        }

        public String getName() {
            String id = Application.this._applicationEntry.getId();
            if (id != null) {
                return id;
            }
            return Application.this.getContextPath();
        }

        public Path getAppDir() {
            return Application.this.getAppDir();
        }

        public Path getDocDir() {
            return Application.this.getAppDir();
        }

        public String getContextPath() {
            return Application.this.getContextPath();
        }

        public ArrayList<String> getRegexp() {
            return Application.this.getRegexp();
        }

        public String toString() {
            return Application.this.toString();
        }
    }
}

