/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.i18n.CharacterEncoding;
import com.caucho.log.Log;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.Form;
import com.caucho.server.connection.RequestAdapter;
import com.caucho.server.connection.ServletInputStreamImpl;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.HashMapImpl;
import com.caucho.vfs.BufferedReaderAdapter;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.ReadStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DispatchRequest
extends RequestAdapter {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/DispatchRequest"));
    private static final FreeList<DispatchRequest> _freeList = new FreeList(32);
    private Application _application;
    private Application _oldApplication;
    private Form _formParser;
    private HashMapImpl<String, String[]> _form;
    protected ReadStream _readStream;
    protected ServletInputStreamImpl _is;
    private BufferedReaderAdapter _bufferedReader;
    private String _method;
    private String _uri;
    private String _servletPath;
    private String _pathInfo;
    private String _queryString;
    private String _addedQuery;
    private SessionImpl _session;
    private String _pageUri;
    private String _pageContextPath;
    private String _pageServletPath;
    private String _pagePathInfo;
    private String _pageQueryString;

    protected DispatchRequest() {
    }

    public static DispatchRequest createDispatch() {
        DispatchRequest req = _freeList.allocate();
        if (req == null) {
            req = new DispatchRequest();
        }
        return req;
    }

    void init(Application application, Application oldApplication, HttpServletRequest request, HttpServletResponse response, String method, String uri, String servletPath, String pathInfo, String queryString, String addedQuery) throws ServletException {
        super.init(request, response, this._application);
        this._application = application;
        this._oldApplication = oldApplication;
        this._form = null;
        this._readStream = null;
        this._is = null;
        this._bufferedReader = null;
        this._method = method;
        this._uri = uri;
        this._servletPath = servletPath;
        this._pathInfo = pathInfo;
        this._queryString = queryString;
        this._addedQuery = addedQuery;
        this._pageUri = null;
        this._pageContextPath = null;
        this._pageServletPath = null;
        this._pagePathInfo = null;
        this._pageQueryString = null;
        this._session = null;
    }

    void setStream(ReadStream readStream) {
        this._readStream = readStream;
    }

    @Override
    public Application getApplication() {
        return this._application;
    }

    @Override
    public String getMethod() {
        return this._method;
    }

    @Override
    public String getRequestURI() {
        return this._uri;
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        if (this.getServerPort() > 0 && this.getServerPort() != 80 && this.getServerPort() != 443) {
            sb.append(":");
            sb.append(this.getServerPort());
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    void setPageURI(String uri) {
        this._pageUri = uri;
    }

    @Override
    public String getPageURI() {
        return this._pageUri;
    }

    @Override
    public String getContextPath() {
        return this._application.getContextPath();
    }

    void setPageContextPath(String contextPath) {
        this._pageContextPath = contextPath;
    }

    @Override
    public String getPageContextPath() {
        return this._pageContextPath;
    }

    @Override
    public String getServletPath() {
        return this._servletPath;
    }

    @Override
    public String getPageServletPath() {
        return this._pageServletPath;
    }

    void setPageServletPath(String servletPath) {
        this._pageServletPath = servletPath;
    }

    @Override
    public String getPathInfo() {
        return this._pathInfo;
    }

    @Override
    public String getPagePathInfo() {
        return this._pagePathInfo;
    }

    void setPagePathInfo(String pathInfo) {
        this._pagePathInfo = pathInfo;
    }

    @Override
    public String getQueryString() {
        return this._queryString;
    }

    void setPageQueryString(String queryString) {
        this._pageQueryString = queryString;
    }

    @Override
    public String getPageQueryString() {
        return this._pageQueryString;
    }

    @Override
    public Map getParameterMap() {
        if (this._form == null) {
            this._form = this.parseQuery();
        }
        return this._form;
    }

    @Override
    public Enumeration getParameterNames() {
        if (this._form == null) {
            this._form = this.parseQuery();
        }
        return Collections.enumeration(this._form.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this._form == null) {
            this._form = this.parseQuery();
        }
        return this._form.get(name);
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    private HashMapImpl<String, String[]> parseQuery() {
        HashMapImpl<String, String[]> table = new HashMapImpl<String, String[]>();
        String defaultEncoding = CharacterEncoding.getLocalEncoding();
        String charEncoding = this.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = defaultEncoding;
        }
        String javaEncoding = Encoding.getJavaName(charEncoding);
        if (this._addedQuery != null) {
            try {
                if (this._formParser == null) {
                    this._formParser = new Form();
                }
                this._formParser.parseQueryString(table, this._addedQuery, javaEncoding, false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Enumeration en = super.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String[] oldValues = super.getParameterValues(key);
            String[] newValues = table.get(key);
            if (newValues == null) {
                table.put(key, oldValues);
                continue;
            }
            String[] next = new String[oldValues.length + newValues.length];
            System.arraycopy(newValues, 0, next, 0, newValues.length);
            System.arraycopy(oldValues, 0, next, newValues.length, oldValues.length);
            table.put(key, next);
        }
        return table;
    }

    @Override
    public String getRealPath(String path) {
        return this._application.getRealPath(path);
    }

    @Override
    public String getPathTranslated() {
        if (this._pathInfo != null) {
            return this.getRealPath(this._pathInfo);
        }
        return null;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (path.startsWith("/")) {
            return this._application.getRequestDispatcher(path);
        }
        return this._application.getRequestDispatcher(new StringBuffer().append(this.getPwd()).append(path).toString());
    }

    public String getPwd() {
        int p;
        String pathInfo;
        CharBuffer cb = CharBuffer.allocate();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        return cb.close();
    }

    @Override
    public ReadStream getStream() throws IOException {
        if (this._readStream == null && this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getStream();
        }
        return this._readStream;
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this._readStream == null) {
            return super.getInputStream();
        }
        if (this._is == null) {
            this._is = new ServletInputStreamImpl();
        }
        this._is.init(this._readStream);
        return this._is;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this._readStream == null) {
            return super.getReader();
        }
        if (this._bufferedReader == null) {
            this._bufferedReader = new BufferedReaderAdapter(this.getStream());
        }
        this._bufferedReader.init(this.getStream());
        return this._bufferedReader;
    }

    @Override
    public HttpSession getSession(boolean create) {
        SessionManager manager = this._application.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        if (this._session != null && this._session.isValid()) {
            this.setHasCookie();
            return this._session;
        }
        if (this._application == this._oldApplication) {
            HttpSession hSession = super.getSession(create);
            if (hSession != null) {
                this.setHasCookie();
            }
            return hSession;
        }
        SessionImpl oldSession = this._session;
        this._session = this.createSession(create, oldSession != null);
        if (this._session != null && this._session != oldSession) {
            this._session.addUse();
        }
        if (this._session != null) {
            this.setHasCookie();
        }
        return this._session;
    }

    private SessionImpl createSession(boolean create, boolean hasOldSession) {
        HttpServletResponse response;
        SessionImpl session;
        SessionManager manager = this.getSessionManager();
        String id = this.getRequestedSessionId();
        long now = Alarm.getCurrentTime();
        if (id != null && id.length() > 6) {
            session = manager.getSession(id, now, create, this.isRequestedSessionIdFromCookie());
            if (session != null && session.isValid()) {
                HttpServletResponse response2;
                if (session != null) {
                    this.setHasCookie();
                }
                if (!session.getId().equals(id) && manager.enableSessionCookies() && (response2 = this.getResponse()) instanceof CauchoResponse) {
                    ((CauchoResponse)this.getResponse()).setSessionId(session.getId());
                }
                return session;
            }
        } else {
            id = null;
        }
        if (!create) {
            return null;
        }
        session = manager.createSession(id, now, this, this.isRequestedSessionIdFromCookie());
        if (session != null) {
            this.setHasCookie();
        }
        if (session.getId().equals(id)) {
            return session;
        }
        if (manager.enableSessionCookies() && (response = this.getResponse()) instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).setSessionId(session.getId());
        }
        return session;
    }

    @Override
    public boolean authenticate() throws ServletException, IOException {
        if (!(this.getRequest() instanceof CauchoRequest)) {
            return false;
        }
        return ((CauchoRequest)this.getRequest()).authenticate();
    }

    public void finish() throws IOException {
        SessionImpl session = this._session;
        this._session = null;
        if (session != null) {
            session.finish();
        }
    }

    public static void free(DispatchRequest req) {
        req.free();
        _freeList.free(req);
    }

    @Override
    protected void free() {
        super.free();
        this._session = null;
        this._application = null;
        this._oldApplication = null;
        this._readStream = null;
        if (this._is != null) {
            this._is.free();
        }
    }
}

