/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.Version;
import com.caucho.java.LineMap;
import com.caucho.java.LineMapException;
import com.caucho.log.Log;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CompileException;
import com.caucho.util.HTTPUtil;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.Encoding;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ErrorPageManager {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/webapp/ErrorPageManager"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/ErrorPageManager"));
    public static final char[] MSIE_PADDING;
    public static String REQUEST_URI;
    public static String CONTEXT_PATH;
    public static String SERVLET_PATH;
    public static String PATH_INFO;
    public static String QUERY_STRING;
    public static String STATUS_CODE;
    public static String EXCEPTION_TYPE;
    public static String MESSAGE;
    public static String EXCEPTION;
    public static String ERROR_URI;
    public static String SERVLET_NAME;
    public static String JSP_EXCEPTION;
    public static String SHUTDOWN;
    private Application _app;
    private ApplicationContainer _appContainer;
    private HashMap<Object, String> _errorPageMap = new HashMap();
    private String _defaultLocation;
    private ErrorPageManager _parent;

    public void setParent(ErrorPageManager parent) {
        this._parent = parent;
    }

    public ErrorPageManager getParent() {
        return this._parent;
    }

    public void addErrorPage(ErrorPage errorPage) {
        if (errorPage.getExceptionType() != null) {
            this._errorPageMap.put(errorPage.getExceptionType(), errorPage.getLocation());
        } else if (errorPage.getErrorCode() < 0) {
            this._defaultLocation = errorPage.getLocation();
        } else {
            this._errorPageMap.put(new Integer(errorPage.getErrorCode()), errorPage.getLocation());
        }
    }

    public void setApplication(Application app) {
        this._app = app;
    }

    public void setApplicationContainer(ApplicationContainer appContainer) {
        this._appContainer = appContainer;
    }

    public void sendServletError(Throwable e, ServletRequest req, ServletResponse res) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, e.toString(), e);
        }
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        Throwable rootExn = e;
        Throwable errorPageExn = null;
        LineMap lineMap = null;
        if (response instanceof AbstractHttpResponse) {
            ((AbstractHttpResponse)response).killCache();
            ((AbstractHttpResponse)response).setNoCache(true);
        }
        try {
            response.reset();
        }
        catch (IllegalStateException e1) {
            // empty catch block
        }
        if (rootExn instanceof ClientDisconnectException) {
            throw (ClientDisconnectException)rootExn;
        }
        String location = null;
        String title = "500 Servlet Exception";
        boolean badRequest = false;
        boolean doStackTrace = true;
        boolean isCompileException = false;
        boolean isLineCompileException = false;
        boolean isServletException = false;
        Throwable compileException = null;
        boolean lookupErrorPage = true;
        while (true) {
            if (rootExn instanceof LineMapException) {
                lineMap = ((LineMapException)((Object)rootExn)).getLineMap();
            }
            if (lookupErrorPage) {
                errorPageExn = rootExn;
            }
            if (rootExn instanceof CompileException) {
                doStackTrace = false;
                isCompileException = true;
                if (rootExn instanceof LineCompileException) {
                    compileException = rootExn;
                    isLineCompileException = true;
                } else if (compileException == null) {
                    compileException = rootExn;
                }
            }
            if (rootExn instanceof BadRequestException) {
                badRequest = true;
            }
            if (location == null && lookupErrorPage && (!(rootExn instanceof LineMapException) || !(rootExn instanceof ServletException) || rootExn instanceof LineCompileException || rootExn.getCause() == null)) {
                if (!isServletException) {
                    location = this.getErrorPage(rootExn);
                    isServletException = true;
                } else {
                    location = this.getErrorPage(rootExn);
                    lookupErrorPage = false;
                }
            }
            if (location != null) {
                lookupErrorPage = false;
            }
            Throwable cause = null;
            if (rootExn instanceof ServletException && !(rootExn instanceof LineCompileException)) {
                cause = ((ServletException)rootExn).getRootCause();
            } else {
                lookupErrorPage = false;
                cause = rootExn.getCause();
            }
            if (cause == null) break;
            rootExn = cause;
        }
        if (location == null && lookupErrorPage) {
            location = this.getErrorPage(rootExn);
        }
        if (location == null) {
            location = this.getErrorPage(500);
        }
        if (location == null && this._defaultLocation == null && this._parent != null) {
            this._parent.sendServletError(e, req, res);
            return;
        }
        if (isCompileException) {
            log.warning(compileException.getMessage());
        } else if (!doStackTrace) {
            log.warning(rootExn.toString());
        }
        if (badRequest) {
            title = rootExn.getMessage();
            doStackTrace = false;
            badRequest = true;
            if (request instanceof CauchoRequest) {
                ((CauchoRequest)request).killKeepalive();
            }
            response.resetBuffer();
            response.setStatus(400, rootExn.getMessage());
        } else if (rootExn instanceof UnavailableException) {
            UnavailableException unAvail = (UnavailableException)rootExn;
            if (unAvail.isPermanent()) {
                response.setStatus(404);
                title = "404 Not Found";
                if (location == null) {
                    location = this.getErrorPage(404);
                }
            } else {
                response.setStatus(503);
                title = "503 Unavailable";
                if (unAvail.getUnavailableSeconds() > 0) {
                    response.setIntHeader("Retry-After", unAvail.getUnavailableSeconds());
                }
                if (location == null) {
                    location = this.getErrorPage(503);
                }
            }
        } else {
            response.setStatus(500);
        }
        if (location == null) {
            location = this._defaultLocation;
        }
        if (location != null) {
            if (errorPageExn == null) {
                errorPageExn = rootExn;
            }
            request.setAttribute(JSP_EXCEPTION, errorPageExn);
            request.setAttribute(EXCEPTION, errorPageExn);
            request.setAttribute(EXCEPTION_TYPE, errorPageExn.getClass());
            if (request instanceof HttpServletRequest) {
                request.setAttribute(ERROR_URI, request.getRequestURI());
            }
            if (request instanceof AbstractHttpRequest) {
                request.setAttribute("javax.servlet.error.servlet_name", ((AbstractHttpRequest)request).getServletName());
            }
            request.setAttribute(STATUS_CODE, new Integer(500));
            request.setAttribute(MESSAGE, errorPageExn.getMessage());
            try {
                RequestDispatcher disp = null;
                if (this._app != null) {
                    disp = this._app.getRequestDispatcher(location);
                } else if (this._appContainer != null) {
                    disp = this._appContainer.getRequestDispatcher(location);
                }
                if (disp != null) {
                    ((RequestDispatcherImpl)disp).error(request, response);
                    return;
                }
            }
            catch (Throwable e1) {
                log.log(Level.FINE, e1.toString(), e1);
                rootExn = e1;
            }
        }
        response.setContentType("text/html");
        Locale locale = Locale.getDefault();
        if (!"ISO-8859-1".equals(Encoding.getMimeName(locale))) {
            response.setLocale(Locale.getDefault());
        }
        PrintWriter out = response.getWriter();
        out.println("<html>");
        if (!response.isCommitted()) {
            out.println("<head><title>" + title + "</title></head>");
        }
        out.println("<body>");
        out.println("<h1>" + title + "</h1>");
        out.println("<code><pre>");
        if (compileException != null) {
            out.println(this.escapeHtml(compileException.getMessage()));
        } else if (!doStackTrace) {
            out.println(this.escapeHtml(rootExn.toString()));
        }
        if (doStackTrace || log.isLoggable(Level.FINE)) {
            this.printStackTrace(out, rootExn, lineMap);
        }
        out.println("</pre></code>");
        if (!CauchoSystem.isTesting()) {
            out.println("<hr /><small>");
            out.println(Version.FULL_VERSION);
            out.println("</small>");
        }
        out.println("</body></html>");
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && userAgent.indexOf("MSIE") >= 0) {
            out.print(MSIE_PADDING);
        }
        out.close();
    }

    public void sendError(CauchoRequest request, CauchoResponse response, int code, String message) throws IOException {
        response.resetBuffer();
        response.setStatus(code, message);
        try {
            if (this.handleErrorStatus(request, response, code, message) || code == 304) {
                return;
            }
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<html>");
            if (!response.isCommitted()) {
                out.print("<head><title>");
                out.print(code);
                out.print(" ");
                out.print(message);
                out.println("</title></head>");
            }
            out.println("<body>");
            out.print("<h1>");
            out.print(code);
            out.print(" ");
            out.print(message);
            out.println("</h1>");
            if (code == 404) {
                out.println(L.l("{0} was not found on this server.", HTTPUtil.encodeString(request.getPageURI())));
            }
            if (!CauchoSystem.isTesting()) {
                out.println("<p /><hr />");
                out.println("<small>");
                out.println(Version.FULL_VERSION);
                out.println("</small>");
            }
            out.println("</body></html>");
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null && userAgent.indexOf("MSIE") >= 0) {
                out.write(MSIE_PADDING, 0, MSIE_PADDING.length);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private boolean handleErrorStatus(CauchoRequest request, CauchoResponse response, int code, String message) throws ServletException, IOException {
        if (code == 200 || code == 302 || code == 304) {
            return false;
        }
        if (request.getRequestDepth(0) > 16) {
            return false;
        }
        response.killCache();
        String location = this.getErrorPage(code);
        if (location == null) {
            location = this._defaultLocation;
        }
        if (location == null && this._parent != null) {
            return this._parent.handleErrorStatus(request, response, code, message);
        }
        if (this._app == null && this._appContainer == null) {
            return false;
        }
        if (location != null && !location.equals(request.getRequestURI())) {
            request.setAttribute("javax.servlet.error.status_code", new Integer(code));
            request.setAttribute("javax.servlet.error.message", message);
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            if (request instanceof AbstractHttpRequest) {
                request.setAttribute("javax.servlet.error.servlet_name", ((AbstractHttpRequest)request).getServletName());
            }
            try {
                RequestDispatcher disp = null;
                if (this._app != null) {
                    disp = this._app.getRequestDispatcher(location);
                } else if (this._appContainer != null) {
                    disp = this._appContainer.getRequestDispatcher(location);
                }
                if (disp == null) {
                    return false;
                }
                ((RequestDispatcherImpl)disp).error(request, response);
            }
            catch (Throwable e) {
                this.sendServletError(e, request, response);
            }
            return true;
        }
        return false;
    }

    String getErrorPage(Throwable e) {
        return this.getErrorPage(e, ClassLiteral.getClass((String)"java/lang/Throwable"));
    }

    String getErrorPage(Throwable e, Class limit) {
        Class<?> cl;
        for (cl = e.getClass(); cl != null; cl = cl.getSuperclass()) {
            String location = this._errorPageMap.get(cl.getName());
            if (location != null) {
                return location;
            }
            if (cl == limit) break;
        }
        for (cl = e.getClass(); cl != null; cl = cl.getSuperclass()) {
            String location;
            String name = cl.getName();
            int p = name.lastIndexOf(46);
            if (p > 0 && (location = this._errorPageMap.get(name = name.substring(p + 1))) != null) {
                return location;
            }
            if (cl == limit) break;
        }
        return null;
    }

    String getErrorPage(int code) {
        Integer key = new Integer(code);
        String location = this._errorPageMap.get(key);
        if (location != null) {
            return location;
        }
        return this._errorPageMap.get(new Integer(0));
    }

    private void printStackTrace(PrintWriter out, Throwable e, LineMap lineMap) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        if (lineMap != null) {
            lineMap.printStackTrace(e, pw);
        } else {
            e.printStackTrace(pw);
        }
        pw.close();
        char[] array = writer.toCharArray();
        out.print(this.escapeHtml(new String(array)));
    }

    private String escapeHtml(String s) {
        if (s == null) {
            return null;
        }
        CharBuffer cb = new CharBuffer();
        int lineCharacter = 0;
        boolean startsWithSpace = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            ++lineCharacter;
            if (ch == '<') {
                cb.append("&lt;");
                continue;
            }
            if (ch == '&') {
                cb.append("&amp;");
                continue;
            }
            if (ch == '\n' || ch == '\r') {
                lineCharacter = 0;
                cb.append(ch);
                startsWithSpace = false;
                continue;
            }
            if (lineCharacter > 70 && ch == ' ' && !startsWithSpace) {
                lineCharacter = 0;
                cb.append('\n');
                while (i + 1 < s.length() && s.charAt(i + 1) == ' ') {
                    ++i;
                }
                continue;
            }
            if (lineCharacter == 1 && (ch == ' ' || ch == '\t')) {
                cb.append(ch);
                startsWithSpace = true;
                continue;
            }
            cb.append(ch);
        }
        return cb.toString();
    }

    static {
        REQUEST_URI = "javax.servlet.include.request_uri";
        CONTEXT_PATH = "javax.servlet.include.context_path";
        SERVLET_PATH = "javax.servlet.include.servlet_path";
        PATH_INFO = "javax.servlet.include.path_info";
        QUERY_STRING = "javax.servlet.include.query_string";
        STATUS_CODE = "javax.servlet.error.status_code";
        EXCEPTION_TYPE = "javax.servlet.error.exception_type";
        MESSAGE = "javax.servlet.error.message";
        EXCEPTION = "javax.servlet.error.exception";
        ERROR_URI = "javax.servlet.error.request_uri";
        SERVLET_NAME = "javax.servlet.error.servlet_name";
        JSP_EXCEPTION = "javax.servlet.jsp.jspException";
        SHUTDOWN = "com.caucho.shutdown";
        MSIE_PADDING = "\n\n\n\n<!--\n   - Unfortunately, Microsoft has added a clever new\n   - \"feature\" to Internet Explorer.  If the text in\n   - an error's message is \"too small\", specifically\n   - less than 512 bytes, Internet Explorer returns\n   - its own error message.  Yes, you can turn that\n   - off, but *surprise* it's pretty tricky to find\n   - buried as a switch called \"smart error\n   - messages\"  That means, of course, that many of\n   - Resin's error messages are censored by default.\n   - And, of course, you'll be shocked to learn that\n   - IIS always returns error messages that are long\n   - enough to make Internet Explorer happy.  The\n   - workaround is pretty simple: pad the error\n   - message with a big comment to push it over the\n   - five hundred and twelve byte minimum.  Of course,\n   - that's exactly what you're reading right now.\n   -->\n".toCharArray();
    }
}

