/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.Version;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;

public class ServletContextImpl
implements ServletContext {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/ServletContextImpl"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/webapp/ServletContextImpl"));
    private String _name;
    private HashMap<String, Object> _attributes = new HashMap();
    private ArrayList<ServletContextAttributeListener> _applicationAttributeListeners;
    private HashMap<String, String> _initParams = new HashMap();

    public Path getAppDir() {
        return Vfs.lookup();
    }

    public void setDisplayName(String name) {
        this._name = name;
    }

    public String getServletContextName() {
        return this._name;
    }

    protected void addAttributeListener(ServletContextAttributeListener listener) {
        if (this._applicationAttributeListeners == null) {
            this._applicationAttributeListeners = new ArrayList();
        }
        this._applicationAttributeListeners.add(listener);
    }

    public String getServerInfo() {
        return "Resin/" + Version.VERSION;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    protected void setInitParameter(String name, String value) {
        this._initParams.put(name, value);
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        HashMap<String, Object> hashMap = this._attributes;
        synchronized (hashMap) {
            return this._attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap<String, Object> hashMap = this._attributes;
        synchronized (hashMap) {
            return Collections.enumeration(this._attributes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object oldValue;
        HashMap<String, Object> hashMap = this._attributes;
        synchronized (hashMap) {
            oldValue = value != null ? this._attributes.put(name, value) : this._attributes.remove(name);
        }
        if (this._applicationAttributeListeners != null) {
            ServletContextAttributeEvent event = oldValue != null ? new ServletContextAttributeEvent(this, name, oldValue) : new ServletContextAttributeEvent(this, name, value);
            for (int i = 0; i < this._applicationAttributeListeners.size(); ++i) {
                ServletContextAttributeListener objListener;
                ServletContextAttributeListener listener = objListener = this._applicationAttributeListeners.get(i);
                try {
                    if (oldValue != null) {
                        listener.attributeReplaced(event);
                        continue;
                    }
                    listener.attributeAdded(event);
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object oldValue;
        HashMap<String, Object> hashMap = this._attributes;
        synchronized (hashMap) {
            oldValue = this._attributes.remove(name);
        }
        if (this._applicationAttributeListeners != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent(this, name, oldValue);
            for (int i = 0; i < this._applicationAttributeListeners.size(); ++i) {
                ServletContextAttributeListener objListener;
                ServletContextAttributeListener listener = objListener = this._applicationAttributeListeners.get(i);
                try {
                    listener.attributeRemoved(event);
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    public String getRealPath(String uri) {
        return this.getAppDir().lookup("./" + uri).getNativePath();
    }

    public URL getResource(String name) {
        String realPath = this.getRealPath(name);
        try {
            Path path = this.getAppDir().lookupNative(realPath);
            if (path.canRead()) {
                return new URL(path.getURL());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public InputStream getResourceAsStream(String uripath) {
        Path path = this.getAppDir().lookupNative(this.getRealPath(uripath));
        try {
            if (path.canRead()) {
                return path.openRead();
            }
            return null;
        }
        catch (IOException e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }

    public Set getResourcePaths(String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        Path path = this.getAppDir().lookup(this.getRealPath(prefix));
        HashSet<String> set = new HashSet<String>();
        try {
            String[] list = path.list();
            for (int i = 0; i < list.length; ++i) {
                if (path.lookup(list[i]).isDirectory()) {
                    set.add(prefix + list[i] + '/');
                    continue;
                }
                set.add(prefix + list[i]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return set;
    }

    public ServletContext getContext(String uri) {
        return this;
    }

    public String getMimeType(String uri) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String servletName) {
        return null;
    }

    public final void log(String message) {
        this.log(message, null);
    }

    public final void log(Exception e, String msg) {
        this.log(msg, e);
    }

    public void log(String message, Throwable e) {
        if (e != null) {
            log.log(Level.WARNING, message, e);
        } else {
            log.info(message);
        }
    }

    public Servlet getServlet(String name) {
        throw new UnsupportedOperationException("getServlet is deprecated");
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException("getServletNames is deprecated");
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException("getServlets is deprecated");
    }
}

