/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.BuilderProgram;
import com.caucho.config.BuilderProgramContainer;
import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.server.deploy.Entry;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class WebAppConfig {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/webapp/WebAppConfig"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/WebAppConfig"));
    private String _id;
    private Pattern _urlRegexp;
    private String _contextPath;
    private String _appDir;
    private String _startupMode;
    private String _redeployMode;
    private BuilderProgramContainer _program = new BuilderProgramContainer();

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public String getContextPath() {
        String cp = this._contextPath;
        if (cp == null) {
            cp = this.getId();
        }
        if (cp == null) {
            return null;
        }
        if (cp.endsWith("/")) {
            return cp.substring(0, cp.length() - 1);
        }
        return cp;
    }

    public void setContextPath(String path) throws ConfigException {
        if (!path.startsWith("/")) {
            throw new ConfigException(L.l("context-path '{0}' must start with '/'.", path));
        }
        this._contextPath = path;
    }

    public void setURLRegexp(String pattern) {
        if (!pattern.endsWith("$")) {
            pattern = pattern + "$";
        }
        if (!pattern.startsWith("^")) {
            pattern = "^" + pattern;
        }
        this._urlRegexp = CauchoSystem.isCaseInsensitive() ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
    }

    public Pattern getURLRegexp() {
        return this._urlRegexp;
    }

    public void setAppDir(String appDir) {
        this._appDir = appDir;
    }

    public String getAppDir() {
        return this._appDir;
    }

    public String getDocumentDirectory() {
        return this.getAppDir();
    }

    public void setDocumentDirectory(String dir) {
        this.setAppDir(dir);
    }

    public void setStartupMode(String mode) throws ConfigException {
        this._startupMode = Entry.toStartupCode(mode);
    }

    public String getStartupMode() {
        return this._startupMode;
    }

    public void setLazyInit(boolean isLazy) throws ConfigException {
        log.config(L.l("lazy-init is deprecated.  Use <startup-mode>lazy</startup-mode> instead."));
        if (isLazy) {
            this.setStartupMode("lazy");
        } else {
            this.setStartupMode("automatic");
        }
    }

    public void setRedeployMode(String mode) throws ConfigException {
        this._redeployMode = Entry.toRedeployCode(mode);
    }

    public String getRedeployMode() {
        return this._redeployMode;
    }

    public void addBuilderProgram(BuilderProgram program) {
        this._program.addProgram(program);
    }

    public BuilderProgram getBuilderProgram() {
        return this._program;
    }

    public void init() throws ConfigException {
        if (this._urlRegexp != null && (this._appDir == null || this._appDir.indexOf("$") < 0)) {
            log.config(L.l("<web-app> with url-regexp expects a <document-directory>  with replacement variables (e.g. $1)."));
        }
    }
}

