/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.log.Log;
import com.caucho.server.deploy.Deploy;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.e_app.EarDeploy;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppEntry;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppEarDeploy
extends Deploy<WebAppEntry> {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/WebAppEarDeploy"));
    private ApplicationContainer _container;
    private String _urlPrefix = "";
    private ClassLoader _parentLoader;
    private EarDeploy _earDeploy;

    public WebAppEarDeploy(DeployContainer<WebAppEntry> deployContainer) {
        super(deployContainer);
    }

    public WebAppEarDeploy(DeployContainer<WebAppEntry> deployContainer, ApplicationContainer container, EarDeploy earDeploy) throws Exception {
        super(deployContainer);
        this.setContainer(container);
        this._earDeploy = earDeploy;
    }

    public ApplicationContainer getContainer() {
        return this._container;
    }

    public void setContainer(ApplicationContainer container) {
        this._container = container;
        if (this._parentLoader == null) {
            this._parentLoader = container.getClassLoader();
        }
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public boolean isModified() {
        return this._earDeploy.isModified();
    }

    @Override
    public void redeployIfModified() {
        this._earDeploy.redeployIfModified();
    }

    @Override
    public WebAppEntry generateEntry(String name) {
        return this._earDeploy.findWebAppEntry(name);
    }

    public void deploy() {
        try {
            this._earDeploy.deploy();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return new StringBuffer().append("WebAppEarDeploy[").append(this._earDeploy).append("]").toString();
    }
}

