/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.ExpandDeploy;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppEntry;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppExpandDeploy
extends ExpandDeploy<WebAppEntry>
implements EnvironmentListener {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/WebAppExpandDeploy"));
    private ApplicationContainer _container;
    private WebAppEntry _parent;
    private String _urlPrefix = "";
    private ArrayList<WebAppConfig> _webAppDefaults = new ArrayList();
    private HashMap<Path, WebAppConfig> _webAppConfigMap = new HashMap();
    private ClassLoader _parentLoader;
    private boolean _isActive;

    public WebAppExpandDeploy(DeployContainer<WebAppEntry> container) {
        super((DeployContainer)container);
        try {
            this.setExtension(".war");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public ApplicationContainer getContainer() {
        return this._container;
    }

    public void setContainer(ApplicationContainer container) {
        this._container = container;
        if (this._parentLoader == null) {
            this._parentLoader = container.getClassLoader();
        }
    }

    public void setParent(WebAppEntry parent) {
        this._parent = parent;
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        if (prefix.equals("")) {
            // empty if block
        }
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        log.config("lazy-init is deprecated.  Use <startup>lazy</startup> instead.");
        if (lazyInit) {
            this.setStartupMode("lazy");
        } else {
            this.setStartupMode("automatic");
        }
    }

    public void addWebApp(WebAppConfig config) {
        String docDir = config.getDocumentDirectory();
        Path appDir = this.getExpandDirectory().lookup(docDir);
        this._webAppConfigMap.put(appDir, config);
    }

    public void addWebAppDefault(WebAppConfig config) {
        this._webAppDefaults.add(config);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public void start() {
        Environment.addEnvironmentListener(this, this._parentLoader);
        super.start();
    }

    @Override
    protected WebAppEntry createEntry(String name) throws Exception {
        Path rootDirectory;
        WebAppConfig cfg;
        if (!name.startsWith(this._urlPrefix)) {
            return null;
        }
        String segmentName = name.substring(this._urlPrefix.length());
        if (segmentName.equals("")) {
            segmentName = "/ROOT";
        }
        if ((cfg = this._webAppConfigMap.get(rootDirectory = this.getExpandDirectory().lookup(new StringBuffer().append(".").append(segmentName).toString()))) != null && cfg.getContextPath() != null) {
            name = cfg.getContextPath();
        }
        WebAppEntry entry = new WebAppEntry(this._container, name);
        entry.setName(name);
        entry.setId(segmentName.substring(1));
        entry.setRootDirectory(rootDirectory);
        entry.setStartupMode(this.getStartupMode());
        entry.setParentWebApp(this._parent);
        Path jarPath = this.getPath().lookup(new StringBuffer().append(".").append(segmentName).append(".war").toString());
        entry.setArchivePath(jarPath);
        entry.addDepend(jarPath);
        entry.setDynamicDeploy(true);
        entry.setSourceType("expand");
        for (int i = 0; i < this._webAppDefaults.size(); ++i) {
            entry.addWebAppDefault(this._webAppDefaults.get(i));
        }
        if (cfg != null) {
            entry.addWebAppDefault(cfg);
        }
        return entry;
    }

    @Override
    protected String pathNameToEntryName(String name) {
        if (name.startsWith("_") || name.startsWith(".") || name.equalsIgnoreCase("meta-inf") || name.equalsIgnoreCase("web-inf")) {
            return null;
        }
        if (name.equalsIgnoreCase("root")) {
            return this._urlPrefix;
        }
        return new StringBuffer().append(this._urlPrefix).append("/").append(name).toString();
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this._isActive = true;
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }

    @Override
    public void destroy() {
        this._isActive = false;
        this._container.removeWebAppDeploy(this);
        Environment.removeEnvironmentListener(this, this._parentLoader);
        super.destroy();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("WebAppExpandDeploy[").append(this.getExpandDirectory()).append("]").toString();
    }
}

