/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.PathBuilder;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.server.deploy.Deploy;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppEntry;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppSingleDeploy
extends Deploy<WebAppEntry>
implements EnvironmentListener {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/WebAppSingleDeploy"));
    private ApplicationContainer _container;
    private WebAppEntry _parentWebApp;
    private String _urlPrefix = "";
    private Path _archivePath;
    private Path _rootDirectory;
    private WebAppConfig _config;
    private ClassLoader _parentLoader;
    private WebAppEntry _entry;

    public WebAppSingleDeploy(DeployContainer<WebAppEntry> deployContainer) {
        super(deployContainer);
    }

    public WebAppSingleDeploy(DeployContainer<WebAppEntry> deployContainer, ApplicationContainer container, WebAppConfig config) throws Exception {
        super(deployContainer);
        this.setContainer(container);
        String contextPath = config.getContextPath();
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        this.setURLPrefix(config.getContextPath());
        this._config = config;
    }

    public ApplicationContainer getContainer() {
        return this._container;
    }

    public void setContainer(ApplicationContainer container) {
        this._container = container;
        if (this._parentLoader == null) {
            this._parentLoader = container.getClassLoader();
        }
    }

    public void setParentWebApp(WebAppEntry parent) {
        this._parentWebApp = parent;
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        if (!prefix.startsWith("/")) {
            prefix = new StringBuffer().append("/").append(prefix).toString();
        }
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    public void init() throws Exception {
        if (this._entry != null) {
            return;
        }
        String appDir = this._config.getDocumentDirectory();
        if (appDir == null) {
            appDir = new StringBuffer().append("./").append(this._urlPrefix).toString();
        }
        if (this._rootDirectory == null) {
            this._rootDirectory = PathBuilder.lookupPath(appDir, null, this._container.getDocumentDirectory());
        }
        this._entry = new WebAppEntry(this._container, this._urlPrefix);
        this._entry.setName(this._urlPrefix);
        this._entry.setRootDirectory(this._rootDirectory);
        this._entry.setArchivePath(this._archivePath);
        if (this._archivePath != null) {
            this._entry.addDepend(this._archivePath);
        }
        this._entry.setParentWebApp(this._parentWebApp);
        this._entry.addWebAppDefault(this._config);
        this._entry.setSourceType("single");
        Environment.addEnvironmentListener(this, this._parentLoader);
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        keys.add(this._entry.getName());
    }

    @Override
    public WebAppEntry generateEntry(String name) {
        if (this._entry.isNameMatch(name)) {
            return this._entry;
        }
        return null;
    }

    @Override
    public WebAppEntry mergeEntry(WebAppEntry entry, String name) {
        if (!this._entry.isNameMatch(name)) {
            return entry;
        }
        return entry.merge(this._entry);
    }

    public void deploy() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void destroy() {
        this._container.removeWebAppDeploy(this);
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }

    public String toString() {
        return new StringBuffer().append("WebAppDeploy[").append(this._urlPrefix).append("]").toString();
    }
}

