/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.Version;
import com.caucho.log.Log;
import com.caucho.server.webapp.Application;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FastCGIServlet
extends GenericServlet {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/servlets/FastCGIServlet"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/servlets/FastCGIServlet"));
    private static final int FCGI_BEGIN_REQUEST = 1;
    private static final int FCGI_ABORT_REQUEST = 2;
    private static final int FCGI_END_REQUEST = 3;
    private static final int FCGI_PARAMS = 4;
    private static final int FCGI_STDIN = 5;
    private static final int FCGI_STDOUT = 6;
    private static final int FCGI_STDERR = 7;
    private static final int FCGI_DATA = 8;
    private static final int FCGI_GET_VALUES = 9;
    private static final int FCGI_GET_VALUES_RESULT = 10;
    private static final int FCGI_UNKNOWNE_TYPE = 11;
    private static final int FCGI_RESPONDER = 1;
    private static final int FCGI_AUTHORIZER = 2;
    private static final int FCGI_FILTER = 3;
    private static final int FCGI_VERSION = 1;
    private static final int FCGI_KEEP_CONN = 1;
    private String _hostAddress;
    private InetAddress _hostAddr;
    private int _hostPort;
    private Socket _socket;
    protected QDate _calendar = new QDate();
    private Application _app;
    private SocketStream _socketStream;
    private int _maxKeepaliveCount;
    private int _keepaliveCount = this._maxKeepaliveCount = 250;

    public void setServerAddress(String hostAddress) throws ServletException {
        this._hostAddress = hostAddress;
        try {
            int p = hostAddress.indexOf(58);
            if (p > 0) {
                this._hostPort = new Integer(this._hostAddress.substring(p + 1));
                this._hostAddr = InetAddress.getByName(this._hostAddress.substring(0, p));
            }
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void init() throws ServletException {
        this._app = (Application)this.getServletContext();
        String serverAddress = this.getInitParameter("server-address");
        if (serverAddress != null) {
            this.setServerAddress(serverAddress);
        }
        if (this._hostAddress == null) {
            throw new ServletException("FastCGIServlet needs valid server-address");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        SocketStream socketStream;
        Socket socket;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        ServletOutputStream out = res.getOutputStream();
        FastCGIServlet fastCGIServlet = this;
        synchronized (fastCGIServlet) {
            socket = this._socket;
            this._socket = null;
            socketStream = this._socketStream;
            this._socketStream = null;
        }
        if (socket == null) {
            socket = new Socket(this._hostAddr, this._hostPort);
            this._keepaliveCount = this._maxKeepaliveCount;
        }
        if (socketStream == null) {
            socketStream = new SocketStream(socket);
        }
        WriteStream ws = new WriteStream(socketStream);
        ws.setDisableClose(true);
        ReadStream rs = new ReadStream(socketStream, ws);
        rs.setDisableClose(true);
        boolean isOkay = false;
        try {
            this.handleRequest(req, res, rs, ws, out);
            isOkay = true;
            FastCGIServlet fastCGIServlet2 = this;
            synchronized (fastCGIServlet2) {
                if (this._socket == null) {
                    this._socket = socket;
                    socket = null;
                    this._socketStream = socketStream;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            if (socket != null) {
                socket.close();
            }
        }
        finally {
            ws.close();
            rs.close();
        }
    }

    private void handleRequest(HttpServletRequest req, HttpServletResponse res, ReadStream rs, WriteStream ws, OutputStream out) throws ServletException, IOException {
        FastCGIInputStream is;
        int ch;
        int sublen;
        this.writeHeader(ws, 1, 8);
        int role = 1;
        ws.write(role >> 8);
        ws.write(role);
        ws.write(this._keepaliveCount >= 0 ? 1 : 0);
        for (int i = 0; i < 5; ++i) {
            ws.write(0);
        }
        this.setEnvironment(ws, req);
        ServletInputStream in = req.getInputStream();
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buf = tempBuf.getBuffer();
        int len = buf.length;
        this.writeHeader(ws, 4, 0);
        boolean hasStdin = false;
        while ((sublen = in.read(buf, 0, len)) > 0) {
            hasStdin = true;
            this.writeHeader(ws, 5, sublen);
            ws.write(buf, 0, sublen);
        }
        TempBuffer.free(tempBuf);
        if (hasStdin) {
            this.writeHeader(ws, 5, 0);
        }
        if ((ch = this.parseHeaders(res, is = new FastCGIInputStream(rs))) >= 0) {
            out.write(ch);
        }
        while ((ch = is.read()) >= 0) {
            out.write(ch);
        }
        if (--this._keepaliveCount <= 0 || is.isDead()) {
            Socket socket = this._socket;
            this._socket = null;
            if (socket != null) {
                socket.close();
            }
        }
    }

    private void setEnvironment(WriteStream ws, HttpServletRequest req) throws IOException {
        this.addHeader(ws, "REQUEST_URI", req.getRequestURI());
        this.addHeader(ws, "REQUEST_METHOD", req.getMethod());
        this.addHeader(ws, "SERVER_SOFTWARE", "Resin/" + Version.VERSION);
        this.addHeader(ws, "SERVER_NAME", req.getServerName());
        this.addHeader(ws, "SERVER_PORT", String.valueOf(req.getServerPort()));
        this.addHeader(ws, "REMOTE_ADDR", req.getRemoteAddr());
        this.addHeader(ws, "REMOTE_HOST", req.getRemoteAddr());
        if (req.getRemoteUser() != null) {
            this.addHeader(ws, "REMOTE_USER", req.getRemoteUser());
        } else {
            this.addHeader(ws, "REMOTE_USER", "");
        }
        if (req.getAuthType() != null) {
            this.addHeader(ws, "AUTH_TYPE", req.getAuthType());
        }
        this.addHeader(ws, "GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader(ws, "SERVER_PROTOCOL", req.getProtocol());
        if (req.getQueryString() != null) {
            this.addHeader(ws, "QUERY_STRING", req.getQueryString());
        } else {
            this.addHeader(ws, "QUERY_STRING", "");
        }
        String scriptPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        Path appDir = this._app.getAppDir();
        String realPath = this._app.getRealPath(scriptPath);
        if (!appDir.lookup(realPath).isFile() && pathInfo != null) {
            scriptPath = scriptPath + pathInfo;
        }
        log.finer("FCGI file: " + this._app.getRealPath(scriptPath));
        this.addHeader(ws, "PATH_INFO", req.getContextPath() + scriptPath);
        this.addHeader(ws, "PATH_TRANSLATED", this._app.getRealPath(scriptPath));
        int contentLength = req.getContentLength();
        if (contentLength < 0) {
            this.addHeader(ws, "CONTENT_LENGTH", "0");
        } else {
            this.addHeader(ws, "CONTENT_LENGTH", String.valueOf(contentLength));
        }
        this.addHeader(ws, "DOCUMENT_ROOT", this._app.getContext("/").getRealPath("/"));
        CharBuffer cb = new CharBuffer();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = req.getHeader(key);
            if (key.equalsIgnoreCase("content-length")) {
                this.addHeader(ws, "CONTENT_LENGTH", value);
                continue;
            }
            if (key.equalsIgnoreCase("content-type")) {
                this.addHeader(ws, "CONTENT_TYPE", value);
                continue;
            }
            if (key.equalsIgnoreCase("if-modified-since") || key.equalsIgnoreCase("if-none-match") || key.equalsIgnoreCase("authorization") || key.equalsIgnoreCase("proxy-authorization")) continue;
            this.addHeader(ws, this.convertHeader(cb, key), value);
        }
    }

    private CharBuffer convertHeader(CharBuffer cb, String key) {
        cb.clear();
        cb.append("HTTP_");
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == '-') {
                cb.append('_');
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                cb.append((char)(ch + 65 - 97));
                continue;
            }
            cb.append(ch);
        }
        return cb;
    }

    private int parseHeaders(HttpServletResponse res, InputStream is) throws IOException {
        CharBuffer key = CharBuffer.allocate();
        CharBuffer value = CharBuffer.allocate();
        int ch = is.read();
        if (ch < 0) {
            log.fine("Can't contact FastCGI");
            res.sendError(404);
            return -1;
        }
        while (ch >= 0) {
            key.clear();
            value.clear();
            while (ch >= 0 && ch != 32 && ch != 13 && ch != 10 && ch != 58) {
                key.append((char)ch);
                ch = is.read();
            }
            while (ch >= 0 && ch == 32 || ch == 58) {
                ch = is.read();
            }
            while (ch >= 0 && ch != 13 && ch != 10) {
                value.append((char)ch);
                ch = is.read();
            }
            if (ch == 13 && (ch = is.read()) == 10) {
                ch = is.read();
            }
            if (key.length() == 0) {
                return ch;
            }
            res.addHeader(key.toString(), value.toString());
        }
        return ch;
    }

    private void addHeader(WriteStream ws, String key, String value) throws IOException {
        int keyLen = key.length();
        int valLen = value.length();
        int len = keyLen + valLen;
        len = keyLen < 128 ? ++len : (len += 4);
        len = valLen < 128 ? ++len : (len += 4);
        this.writeHeader(ws, 4, len);
        if (keyLen < 128) {
            ws.write(keyLen);
        } else {
            ws.write(0x80 | keyLen >> 24);
            ws.write(keyLen >> 16);
            ws.write(keyLen >> 8);
            ws.write(keyLen);
        }
        if (valLen < 128) {
            ws.write(valLen);
        } else {
            ws.write(0x80 | valLen >> 24);
            ws.write(valLen >> 16);
            ws.write(valLen >> 8);
            ws.write(valLen);
        }
        ws.print(key);
        ws.print(value);
    }

    private void addHeader(WriteStream ws, CharBuffer key, String value) throws IOException {
        int keyLen = key.getLength();
        int valLen = value.length();
        int len = keyLen + valLen;
        len = keyLen < 128 ? ++len : (len += 4);
        len = valLen < 128 ? ++len : (len += 4);
        this.writeHeader(ws, 4, len);
        if (keyLen < 128) {
            ws.write(keyLen);
        } else {
            ws.write(0x80 | keyLen >> 24);
            ws.write(keyLen >> 16);
            ws.write(keyLen >> 8);
            ws.write(keyLen);
        }
        if (valLen < 128) {
            ws.write(valLen);
        } else {
            ws.write(0x80 | valLen >> 24);
            ws.write(valLen >> 16);
            ws.write(valLen >> 8);
            ws.write(valLen);
        }
        ws.print(key.getBuffer(), 0, keyLen);
        ws.print(value);
    }

    private void writeHeader(WriteStream ws, int type, int length) throws IOException {
        int id = 1;
        int pad = 0;
        ws.write(1);
        ws.write(type);
        ws.write(id >> 8);
        ws.write(id);
        ws.write(length >> 8);
        ws.write(length);
        ws.write(pad);
        ws.write(0);
    }

    static class FastCGIInputStream
    extends InputStream {
        private InputStream _is;
        private int _chunkLength;
        private int _padLength;
        private boolean _isDead;

        public FastCGIInputStream() {
        }

        public FastCGIInputStream(InputStream is) {
            this.init(is);
        }

        public void init(InputStream is) {
            this._is = is;
            this._chunkLength = 0;
            this._isDead = false;
        }

        public boolean isDead() {
            return this._isDead;
        }

        public int read() throws IOException {
            if (this._chunkLength > 0) {
                --this._chunkLength;
                return this._is.read();
            }
            if (!this.readNext()) {
                return -1;
            }
            --this._chunkLength;
            return this._is.read();
        }

        private boolean readNext() throws IOException {
            int version;
            if (this._is == null) {
                return false;
            }
            if (this._padLength > 0) {
                this._is.skip(this._padLength);
                this._padLength = 0;
            }
            while ((version = this._is.read()) >= 0) {
                int type = this._is.read();
                int id = (this._is.read() << 8) + this._is.read();
                int length = (this._is.read() << 8) + this._is.read();
                int padding = this._is.read();
                this._is.skip(1L);
                switch (type) {
                    case 3: {
                        int appStatus = (this._is.read() << 24) + (this._is.read() << 16) + (this._is.read() << 8) + this._is.read();
                        int pStatus = this._is.read();
                        if (appStatus != 0) {
                            this._isDead = true;
                        }
                        this._is.skip(3L);
                        this._is = null;
                        return false;
                    }
                    case 6: {
                        if (length == 0) break;
                        this._chunkLength = length;
                        this._padLength = padding;
                        return true;
                    }
                    case 7: {
                        byte[] buf = new byte[length];
                        this._is.read(buf, 0, length);
                        log.warning(new String(buf, 0, length));
                        break;
                    }
                    default: {
                        this._is.skip(length + padding);
                    }
                }
            }
            this._isDead = true;
            return false;
        }
    }
}

