/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpProxyServlet
extends GenericServlet {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/servlets/HttpProxyServlet"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/servlets/HttpProxyServlet"));
    private ArrayList<String> _hosts = new ArrayList();
    private Path[] _urlPaths;
    private int _roundRobin;

    public void addHost(String host) {
        this._hosts.add(host);
    }

    public void init() throws ServletException {
        if (this._hosts.size() == 0) {
            throw new ServletException(L.l("HttpProxyServlet needs at least one host."));
        }
        this._urlPaths = new Path[this._hosts.size()];
        for (int i = 0; i < this._hosts.size(); ++i) {
            String host = this._hosts.get(i);
            this._urlPaths[i] = host.startsWith("http") ? Vfs.lookup(host) : Vfs.lookup("http://" + host);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        PrintWriter out = res.getWriter();
        int startIndex = this._roundRobin;
        this._roundRobin = (this._roundRobin + 1) % this._urlPaths.length;
        for (int i = 0; i < this._urlPaths.length; ++i) {
            int index = (startIndex + i) % this._urlPaths.length;
            if (!this.handleRequest(req, res, this._urlPaths[index])) continue;
            return;
        }
        res.sendError(503);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRequest(HttpServletRequest req, HttpServletResponse res, Path path) throws ServletException, IOException {
        String uri = req.isRequestedSessionIdFromUrl() ? req.getRequestURI() + ";jsessionid=" + req.getRequestedSessionId() : req.getRequestURI();
        if (req.getQueryString() != null) {
            uri = uri + '?' + req.getQueryString();
        }
        path = path.lookup(uri);
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = req.getHeader(name);
            path.setAttribute(name, value);
        }
        ReadWritePair pair = path.openReadWrite();
        ReadStream rs = pair.getReadStream();
        WriteStream ws = pair.getWriteStream();
        ws.setAttribute("method", req.getMethod());
        try {
            ServletInputStream is = req.getInputStream();
            ws.writeStream(is);
            String status = (String)rs.getAttribute("status");
            ServletOutputStream os = res.getOutputStream();
            rs.writeToStream(os);
        }
        finally {
            ws.close();
            rs.close();
        }
        return true;
    }
}

