/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.ConfigException;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.Period;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.sql.DriverConfig;
import com.caucho.sql.ManagedFactoryImpl;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.TransactionManager;

public class DBPoolImpl
implements AlarmListener,
EnvironmentListener {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/DBPoolImpl"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/DBPoolImpl"));
    private static final String URL_PREFIX = "jdbc:caucho:";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    private static final long MAX_IDLE_TIME = 30000L;
    private String _name;
    private ArrayList<DriverConfig> _driverList = new ArrayList();
    private ArrayList<DriverConfig> _backupDriverList = new ArrayList();
    private ManagedFactoryImpl _mcf;
    private String _user;
    private String _password;
    private int _maxConnections = 20;
    private long _maxIdleTime = 30000L;
    private long _maxActiveTime = 21600000L;
    private long _maxPoolTime = 86400000L;
    private long _connectionWaitTime = 600000L;
    private int _connectionWaitCount = (int)(this._connectionWaitTime / 1000L);
    private int _maxOverflowConnections = 0;
    private boolean _isStarted;
    private boolean _isClosed;
    private boolean _forbidClose;
    private String _pingTable;
    private String _pingQuery;
    private boolean _isPing;
    private long _pingInterval;
    private boolean _isTransactional = false;
    private TransactionManager _tm;
    private long _transactionTimeout = 0L;
    private boolean _isSpy;
    private int _spyId;
    private int _maxCloseStatements = 256;
    private int _preparedStatementCacheSize = 0;
    private int _idCount;
    private Alarm _alarm;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public DriverConfig createDriver() {
        DriverConfig driver = new DriverConfig(this);
        this._driverList.add(driver);
        return driver;
    }

    public DriverConfig createBackupDriver() {
        DriverConfig driver = new DriverConfig(this);
        this._backupDriverList.add(driver);
        return driver;
    }

    public void setInitParam(InitParam init) {
        DriverConfig driver = this._driverList.get(0);
        HashMap<String, String> params = init.getParameters();
        Iterator<String> iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            driver.setInitParam(key, params.get(key));
        }
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this._maxConnections = maxConnections;
    }

    public int getTotalConnections() {
        return 0;
    }

    public void setConnectionWaitTime(Period waitTime) {
        long period;
        this._connectionWaitTime = period = waitTime.getPeriod();
        if (period < 0L) {
            this._connectionWaitCount = 3600;
        } else {
            this._connectionWaitCount = (int)((period + 999L) / 1000L);
            if (this._connectionWaitCount <= 0) {
                this._connectionWaitCount = 1;
            }
        }
    }

    public long getConnectionWaitTime() {
        return this._connectionWaitTime;
    }

    public void setMaxOverflowConnections(int maxOverflowConnections) {
        this._maxOverflowConnections = maxOverflowConnections;
    }

    public int getMaxOverflowConnections() {
        return this._maxOverflowConnections;
    }

    public void setTransactionTimeout(Period period) {
        this._transactionTimeout = period.getPeriod();
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public void setMaxCloseStatements(int max) {
        this._maxCloseStatements = max;
    }

    public int getMaxCloseStatements() {
        return this._maxCloseStatements;
    }

    public int getPreparedStatementCacheSize() {
        return this._preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int size) {
        this._preparedStatementCacheSize = size;
    }

    public long getMaxIdleTime() {
        if (this._maxIdleTime > 0x3FFFFFFFFFFFFFFFL) {
            return -1L;
        }
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(Period idleTime) {
        long period = idleTime.getPeriod();
        this._maxIdleTime = period < 0L ? 0x3FFFFFFFFFFFFFFFL : (period < 1000L ? 1000L : period);
    }

    public long getMaxPoolTime() {
        if (this._maxPoolTime > 0x3FFFFFFFFFFFFFFFL) {
            return -1L;
        }
        return this._maxPoolTime;
    }

    public void setMaxPoolTime(Period maxPoolTime) {
        long period = maxPoolTime.getPeriod();
        this._maxPoolTime = period < 0L ? 0x3FFFFFFFFFFFFFFFL : (period == 0L ? 1000L : period);
    }

    public long getMaxActiveTime() {
        if (this._maxActiveTime > 0x3FFFFFFFFFFFFFFFL) {
            return -1L;
        }
        return this._maxActiveTime;
    }

    public void setMaxActiveTime(Period maxActiveTime) {
        long period = maxActiveTime.getPeriod();
        this._maxActiveTime = period < 0L ? 0x3FFFFFFFFFFFFFFFL : (period == 0L ? 1000L : period);
    }

    public String getPingTable() {
        return this._pingTable;
    }

    public void setPingTable(String pingTable) {
        this._pingTable = pingTable;
        this._pingQuery = pingTable != null ? "select 1 from " + pingTable + " where 1=0" : null;
    }

    public String getPingQuery() {
        return this._pingQuery;
    }

    public boolean getPingOnReuse() {
        return this._isPing;
    }

    public void setPingOnReuse(boolean pingOnReuse) {
        this._isPing = pingOnReuse;
    }

    public boolean getPingOnIdle() {
        return this._isPing;
    }

    public void setPingOnIdle(boolean pingOnIdle) {
        this._isPing = pingOnIdle;
    }

    public void setPing(boolean ping) {
        this._isPing = ping;
    }

    public boolean isPing() {
        return this._isPing;
    }

    public void setPingInterval(Period interval) {
        this._pingInterval = interval.getPeriod();
        if (this._pingInterval < 0L) {
            this._pingInterval = 0x3FFFFFFFFFFFFFFFL;
        } else if (this._pingInterval < 1000L) {
            this._pingInterval = 1000L;
        }
    }

    public long getPingInterval() {
        return this._pingInterval;
    }

    public void setTransactionManager(TransactionManager tm) {
        this._tm = tm;
    }

    public TransactionManager getTransactionManager() {
        return this._tm;
    }

    public boolean isXA() {
        return this._isTransactional;
    }

    public void setXA(boolean isTransactional) {
        this._isTransactional = isTransactional;
    }

    public void setSpy(boolean isSpy) {
        this._isSpy = isSpy;
    }

    public boolean isSpy() {
        return this._isSpy;
    }

    public int newSpyId() {
        return this._spyId++;
    }

    public boolean isTransactional() {
        return this._isTransactional;
    }

    int createPoolId() {
        return this._idCount++;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void init() throws Exception {
        Environment.addEnvironmentListener(this);
        try {
            Object obj;
            if (this._tm == null && (obj = new InitialContext().lookup("java:comp/TransactionManager")) instanceof TransactionManager) {
                this._tm = (TransactionManager)obj;
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (this._isTransactional && this._tm == null) {
            throw new ConfigException(L.l("Can't find TransactionManager in java:comp/TransactionManager for transaction-enabled DBPool."));
        }
        for (int i = 0; i < this._driverList.size(); ++i) {
            DriverConfig driver = this._driverList.get(i);
            if (driver.getUser() == null) {
                driver.setUser(this._user);
            }
            if (driver.getPassword() == null) {
                driver.setPassword(this._password);
            }
            driver.initDriver();
            driver.initDataSource(this._isTransactional, this._isSpy);
            if (driver.getXADataSource() != null) continue;
            this._isTransactional = false;
        }
        DriverConfig[] drivers = new DriverConfig[this._driverList.size()];
        this._driverList.toArray(drivers);
        for (int i = 0; i < this._backupDriverList.size(); ++i) {
            DriverConfig driver = this._backupDriverList.get(i);
            if (driver.getUser() == null) {
                driver.setUser(this._user);
            }
            if (driver.getPassword() == null) {
                driver.setPassword(this._password);
            }
            driver.initDriver();
            driver.initDataSource(this._isTransactional, this._isSpy);
            if (driver.getXADataSource() != null) continue;
            this._isTransactional = false;
        }
        DriverConfig[] backupDrivers = new DriverConfig[this._backupDriverList.size()];
        this._backupDriverList.toArray(backupDrivers);
        this._mcf = new ManagedFactoryImpl(this, drivers, backupDrivers);
        if (this._name != null) {
            String name = this._name;
            if (!name.startsWith("java:")) {
                name = "java:comp/env/" + name;
            }
            if (drivers[0].getURL() != null) {
                log.config("database " + name + " starting (URL:" + drivers[0].getURL() + ")");
            } else {
                log.config("database " + name + " starting");
            }
        }
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        return this._mcf;
    }

    synchronized void initDataSource() throws SQLException {
        if (this._isStarted) {
            return;
        }
        this._isStarted = true;
        for (int i = 0; i < this._driverList.size(); ++i) {
            DriverConfig driver = this._driverList.get(i);
            driver.initDataSource(this._isTransactional, this._isSpy);
        }
        try {
            Object obj;
            if (this._isTransactional && this._tm == null && (obj = new InitialContext().lookup("java:comp/TransactionManager")) instanceof TransactionManager) {
                this._tm = (TransactionManager)obj;
            }
        }
        catch (NamingException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    public void handleAlarm(Alarm alarm) {
        if (this._isClosed) {
            return;
        }
    }

    public void environmentStart(EnvironmentClassLoader loader) {
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        this.forceClose();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void close() {
        if (this._forbidClose) {
            throw new IllegalStateException("illegal to call close() for this DBPool");
        }
        this.forceClose();
    }

    public void forceClose() {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("closing pool " + this.getName());
        }
    }

    public String toString() {
        return "DBPoolImpl[" + this._name + "]";
    }
}

