/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.log.Log;
import com.caucho.sql.Credential;
import com.caucho.sql.ManagedFactoryImpl;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.sql.DataSource;

public class DataSourceImpl
implements DataSource {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/DataSourceImpl"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/DataSourceImpl"));
    private ManagedFactoryImpl _managedFactory;
    private ConnectionManager _connManager;

    DataSourceImpl(ManagedFactoryImpl factory, ConnectionManager cm) {
        this._managedFactory = factory;
        this._connManager = cm;
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this._connManager.allocateConnection(this._managedFactory, null);
        }
        catch (ResourceException e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof SQLException)) continue;
                throw (SQLException)cause;
            }
            throw new SQLExceptionWrapper(e);
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        try {
            Credential credential = null;
            if (username != null && password != null) {
                credential = new Credential(username, password);
            }
            return (Connection)this._connManager.allocateConnection(this._managedFactory, credential);
        }
        catch (ResourceException e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof SQLException)) continue;
                throw (SQLException)cause;
            }
            throw new SQLExceptionWrapper(e);
        }
    }

    public int getLoginTimeout() {
        return 0;
    }

    public void setLoginTimeout(int seconds) {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void setLogWriter(PrintWriter out) {
    }

    boolean isClosed() {
        return false;
    }
}

