/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.log.Log;
import com.caucho.sql.ManagedConnectionImpl;
import com.caucho.sql.PreparedStatementKey;
import com.caucho.sql.UserConnection;
import com.caucho.sql.UserPreparedStatement;
import com.caucho.util.CacheListener;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.sql.PreparedStatement;
import java.util.logging.Level;
import java.util.logging.Logger;

class PreparedStatementCacheItem
implements CacheListener {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/PreparedStatementCacheItem"));
    private PreparedStatementKey _key;
    private SoftReference<PreparedStatement> _pStmtRef;
    private ManagedConnectionImpl _mConn;
    private boolean _isActive;
    private boolean _isRemoved;

    PreparedStatementCacheItem(PreparedStatementKey key, PreparedStatement pStmt, ManagedConnectionImpl mConn) {
        if (pStmt == null) {
            throw new NullPointerException();
        }
        this._key = key;
        this._pStmtRef = new SoftReference<PreparedStatement>(pStmt);
        this._mConn = mConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserPreparedStatement toActive(UserConnection conn) {
        SoftReference<PreparedStatement> ref = this._pStmtRef;
        if (ref == null) {
            return null;
        }
        PreparedStatement pStmt = ref.get();
        if (pStmt == null) {
            this._mConn.remove(this._key);
            return null;
        }
        PreparedStatementCacheItem preparedStatementCacheItem = this;
        synchronized (preparedStatementCacheItem) {
            if (this._isActive) {
                return null;
            }
            this._isActive = true;
        }
        return new UserPreparedStatement(conn, pStmt, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toIdle() {
        boolean doClose = false;
        PreparedStatementCacheItem preparedStatementCacheItem = this;
        synchronized (preparedStatementCacheItem) {
            if (this._isRemoved) {
                this._isRemoved = true;
                doClose = this._isActive;
            }
            this._isActive = false;
        }
        if (doClose) {
            try {
                PreparedStatement pStmt = this._pStmtRef.get();
                this._pStmtRef = null;
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    boolean isRemoved() {
        return this._isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent() {
        boolean doClose = false;
        PreparedStatementCacheItem preparedStatementCacheItem = this;
        synchronized (preparedStatementCacheItem) {
            if (!this._isRemoved) {
                this._isRemoved = true;
                doClose = !this._isActive;
            }
        }
        if (doClose) {
            try {
                PreparedStatement pStmt = this._pStmtRef.get();
                this._pStmtRef = null;
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    void destroy() {
        PreparedStatement pStmt;
        this._isRemoved = true;
        SoftReference<PreparedStatement> ref = this._pStmtRef;
        this._pStmtRef = null;
        if (ref != null && (pStmt = ref.get()) != null) {
            try {
                pStmt.close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }
}

