/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.Version;
import com.caucho.java.WorkDir;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.CpuUsage;
import com.caucho.util.Crc64;
import com.caucho.util.Registry;
import com.caucho.vfs.CaseInsensitive;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CauchoSystem {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/util/CauchoSystem"));
    static char separatorChar = File.separatorChar;
    static char pathSeparatorChar = File.pathSeparatorChar;
    static String localHost;
    static String _userDir;
    static String userName;
    static Path _resinHome;
    static Path _serverRoot;
    static boolean _isTesting;
    static boolean _hasJni;
    private static int isUnix;
    private static String newline;
    private static long _version;
    private static String _user;
    private static String _group;
    private static String _classPath;
    static CpuUsage cpuUsage;

    private static native int setUserNative(String var0, String var1) throws IOException;

    private CauchoSystem() {
    }

    public static boolean isTesting() {
        return _isTesting;
    }

    public static void setIsTesting(boolean testing) {
        _isTesting = testing;
    }

    public static void setResinHome(Path path) {
        _resinHome = path;
    }

    public static Path getResinHome() {
        int pathSep;
        if (_resinHome != null) {
            return _resinHome;
        }
        String path = System.getProperty("resin.home");
        if (path != null) {
            _resinHome = Vfs.lookupNative(path);
            return _resinHome;
        }
        String classpath = System.getProperty("java.class.path");
        int head = 0;
        char sep = CauchoSystem.getFileSeparatorChar();
        int n = pathSep = sep == '/' ? 58 : 59;
        while (path == null) {
            int p = classpath.indexOf(pathSep, head);
            String subpath = p < 0 ? classpath.substring(head) : classpath.substring(head, p);
            if (subpath.endsWith(sep + "lib" + sep + "resin.jar") || subpath.equals("lib" + sep + "resin.jar")) {
                path = subpath.substring(0, subpath.length() - ("lib" + sep + "resin.jar").length());
            } else if (subpath.endsWith(sep + "classes") || subpath.equals("classes")) {
                Path resinPath = Vfs.lookupNative(subpath);
                if ((resinPath = resinPath.lookup("com/caucho/util/CauchoSystem.class")).exists()) {
                    path = subpath.substring(0, subpath.length() - "classes".length());
                }
            }
            if (p < 0) break;
            head = p + 1;
        }
        if (path != null) {
            _resinHome = Vfs.lookupNative(path);
        }
        if (_resinHome != null && _resinHome.isDirectory()) {
            return _resinHome;
        }
        return Vfs.lookup();
    }

    public static Path getServerRoot() {
        if (_serverRoot != null) {
            return _serverRoot;
        }
        String path = System.getProperty("resin.home");
        if (path != null) {
            _serverRoot = Vfs.lookupNative(path);
            return _serverRoot;
        }
        _serverRoot = CauchoSystem.getResinHome();
        return _serverRoot;
    }

    public static long getVersionId() {
        if (_version == 0L) {
            _version = Crc64.generate(Version.FULL_VERSION);
        }
        return _version;
    }

    public static String getResinConfig() {
        return CauchoSystem.getResinHome() + "/conf/resin.conf";
    }

    public static Path getWorkPath() {
        Path workPath = WorkDir.getLocalWorkDir();
        if (workPath != null) {
            return workPath;
        }
        String workDir = CauchoSystem.isWindows() ? "file:/c:/temp/caucho" : "file:/tmp/caucho";
        Path path = workDir.charAt(0) == '/' ? Vfs.lookupNative(workDir) : CauchoSystem.getResinHome().lookupNative(workDir);
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static String getUserDir() {
        if (_userDir == null) {
            _userDir = System.getProperty("user.dir");
        }
        return _userDir;
    }

    public static char getFileSeparatorChar() {
        return separatorChar;
    }

    public static char getPathSeparatorChar() {
        return pathSeparatorChar;
    }

    public static String getNewlineString() {
        if (newline == null && (newline = System.getProperty("line.separator")) == null) {
            newline = "\n";
        }
        return newline;
    }

    public static boolean isWindows() {
        return separatorChar == '\\';
    }

    public static boolean isCaseInsensitive() {
        return CaseInsensitive.isCaseInsensitive();
    }

    public static boolean isUnix() {
        if (isUnix >= 0) {
            return isUnix == 1;
        }
        isUnix = 0;
        if (separatorChar == '/' && Vfs.lookup("/bin/sh").canRead()) {
            isUnix = 1;
        }
        return isUnix == 1;
    }

    public static void setWindowsTest(boolean windows) {
        _isTesting = true;
        separatorChar = windows ? (char)92 : File.separatorChar;
    }

    public static String getLocalHost() {
        if (localHost != null) {
            return localHost;
        }
        localHost = Registry.getString("/caucho.com/local.host", null);
        if (localHost != null) {
            return localHost;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            localHost = addr.getHostName();
        }
        catch (Exception e) {
            localHost = "127.0.0.1";
        }
        return localHost;
    }

    public static String getUserName() {
        if (userName != null) {
            return userName;
        }
        userName = Registry.getString("/caucho.com/user.name", null);
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        return userName;
    }

    public static CpuUsage getCpuUsage() {
        return CpuUsage.create();
    }

    public static Class loadClass(String name) throws ClassNotFoundException {
        return CauchoSystem.loadClass(name, false, null);
    }

    public static Class loadClass(String name, boolean init, ClassLoader loader) throws ClassNotFoundException {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null || loader.equals(ClassLiteral.getClass((String)"com/caucho/util/CauchoSystem"))) {
            return Class.forName(name);
        }
        return Class.forName(name, init, loader);
    }

    public static String getClassPath() {
        if (_classPath != null) {
            return _classPath;
        }
        String cp = System.getProperty("java.class.path");
        String boot = System.getProperty("sun.boot.class.path");
        if (boot != null && !boot.equals("")) {
            cp = cp + File.pathSeparatorChar + boot;
        }
        Pattern pattern = Pattern.compile("" + File.pathSeparatorChar);
        String[] path = pattern.split(cp);
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < path.length; ++i) {
            Path subpath = Vfs.lookup(path[i]);
            if (!subpath.canRead() && !subpath.isDirectory()) continue;
            if (cb.length() > 0) {
                cb.append(File.pathSeparatorChar);
            }
            cb.append(path[i]);
        }
        _classPath = cb.toString();
        return _classPath;
    }

    public static int setUser(String user, String group) throws Exception {
        _user = user;
        _group = group;
        if (_hasJni && user != null) {
            return CauchoSystem.setUserNative(_user, _group);
        }
        return -1;
    }

    static {
        isUnix = -1;
        try {
            System.loadLibrary("resin");
            _hasJni = true;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }
}

