/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;

public class IntArray {
    private int[] _data = new int[16];
    private int _size = 0;

    public void clear() {
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public int[] getArray() {
        return this._data;
    }

    public void add(int i) {
        if (this._data.length <= this._size) {
            this.expand(this._size + 1);
        }
        this._data[this._size++] = i;
    }

    public void add(IntArray array) {
        if (this._data.length <= this._size) {
            this.expand(this._size + array._size);
        }
        for (int i = 0; i < array._size; ++i) {
            this._data[this._size++] = array._data[i];
        }
    }

    public void add(int i, int value) {
        this.expand(this._size + 1);
        System.arraycopy(this._data, i, this._data, i + 1, this._size - i);
        this._data[i] = value;
        ++this._size;
    }

    public int pop() {
        return this._data[--this._size];
    }

    public void setLength(int size) {
        this.expand(size);
        for (int i = this._size; i < size; ++i) {
            this._data[i] = 0;
        }
        this._size = size;
    }

    private void expand(int max) {
        while (this._data.length < max) {
            int[] next = new int[this._data.length * 2];
            for (int i = 0; i < this._data.length; ++i) {
                next[i] = this._data[i];
            }
            this._data = next;
        }
    }

    public int get(int i) {
        return this._data[i];
    }

    public int last() {
        return this._data[this._size - 1];
    }

    public void set(int i, int value) {
        if (this._size <= i) {
            throw new IndexOutOfBoundsException(i + " >= " + this._size);
        }
        this._data[i] = value;
    }

    public boolean contains(int test) {
        int[] data = this._data;
        for (int i = this._size - 1; i >= 0; --i) {
            if (data[i] != test) continue;
            return true;
        }
        return false;
    }

    public boolean isSubset(IntArray subset) {
        int[] subData = subset._data;
        for (int i = subset._size - 1; i >= 0; --i) {
            if (this.contains(subData[i])) continue;
            return false;
        }
        return true;
    }

    public void union(IntArray newArray) {
        for (int i = 0; i < newArray._size; ++i) {
            if (this.contains(newArray._data[i])) continue;
            this.add(newArray._data[i]);
        }
    }

    public int[] toArray() {
        int[] value = new int[this._size];
        System.arraycopy(this._data, 0, value, 0, this._size);
        return value;
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("[");
        for (int i = 0; i < this._size; ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(this._data[i]);
        }
        cb.append("]");
        return cb.close();
    }
}

