/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class TimeUnit {
    public static final TimeUnit NANOSECONDS = new TimeUnit(1L);
    public static final TimeUnit MICROSECONDS = new TimeUnit(1000L);
    public static final TimeUnit MILLISECONDS = new TimeUnit(1000000L);
    public static final TimeUnit SECONDS = new TimeUnit(1000000000L);
    private long _nanos;

    private TimeUnit(long nanos) {
        this._nanos = nanos;
    }

    public long convert(long duration, TimeUnit unit) {
        long sourceNanos = unit._nanos;
        if (sourceNanos <= this._nanos) {
            return duration * (this._nanos / sourceNanos);
        }
        return duration / (sourceNanos / this._nanos);
    }

    public long toMillis(long duration) {
        long targetNanos = 1000000L;
        if (this._nanos <= targetNanos) {
            return duration * (targetNanos / this._nanos);
        }
        return duration / (this._nanos / targetNanos);
    }
}

