/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.caucho.make.PersistentDependency;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Depend
implements PersistentDependency {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/vfs/Depend"));
    Path _source;
    long _lastModified;
    long _length;
    boolean _requireSource = true;
    boolean _isDigestModified;

    public Depend(Path source, long lastModified, long length) {
        this._source = source;
        this._lastModified = lastModified;
        this._length = length;
    }

    public Depend(Path source) {
        if (source instanceof JarPath) {
            source = ((JarPath)source).getContainer();
        }
        this._source = source;
        this._lastModified = source.getLastModified();
        this._length = source.getLength();
    }

    public Depend(Path source, String digest) {
        this(source, digest, true);
    }

    public Depend(Path source, String digest, boolean requireSource) {
        this._source = source;
        String newDigest = this.getDigest();
        this._requireSource = requireSource;
        if (!(newDigest.equals(digest) || !requireSource && newDigest.equals(""))) {
            if (newDigest.equals("")) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this._source.getNativePath() + " source is deleted.");
                }
                this._isDigestModified = true;
            } else {
                this._isDigestModified = true;
            }
        }
        this._lastModified = this._source.getLastModified();
        this._length = this._source.getLength();
    }

    public Path getPath() {
        return this._source;
    }

    public long getLastModified() {
        return this._source.getLastModified();
    }

    public long getLength() {
        return this._source.getLength();
    }

    public boolean getRequireSource() {
        return this._requireSource;
    }

    public void setRequireSource(boolean requireSource) {
        this._requireSource = requireSource;
    }

    public boolean isModified() {
        if (this._isDigestModified) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._source.getNativePath() + " digest is modified.");
            }
            return true;
        }
        long sourceLastModified = this._source.getLastModified();
        long sourceLength = this._source.getLength();
        if (!this._requireSource && sourceLastModified == 0L) {
            return false;
        }
        if (sourceLength != this._length) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._source.getNativePath() + " length is modified (" + this._length + " -> " + sourceLength + ")");
            }
            return true;
        }
        if (sourceLastModified != this._lastModified) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._source.getNativePath() + " time is modified.");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDigest() {
        String string;
        ReadStream is = null;
        try {
            String digestValue;
            int ch;
            if (!this._source.canRead()) {
                String string2 = "";
                return string2;
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            is = this._source.openRead();
            while ((ch = is.read()) >= 0) {
                digest.update((byte)ch);
            }
            byte[] digestBytes = new byte[256];
            int len = digest.digest(digestBytes, 0, digestBytes.length);
            string = digestValue = this.digestToBase64(digestBytes, len);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            String string3 = "";
            return string3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        return string;
    }

    private String digestToBase64(byte[] digest, int len) {
        CharBuffer cb = CharBuffer.allocate();
        Base64.encode(cb, digest, 0, len);
        return cb.close();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Depend)) {
            return false;
        }
        Depend depend = (Depend)obj;
        return this._source.equals(depend._source);
    }

    public String getJavaCreateString() {
        return "new com.caucho.vfs.Depend(com.caucho.vfs.Vfs.lookup(\"" + this._source.getPath() + "\"), \"" + this.getDigest() + "\")";
    }

    public String toString() {
        return "Depend[" + this._source + " " + this._lastModified + " " + (this._source.getLastModified() - this._lastModified) + "]";
    }
}

