/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.CauchoSystem;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.NotFoundPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergePath
extends FilesystemPath {
    private ArrayList<Path> _pathList;
    private Path _bestPath;

    public MergePath() {
        super(null, "/", "/");
        this._root = this;
        this._pathList = new ArrayList();
    }

    private MergePath(MergePath root, String userPath, Map<String, Object> attributes, String path) {
        super(root, userPath, path);
    }

    public void addMergePath(Path path) {
        if (!(path instanceof MergePath)) {
            ArrayList<Path> pathList;
            if (path.isDirectory()) {
                path = path.lookup("./");
            }
            if (!(pathList = ((MergePath)this._root)._pathList).contains(path)) {
                pathList.add(path);
            }
        } else {
            if (((MergePath)path)._root == this._root) {
                return;
            }
            MergePath mergePath = (MergePath)path;
            ArrayList<Path> subPaths = mergePath.getMergePaths();
            String pathName = new StringBuffer().append("./").append(mergePath._pathname).append("/").toString();
            for (int i = 0; i < subPaths.size(); ++i) {
                Path subPath = subPaths.get(i);
                this.addMergePath(subPath.lookup(pathName));
            }
        }
    }

    public void addClassPath() {
        this.addClassPath(Thread.currentThread().getContextClassLoader());
    }

    public void addClassPath(ClassLoader loader) {
        String classpath = null;
        classpath = loader instanceof DynamicClassLoader ? ((DynamicClassLoader)loader).getClassPath() : System.getProperty("java.class.path");
        this.addClassPath(classpath);
    }

    public void addClassPath(String classpath) {
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while (head < classpath.length()) {
            tail = classpath.indexOf(sep, head);
            String segment = null;
            if (tail < 0) {
                segment = classpath.substring(head);
                head = classpath.length();
            } else {
                segment = classpath.substring(head, tail);
                head = tail + 1;
            }
            if (segment.equals("")) continue;
            if (segment.endsWith(".jar") || segment.endsWith(".zip")) {
                this.addMergePath(JarPath.create(Vfs.lookup(segment)));
                continue;
            }
            this.addMergePath(Vfs.lookup(segment));
        }
    }

    public ArrayList<Path> getMergePaths() {
        return ((MergePath)this._root)._pathList;
    }

    @Override
    protected Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        ArrayList<Path> pathList = this.getMergePaths();
        if (!userPath.startsWith("/") || pathList.size() == 0) {
            return new MergePath((MergePath)this._root, userPath, attributes, path);
        }
        String bestPrefix = null;
        for (int i = 0; i < pathList.size(); ++i) {
            Path subPath = pathList.get(i);
            String prefix = subPath.getPath();
            if (!path.startsWith(prefix) || bestPrefix != null && bestPrefix.length() >= prefix.length()) continue;
            bestPrefix = prefix;
        }
        if (bestPrefix != null) {
            if (!(path = path.substring(bestPrefix.length())).startsWith("/")) {
                path = new StringBuffer().append("/").append(path).toString();
            }
            return new MergePath((MergePath)this._root, userPath, attributes, path);
        }
        return pathList.get(0).lookup(userPath, attributes);
    }

    @Override
    public String getScheme() {
        return this.getBestPath().getScheme();
    }

    @Override
    public String getFullPath() {
        Path path = this.getBestPath();
        return path.getFullPath();
    }

    @Override
    public String getURL() {
        Path path = this.getBestPath();
        return path.getURL();
    }

    @Override
    public String getRelativePath() {
        if (this._pathname.startsWith("/")) {
            return new StringBuffer().append(".").append(this._pathname).toString();
        }
        return this._pathname;
    }

    @Override
    public boolean exists() {
        return this.getBestPath().exists();
    }

    @Override
    public boolean isDirectory() {
        return this.getBestPath().isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.getBestPath().isFile();
    }

    @Override
    public long getLength() {
        return this.getBestPath().getLength();
    }

    @Override
    public long getLastModified() {
        return this.getBestPath().getLastModified();
    }

    @Override
    public boolean canRead() {
        return this.getBestPath().canRead();
    }

    @Override
    public boolean canWrite() {
        return this.getBestPath().canWrite();
    }

    @Override
    public ArrayList<Path> getResources(String pathName) {
        ArrayList<Path> list = new ArrayList<Path>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = new StringBuffer().append(".").append(pathname).toString();
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            path = path.lookup(pathname);
            ArrayList<Path> subResources = path.getResources(pathName);
            for (int j = 0; j < subResources.size(); ++j) {
                Path newPath = subResources.get(j);
                if (list.contains(newPath)) continue;
                list.add(newPath);
            }
        }
        return list;
    }

    @Override
    public ArrayList<Path> getResources() {
        ArrayList<Path> list = new ArrayList<Path>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = new StringBuffer().append(".").append(pathname).toString();
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            path = path.lookup(pathname);
            ArrayList<Path> subResources = path.getResources();
            for (int j = 0; j < subResources.size(); ++j) {
                Path newPath = subResources.get(j);
                if (list.contains(newPath)) continue;
                list.add(newPath);
            }
        }
        return list;
    }

    @Override
    public String[] list() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = new StringBuffer().append(".").append(pathname).toString();
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            if (!(path = path.lookup(pathname)).isDirectory()) continue;
            String[] subList = path.list();
            for (int j = 0; j < subList.length; ++j) {
                if (list.contains(subList[j])) continue;
                list.add(subList[j]);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean mkdir() throws IOException {
        return this.getBestPath().mkdir();
    }

    @Override
    public boolean mkdirs() throws IOException {
        return this.getBestPath().mkdirs();
    }

    @Override
    public boolean remove() throws IOException {
        return this.getBestPath().remove();
    }

    @Override
    public boolean renameTo(Path path) throws IOException {
        return this.getBestPath().renameTo(path);
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openReadImpl();
        stream.setPath(this);
        return stream;
    }

    @Override
    public StreamImpl openWriteImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openWriteImpl();
        stream.setPath(this);
        return stream;
    }

    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openReadWriteImpl();
        stream.setPath(this);
        return stream;
    }

    @Override
    public StreamImpl openAppendImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openAppendImpl();
        stream.setPath(this);
        return stream;
    }

    public Path getBestPath() {
        Path realPath;
        Path path;
        int i;
        if (this._bestPath != null) {
            return this._bestPath;
        }
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = new StringBuffer().append(".").append(pathname).toString();
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (i = 0; i < pathList.size(); ++i) {
            path = pathList.get(i);
            realPath = path.lookup(pathname);
            realPath.setUserPath(this._userPath);
            if (!realPath.exists()) continue;
            this._bestPath = realPath;
            return realPath;
        }
        pathname = this._pathname;
        for (i = 0; i < pathList.size(); ++i) {
            path = pathList.get(i);
            realPath = path.lookup(pathname);
            realPath.setUserPath(this._userPath);
            if (!realPath.exists()) continue;
            this._bestPath = realPath;
            return realPath;
        }
        return new NotFoundPath(this._userPath);
    }

    @Override
    public String toString() {
        return new StringBuffer().append("MergePath[").append(this._pathname).append("]").toString();
    }
}

