/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QServerSocketWrapper;
import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QJniServerSocket {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/vfs/QJniServerSocket"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/vfs/QJniServerSocket"));

    private QJniServerSocket() {
    }

    public static QServerSocket create(int port, int listenBacklog) throws IOException {
        return QJniServerSocket.create(null, port, listenBacklog);
    }

    public static QServerSocket create(InetAddress host, int port, int listenBacklog) throws IOException {
        try {
            QServerSocket ss = QJniServerSocket.createJNI(host, port, listenBacklog);
            if (ss != null) {
                return ss;
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        for (int i = 0; i < 10; ++i) {
            try {
                ServerSocket ss = new ServerSocket(port, listenBacklog, host);
                return new QServerSocketWrapper(ss);
            }
            catch (BindException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                continue;
            }
        }
        try {
            ServerSocket ss = new ServerSocket(port, listenBacklog, host);
            return new QServerSocketWrapper(ss);
        }
        catch (BindException e) {
            if (host != null) {
                throw new BindException(L.l("{0}\nCan't bind to {1}:{2}.\nCheck for another server listening to that port.", e.getMessage(), host, String.valueOf(port)));
            }
            throw new BindException(L.l("{0}\nCan't bind to *:{1}.\nCheck for another server listening to that port.", (Object)e.getMessage(), String.valueOf(port)));
        }
    }

    public static QServerSocket createJNI(InetAddress host, int port, int listenBacklog) throws IOException {
        try {
            Class<?> cl = Class.forName("com.caucho.vfs.JniServerSocketImpl");
            Method method = cl.getMethod("create", ClassLiteral.getClass((String)"java/lang/String"), Integer.TYPE, Integer.TYPE);
            String hostAddress = host != null ? host.getHostAddress() : "0.0.0.0";
            try {
                return (QServerSocket)method.invoke(null, hostAddress, Autobox.valueOf((int)port), Autobox.valueOf((int)listenBacklog));
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(L.l("JNI Socket support requires Resin Professional."));
        }
    }
}

