/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.vfs.ConstPath;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.HttpsPath;
import com.caucho.vfs.JarScheme;
import com.caucho.vfs.JndiPath;
import com.caucho.vfs.JniFilePath;
import com.caucho.vfs.LogPath;
import com.caucho.vfs.MailtoPath;
import com.caucho.vfs.MemoryScheme;
import com.caucho.vfs.NotFoundPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StderrStream;
import com.caucho.vfs.StdoutStream;
import com.caucho.vfs.TcpPath;
import com.caucho.vfs.TcpsPath;
import com.caucho.vfs.VfsStream;
import java.util.HashMap;

public class SchemeMap {
    private static final SchemeMap NULL_SCHEME_MAP = new SchemeMap(null);
    private static SchemeMap DEFAULT_SCHEME_MAP;
    private static EnvironmentLocal<SchemeMap> _localSchemeMap;
    private ClassLoader _loader;
    private HashMap<String, Path> _schemeMap;

    private SchemeMap() {
        this(Thread.currentThread().getContextClassLoader());
    }

    private SchemeMap(ClassLoader loader) {
        while (loader != null && !(loader instanceof EnvironmentClassLoader)) {
            loader = loader.getParent();
        }
        this._loader = loader;
        this._schemeMap = new HashMap();
    }

    static SchemeMap getNullSchemeMap() {
        return NULL_SCHEME_MAP;
    }

    public static SchemeMap getLocalSchemeMap() {
        return _localSchemeMap.get();
    }

    public static Path getScheme(String scheme) {
        SchemeMap schemeMap = _localSchemeMap.get();
        Path root = schemeMap.get(scheme);
        if (root != null) {
            return root;
        }
        return new NotFoundPath(scheme + ":");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setScheme(String scheme, Path handler) {
        SchemeMap schemeMap;
        EnvironmentLocal<SchemeMap> environmentLocal = _localSchemeMap;
        synchronized (environmentLocal) {
            schemeMap = _localSchemeMap.getLevel();
            if (schemeMap == null) {
                schemeMap = new SchemeMap();
                _localSchemeMap.set(schemeMap);
            }
        }
        schemeMap.put(scheme, handler);
    }

    public static Path removeScheme(String scheme) {
        SchemeMap schemeMap = _localSchemeMap.getLevel();
        if (schemeMap != null) {
            return schemeMap.remove(scheme);
        }
        return null;
    }

    public Path get(String scheme) {
        Path path = this._schemeMap.get(scheme);
        if (path != null) {
            return path;
        }
        if (this._loader == null) {
            return new NotFoundPath(scheme + ":");
        }
        SchemeMap parent = _localSchemeMap.get(this._loader.getParent());
        if (parent != null) {
            return parent.get(scheme);
        }
        return new NotFoundPath(scheme + ":");
    }

    private Path put(String scheme, Path path) {
        return this._schemeMap.put(scheme, path);
    }

    private Path remove(String scheme) {
        return this._schemeMap.remove(scheme);
    }

    static {
        _localSchemeMap = new EnvironmentLocal();
        DEFAULT_SCHEME_MAP = new SchemeMap(null);
        FilesystemPath jniFilePath = JniFilePath.create();
        if (jniFilePath != null) {
            DEFAULT_SCHEME_MAP.put("file", jniFilePath);
        } else {
            DEFAULT_SCHEME_MAP.put("file", new FilePath(null));
        }
        DEFAULT_SCHEME_MAP.put("memory", new MemoryScheme());
        DEFAULT_SCHEME_MAP.put("jar", new JarScheme(null));
        DEFAULT_SCHEME_MAP.put("mailto", new MailtoPath(null, null, null, null));
        DEFAULT_SCHEME_MAP.put("http", new HttpPath("127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("https", new HttpsPath("127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("tcp", new TcpPath(null, null, null, "127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("tcps", new TcpsPath(null, null, null, "127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("log", new LogPath(null, "/", null, "/"));
        StdoutStream stdout = StdoutStream.create();
        StderrStream stderr = StderrStream.create();
        DEFAULT_SCHEME_MAP.put("stdout", stdout.getPath());
        DEFAULT_SCHEME_MAP.put("stderr", stderr.getPath());
        VfsStream nullStream = new VfsStream(null, null);
        DEFAULT_SCHEME_MAP.put("null", new ConstPath(null, nullStream));
        DEFAULT_SCHEME_MAP.put("jndi", new JndiPath());
        _localSchemeMap.setGlobal(DEFAULT_SCHEME_MAP);
    }
}

