/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;

public class TempReadStream
extends StreamImpl {
    private TempBuffer _cursor;
    private int _offset;
    private Path _backingDir;
    private Path _backingFile;
    private ReadStream _backingStream;
    private boolean _freeWhenDone = true;

    public TempReadStream(TempBuffer cursor) {
        this.init(cursor, null);
    }

    public TempReadStream() {
    }

    TempReadStream(TempBuffer cursor, Path path) {
        this.init(cursor, path);
    }

    public void init(TempBuffer cursor) {
        this.init(cursor, null);
    }

    public void init(TempBuffer cursor, Path path) {
        this.setPath(path);
        this._cursor = cursor;
        this._offset = 0;
        this._freeWhenDone = true;
        this._backingFile = null;
        this._backingStream = null;
    }

    public void setFreeWhenDone(boolean free) {
        this._freeWhenDone = free;
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this._cursor == null) {
            return -1;
        }
        if (this._cursor._length - this._offset < length) {
            length = this._cursor._length - this._offset;
        }
        System.arraycopy(this._cursor._buf, this._offset, buf, offset, length);
        if (this._offset + length >= this._cursor._length) {
            TempBuffer next = this._cursor._next;
            if (this._freeWhenDone) {
                TempBuffer.free(this._cursor);
            }
            this._cursor = next;
            this._offset = 0;
        } else {
            this._offset += length;
        }
        return length > 0 ? length : -1;
    }

    public int getAvailable() throws IOException {
        if (this._cursor != null) {
            return this._cursor._length - this._offset;
        }
        return 0;
    }

    public void close() throws IOException {
        if (this._freeWhenDone && this._cursor != null) {
            TempBuffer.freeAll(this._cursor);
        }
        this._cursor = null;
    }
}

