/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QDOMException;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class QAttributedNode
extends QNode {
    QAttr _firstAttribute;

    QAttributedNode() {
    }

    public NamedNodeMap getAttributes() {
        return new QAttributeMap(this);
    }

    public boolean hasAttributes() {
        return this._firstAttribute != null;
    }

    public Attr getFirstAttribute() {
        return this._firstAttribute;
    }

    public String getAttribute(String name) {
        QAbstractNode attr = this._firstAttribute;
        while (attr != null) {
            if (name.equals(attr.getNodeName())) {
                return ((QAbstractNode)attr).getNodeValue();
            }
            attr = attr._next;
        }
        return "";
    }

    public String getAttributeNS(String namespaceURI, String local) {
        QAbstractNode attr = this._firstAttribute;
        while (attr != null) {
            String attrURI = attr.getNamespaceURI();
            if (attr.getLocalName().equals(local) && (attrURI == namespaceURI || attrURI != null && attrURI.equals(namespaceURI))) {
                return attr.getNodeValue();
            }
            attr = attr._next;
        }
        return "";
    }

    public boolean hasAttribute(String name) {
        QAbstractNode attr = this._firstAttribute;
        while (attr != null) {
            if (attr.getNodeName().equals(name)) {
                return true;
            }
            attr = attr._next;
        }
        return false;
    }

    public boolean hasAttributeNS(String uri, String local) {
        QAbstractNode attr = this._firstAttribute;
        while (attr != null) {
            String attrURI = ((QAbstractNode)attr).getNamespaceURI();
            if (((QAbstractNode)attr).getLocalName().equals(local) && (attrURI == uri || attrURI != null && attrURI.equals(uri))) {
                return true;
            }
            attr = attr._next;
        }
        return false;
    }

    public Attr getAttributeNode(String name) {
        QAbstractNode attr = this._firstAttribute;
        while (attr != null) {
            if (attr.getNodeName().equals(name)) {
                return attr;
            }
            attr = attr._next;
        }
        return null;
    }

    public Attr getAttributeNodeNS(String uri, String local) {
        QAbstractNode attr = this._firstAttribute;
        while (attr != null) {
            String attrURI = ((QAbstractNode)attr).getNamespaceURI();
            if (((QAbstractNode)attr).getLocalName().equals(local) && (attrURI == uri || attrURI != null && attrURI.equals(uri))) {
                return attr;
            }
            attr = attr._next;
        }
        return null;
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (!this.isNameValid(name)) {
            throw new QDOMException(5, "illegal attribute `" + name + "'");
        }
        this.setAttributeNode(this._owner.createAttribute(name, value));
    }

    public void setAttributeNS(String uri, String local, String value) {
        Attr attr = this._owner.createAttributeNS(uri, local);
        attr.setNodeValue(value);
        this.setAttributeNodeNS(attr);
    }

    void setAttribute(QName name, String value) throws DOMException {
        this.setAttributeNode(this._owner.createAttribute(name, value));
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    public void setIdAttributeNode(Attr attr, boolean isId) throws DOMException {
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        QAttr qAttr = (QAttr)attr;
        if (qAttr._owner != this._owner) {
            throw new QDOMException(4, "attribute from wrong document");
        }
        if (qAttr._parent != null) {
            throw new QDOMException(10, "attribute `" + attr.getNodeName() + "' is in use");
        }
        qAttr._parent = this;
        QAttr old = this.unlink(attr.getNodeName());
        qAttr._next = this._firstAttribute;
        this._firstAttribute = qAttr;
        return old;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        QAttr qAttr = (QAttr)attr;
        if (qAttr._owner != this._owner) {
            throw new QDOMException(4, "attribute from wrong document");
        }
        if (qAttr._parent != null) {
            throw new QDOMException(10, "attribute `" + attr.getNodeName() + "' is in use");
        }
        QAttr old = this.unlink(qAttr.getNamespaceURI(), qAttr.getLocalName());
        qAttr._parent = this;
        qAttr._next = this._firstAttribute;
        this._firstAttribute = qAttr;
        return old;
    }

    public void removeAttribute(String name) {
        if (!this.isNameValid(name)) {
            throw new QDOMException(5, "illegal attribute `" + name + "'");
        }
        this.unlink(name);
    }

    public void removeAttributeNS(String uri, String name) {
        this.unlink(uri, name);
    }

    public Attr removeAttributeNode(Attr attr) {
        return this.unlink(attr.getNodeName());
    }

    public Attr removeAttributeNodeNS(Attr attr) {
        return this.unlink(attr.getNamespaceURI(), attr.getLocalName());
    }

    QAttr unlink(String name) {
        QAttr prev = null;
        QAttr ptr = this._firstAttribute;
        while (ptr != null && !ptr.getNodeName().equals(name)) {
            prev = ptr;
            ptr = (QAttr)ptr._next;
        }
        if (ptr == null) {
            return null;
        }
        if (prev == null) {
            this._firstAttribute = (QAttr)ptr._next;
        } else {
            prev._next = ptr._next;
        }
        ptr._next = null;
        return ptr;
    }

    public QAttr unlink(String uri, String local) {
        if (local == null || uri == null) {
            return null;
        }
        QAttr prev = null;
        QAttr ptr = this._firstAttribute;
        while (!(ptr == null || local.equals(ptr.getLocalName()) && uri.equals(ptr.getNamespaceURI()))) {
            prev = ptr;
            ptr = (QAttr)ptr._next;
        }
        if (ptr == null) {
            return null;
        }
        if (prev == null) {
            this._firstAttribute = (QAttr)ptr._next;
        } else {
            prev._next = ptr._next;
        }
        ptr._next = null;
        return ptr;
    }

    static class QAttributeMap
    implements NamedNodeMap {
        QAttributedNode _elt;
        int _i;
        QAttr _attr;

        QAttributeMap(QAttributedNode elt) {
            this._elt = elt;
        }

        public Node getNamedItem(String name) {
            return this._elt.getAttributeNode(name);
        }

        public Node getNamedItemNS(String uri, String localName) {
            return this._elt.getAttributeNodeNS(uri, localName);
        }

        public Node setNamedItem(Node arg) throws DOMException {
            return this._elt.setAttributeNode((Attr)arg);
        }

        public Node setNamedItemNS(Node arg) {
            return this._elt.setAttributeNodeNS((Attr)arg);
        }

        public Node removeNamedItem(String name) throws DOMException {
            return this._elt.unlink(name);
        }

        public Node removeNamedItemNS(String uri, String localName) {
            return this._elt.getAttributeNodeNS(uri, localName);
        }

        public Node item(int index) {
            QAbstractNode attr = this._elt._firstAttribute;
            while (index > 0 && attr != null) {
                attr = attr._next;
                --index;
            }
            return attr;
        }

        public int getLength() {
            int length = 0;
            QAbstractNode attr = this._elt._firstAttribute;
            while (attr != null) {
                ++length;
                attr = attr._next;
            }
            return length;
        }
    }
}

