/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import org.w3c.dom.Node;

public abstract class AbstractStringExpr
extends Expr {
    public abstract String evalString(Node var1, ExprEnvironment var2) throws XPathException;

    public boolean isString() {
        return true;
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        String string = this.evalString(node, env);
        return string != null && string.length() > 0;
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        return AbstractStringExpr.stringToNumber(this.evalString(node, env));
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        return this.evalString(node, env);
    }

    protected static String normalize(String string) {
        int i;
        CharBuffer result = new CharBuffer();
        int len = string.length();
        for (i = 0; i < len && XmlChar.isWhitespace(string.charAt(i)); ++i) {
        }
        boolean lastIsWhitespace = false;
        while (i < len) {
            if (XmlChar.isWhitespace(string.charAt(i))) {
                lastIsWhitespace = true;
            } else if (lastIsWhitespace) {
                result.append(' ');
                result.append(string.charAt(i));
                lastIsWhitespace = false;
            } else {
                result.append(string.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }
}

