/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.make.PersistentDependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xml.XMLWriter;
import com.caucho.xsl.CauchoStylesheet;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerImpl;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.URIResolver;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStylesheet
implements CauchoStylesheet,
Templates {
    private Path _path;
    private ArrayList<PersistentDependency> _depends = new ArrayList();
    private ArrayList<String> _cacheDepends = new ArrayList();
    private ArrayList _globalParameters;
    protected Properties _output = new Properties();
    protected AbstractStylesheet _stylesheet;
    protected String _errorPage;
    protected URIResolver _uriResolver;
    boolean _escapeEntities = true;

    public abstract void transform(Node var1, XMLWriter var2, TransformerImpl var3) throws Exception;

    public void init(Path path) throws Exception {
        this._path = path;
    }

    public void setURIResolver(URIResolver resolver) {
        this._uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    protected void copy(AbstractStylesheet stylesheet) {
        stylesheet._stylesheet = this;
        stylesheet._depends = (ArrayList)this._depends.clone();
        stylesheet._output = (Properties)this._output.clone();
        stylesheet._errorPage = this._errorPage;
        stylesheet._globalParameters = this._globalParameters;
        stylesheet._path = this._path;
        stylesheet._uriResolver = this._uriResolver;
    }

    public Object clone() {
        try {
            AbstractStylesheet instance = (AbstractStylesheet)this.getClass().newInstance();
            this.copy(instance);
            if (this._path != null) {
                instance.init(this._path);
            } else {
                instance.init(Vfs.lookup("anonymous.xsl"));
            }
            return instance;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Properties getOutputProperties() {
        return this._output;
    }

    public Path getPath() {
        return this._path;
    }

    public Object getProperty(String name) {
        if (name.equals("caucho.depends")) {
            return this._depends;
        }
        if (name.equals("caucho.cache.depends")) {
            return this._cacheDepends;
        }
        if (name.equals("caucho.path")) {
            return this._path;
        }
        if (name.equals("caucho.global.param")) {
            return this._globalParameters;
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        if (name.equals("caucho.global.param")) {
            this._globalParameters = (ArrayList)value;
        }
    }

    @Override
    public Transformer newTransformer() {
        return new TransformerImpl((StylesheetImpl)this.clone());
    }

    @Override
    public boolean isModified() {
        for (int i = 0; i < this._depends.size(); ++i) {
            PersistentDependency depend = this._depends.get(i);
            if (!depend.isModified()) continue;
            return true;
        }
        return false;
    }

    protected void addDepend(PersistentDependency depend) {
        if (!this._depends.contains(depend)) {
            this._depends.add(depend);
        }
    }

    public ArrayList<PersistentDependency> getDepends() {
        return this._depends;
    }

    protected void addCacheDepend(String path) {
        this._cacheDepends.add(path);
    }

    public ArrayList<String> getCacheDepends() {
        return this._cacheDepends;
    }
}

