/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TimerTask;

public class JobManager {
    private static Method _queueAbsolute;
    private static Method _queueRelative;
    private static Method _dequeue;
    private static Method _getCurrentTime;

    private JobManager() {
    }

    public static long getCurrentTime() {
        try {
            Long value = (Long)_getCurrentTime.invoke(null, null);
            if (value == null) {
                return 0L;
            }
            return value;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public static void queueAbsolute(TimerTask job, long time) {
        try {
            _queueAbsolute.invoke(null, job, new Long(time));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public static void queueRelative(TimerTask job, long time) {
        try {
            _queueRelative.invoke(null, job, new Long(time));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public static void dequeue(TimerTask job) {
        try {
            _dequeue.invoke(null, job);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    static {
        try {
            Class<?> jmx = Class.forName("com.caucho.jmx.Jmx");
            _queueAbsolute = jmx.getMethod("queueAbsolute", TimerTask.class, Long.TYPE);
            _queueRelative = jmx.getMethod("queueRelative", TimerTask.class, Long.TYPE);
            _dequeue = jmx.getMethod("dequeue", TimerTask.class);
            Class<?> alarm = Class.forName("com.caucho.util.Alarm");
            _getCurrentTime = alarm.getMethod("getCurrentTime", new Class[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

