/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx.query;

import com.caucho.jmx.query.AbstractValueExp;
import com.caucho.jmx.query.BooleanValueExp;
import com.caucho.jmx.query.NumericValueExp;
import javax.management.BadBinaryOpValueExpException;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public abstract class AbstractExp
extends QueryEval
implements QueryExp {
    protected boolean eq(ValueExp v1, ValueExp v2) throws BadBinaryOpValueExpException {
        if (v1 instanceof StringValueExp && v2 instanceof StringValueExp) {
            return AbstractExp.toString(v1).equals(AbstractExp.toString(v2));
        }
        if (v1 instanceof BooleanValueExp && v2 instanceof BooleanValueExp) {
            return AbstractExp.toBoolean(v1) == AbstractExp.toBoolean(v2);
        }
        if (v1 instanceof NumericValueExp && v2 instanceof NumericValueExp) {
            return AbstractExp.toDouble(v1) == AbstractExp.toDouble(v2);
        }
        throw new BadBinaryOpValueExpException(v1);
    }

    protected boolean lt(ValueExp v1, ValueExp v2) throws BadBinaryOpValueExpException {
        if (v1 instanceof StringValueExp && v2 instanceof StringValueExp) {
            return AbstractExp.toString(v1).compareTo(AbstractExp.toString(v2)) < 0;
        }
        if (v1 instanceof BooleanValueExp && v2 instanceof BooleanValueExp) {
            boolean b1 = AbstractExp.toBoolean(v1);
            boolean b2 = AbstractExp.toBoolean(v2);
            return !b1 && b2;
        }
        if (v1 instanceof NumericValueExp && v2 instanceof NumericValueExp) {
            return AbstractExp.toDouble(v1) < AbstractExp.toDouble(v2);
        }
        throw new BadBinaryOpValueExpException(v1);
    }

    public static String toString(ValueExp exp) throws BadBinaryOpValueExpException {
        if (exp instanceof StringValueExp) {
            return ((StringValueExp)exp).getValue();
        }
        if (exp instanceof AbstractValueExp) {
            return ((AbstractValueExp)exp).getString();
        }
        throw new BadBinaryOpValueExpException(exp);
    }

    public static long toLong(ValueExp exp) throws BadBinaryOpValueExpException {
        if (exp instanceof StringValueExp) {
            return Long.parseLong(((StringValueExp)exp).getValue());
        }
        if (exp instanceof AbstractValueExp) {
            return ((AbstractValueExp)exp).getLong();
        }
        throw new BadBinaryOpValueExpException(exp);
    }

    public static boolean toBoolean(ValueExp exp) throws BadBinaryOpValueExpException {
        if (exp instanceof StringValueExp) {
            String value = ((StringValueExp)exp).getValue();
            return value != null && !value.equals("");
        }
        if (exp instanceof AbstractValueExp) {
            return ((AbstractValueExp)exp).getBoolean();
        }
        throw new BadBinaryOpValueExpException(exp);
    }

    public static double toDouble(ValueExp exp) throws BadBinaryOpValueExpException {
        if (exp instanceof StringValueExp) {
            return Double.parseDouble(((StringValueExp)exp).getValue());
        }
        if (exp instanceof AbstractValueExp) {
            return ((AbstractValueExp)exp).getDouble();
        }
        throw new BadBinaryOpValueExpException(exp);
    }
}

