/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.caucho.jmx.query.BooleanValueExp;
import com.caucho.jmx.query.DoubleValueExp;
import com.caucho.jmx.query.LongValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class AttributeValueExp
implements ValueExp {
    private String attr;
    private transient MBeanServer _server;

    public AttributeValueExp() {
    }

    public AttributeValueExp(String attr) {
        this.attr = attr;
    }

    protected String getAttributeName() {
        return this.attr;
    }

    public void setMBeanServer(MBeanServer server) {
        this._server = server;
    }

    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        MBeanServer server = this._server;
        if (server == null) {
            server = QueryEval.getMBeanServer();
        }
        if (server == null) {
            throw new InvalidApplicationException("Missing MBean server in evaluation.");
        }
        if (this.attr == null) {
            throw new InvalidApplicationException("Missing attribute in evaluation.");
        }
        try {
            Object value = server.getAttribute(name, this.attr);
            if (value == null) {
                return new StringValueExp();
            }
            if (value instanceof String) {
                return new StringValueExp((String)value);
            }
            if (value instanceof Double || value instanceof Float) {
                return new DoubleValueExp(((Number)value).doubleValue());
            }
            if (value instanceof Number) {
                return new LongValueExp(((Number)value).longValue());
            }
            if (value instanceof Boolean) {
                return BooleanValueExp.create((Boolean)value);
            }
            return new StringValueExp(value.toString());
        }
        catch (Exception e) {
            throw new JMRuntimeException(e);
        }
    }

    protected Object getAttribute(ObjectName name) {
        if (this._server == null) {
            return null;
        }
        try {
            return this._server.getAttribute(name, this.attr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "attributeValue(\"" + this.attr + "\")";
    }
}

