/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Method;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Cloneable {
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private MBeanParameterInfo[] signature;
    private String type;
    private int impact;

    public MBeanOperationInfo(String description, Method method) {
        super(method.getName(), description);
        this.type = method.getReturnType().getName();
        this.impact = 3;
        Class<?>[] param = method.getParameterTypes();
        this.signature = new MBeanParameterInfo[param.length];
        for (int i = 0; i < param.length; ++i) {
            this.signature[i] = new MBeanParameterInfo("a" + i, param[i].getName(), param[i].getName());
        }
    }

    public MBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact) {
        super(name, description);
        this.signature = signature;
        this.type = type;
        this.impact = impact;
    }

    public MBeanParameterInfo[] getSignature() {
        return this.signature;
    }

    public String getReturnType() {
        return this.type;
    }

    public int getImpact() {
        return this.impact;
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        MBeanOperationInfo info = (MBeanOperationInfo)o;
        if (!this.name.equals(info.name)) {
            return false;
        }
        if (this.signature.length != info.signature.length) {
            return false;
        }
        for (int i = this.signature.length - 1; i >= 0; --i) {
            if (this.signature[i].equals(info.signature[i])) continue;
            return false;
        }
        return true;
    }
}

