/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectName;

public class MBeanServerFactory {
    private static final Logger log = Logger.getLogger("javax.management.MBeanServerFactory");
    private static final String BUILDER_PROPERTY = "javax.management.builder.initial";
    private static final String DEFAULT_BUILDER = "com.caucho.jmx.MBeanServerBuilderImpl";
    private static ObjectName SERVER_DELEGATE_NAME;
    private static ArrayList _servers;
    private static String _builderClassName;
    private static MBeanServerBuilder _builder;

    public static MBeanServer createMBeanServer() throws SecurityException {
        return MBeanServerFactory.createMBeanServer(null);
    }

    public static MBeanServer createMBeanServer(String domain) throws SecurityException {
        if (domain == null) {
            domain = "DefaultDomain";
        }
        MBeanServer server = MBeanServerFactory.newMBeanServer(domain);
        _servers.add(server);
        return server;
    }

    public static ArrayList findMBeanServer(String agentId) {
        ArrayList servers = new ArrayList(_servers);
        if (agentId == null) {
            return servers;
        }
        for (int i = servers.size() - 1; i >= 0; --i) {
            MBeanServer server = (MBeanServer)servers.get(i);
            boolean isMatch = false;
            try {
                Object id = server.getAttribute(SERVER_DELEGATE_NAME, "MBeanServerId");
                isMatch = agentId.equals(id);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            if (isMatch) continue;
            servers.remove(i);
        }
        return servers;
    }

    public static MBeanServer newMBeanServer() throws SecurityException {
        return MBeanServerFactory.newMBeanServer(null);
    }

    public static MBeanServer newMBeanServer(String domain) throws SecurityException {
        if (domain == null) {
            domain = "DefaultDomain";
        }
        MBeanServerBuilder builder = MBeanServerFactory.getBuilder();
        MBeanServer outer = null;
        MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
        return builder.newMBeanServer(domain, outer, delegate);
    }

    public static void releaseMBeanServer(MBeanServer mbeanServer) {
        _servers.remove(mbeanServer);
    }

    private static synchronized MBeanServerBuilder getBuilder() {
        String className = System.getProperty(BUILDER_PROPERTY);
        if (className == null) {
            className = DEFAULT_BUILDER;
        }
        if (!className.equals(_builderClassName)) {
            try {
                Thread thread = Thread.currentThread();
                ClassLoader loader = thread.getContextClassLoader();
                Class<?> cl = Class.forName(className, false, loader);
                _builder = (MBeanServerBuilder)cl.newInstance();
                _builderClassName = className;
            }
            catch (Exception e) {
                throw new JMRuntimeException(e);
            }
        }
        return _builder;
    }

    static {
        _servers = new ArrayList();
        try {
            SERVER_DELEGATE_NAME = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

