/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MBeanServerInvocationHandler
implements InvocationHandler {
    private MBeanServerConnection _connection;
    private ObjectName _name;

    public MBeanServerInvocationHandler(MBeanServerConnection connection, ObjectName objectName) {
        this._connection = connection;
        this._name = objectName;
    }

    public static Object newProxyInstance(MBeanServerConnection connection, ObjectName objectName, Class interfaceClass, boolean notificationBroadcaster) {
        Class[] interfaces = notificationBroadcaster ? new Class[]{interfaceClass, NotificationEmitter.class} : new Class[]{interfaceClass};
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), interfaces, (InvocationHandler)new MBeanServerInvocationHandler(connection, objectName));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object value = args[0];
            if (value == null || !Proxy.isProxyClass(value.getClass())) {
                return Boolean.FALSE;
            }
            MBeanServerInvocationHandler handler = (MBeanServerInvocationHandler)Proxy.getInvocationHandler(value);
            return new Boolean(this._name.equals(handler._name));
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return new Integer(this._name.hashCode());
        }
        int len = methodName.length();
        if (params.length == 0 && methodName.startsWith("get") && len > 3) {
            String attrName = methodName.substring(3);
            return this._connection.getAttribute(this._name, attrName);
        }
        if (params.length == 1 && method.getReturnType().equals(Void.TYPE) && methodName.startsWith("set") && len > 3) {
            String attrName = methodName.substring(3);
            Attribute attr = new Attribute(attrName, args[0]);
            this._connection.setAttribute(this._name, attr);
            return null;
        }
        if (methodName.equals("addNotificationListener")) {
            if (args.length == 3) {
                if (args[0] instanceof NotificationListener) {
                    this._connection.addNotificationListener(this._name, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                    return null;
                }
                if (args[0] instanceof ObjectName) {
                    this._connection.addNotificationListener(this._name, (ObjectName)args[0], (NotificationFilter)args[1], args[2]);
                    return null;
                }
            }
        } else if (methodName.equals("removeNotificationListener")) {
            if (args.length == 3) {
                if (args[0] instanceof NotificationListener) {
                    this._connection.removeNotificationListener(this._name, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                    return null;
                }
                if (args[0] instanceof ObjectName) {
                    this._connection.removeNotificationListener(this._name, (ObjectName)args[0], (NotificationFilter)args[1], args[2]);
                    return null;
                }
            } else if (args.length == 1) {
                if (args[0] instanceof NotificationListener) {
                    this._connection.removeNotificationListener(this._name, (NotificationListener)args[0]);
                    return null;
                }
                if (args[0] instanceof ObjectName) {
                    this._connection.removeNotificationListener(this._name, (ObjectName)args[0]);
                    return null;
                }
            }
        }
        String[] sig = new String[params.length];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = params[i].getName();
        }
        return this._connection.invoke(this._name, methodName, args, sig);
    }
}

