/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.ReflectionException;

public class StandardMBean
implements DynamicMBean {
    private static final Logger log = Logger.getLogger(StandardMBean.class.getName());
    private static final Class[] NULL_ARG = new Class[0];
    private static WeakHashMap _introspectionCache = new WeakHashMap();
    private Object _impl;
    private Class _mbeanInterface;
    private MBeanInfo _reflectedInfo;
    private MBeanInfo _mbeanInfo;
    static /* synthetic */ Class class$java$lang$Boolean;

    protected StandardMBean(Class mbeanInterface) throws NotCompliantMBeanException {
        MBeanInfo info;
        this._mbeanInterface = mbeanInterface;
        this._reflectedInfo = info = StandardMBean.introspect(mbeanInterface);
        this.setImplementation(this);
    }

    public StandardMBean(Object impl, Class mbeanInterface) throws NotCompliantMBeanException {
        MBeanInfo info;
        if (impl == null) {
            throw new NullPointerException();
        }
        this._mbeanInterface = mbeanInterface;
        this._reflectedInfo = info = StandardMBean.introspect(mbeanInterface);
        this.setImplementation(impl);
    }

    public void setImplementation(Object implementation) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new NullPointerException();
        }
        if (!this._mbeanInterface.isAssignableFrom(implementation.getClass())) {
            throw new NotCompliantMBeanException();
        }
        this._impl = implementation;
    }

    public Object getImplementation() {
        return this._impl;
    }

    public Class getImplementationClass() {
        return this._mbeanInterface;
    }

    public final Class getMBeanInterface() {
        return this._mbeanInterface;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            Method method = this.getGetMethod(attribute);
            if (method != null) {
                return method.invoke(this._impl, null);
            }
            throw new AttributeNotFoundException(attribute);
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new MBeanException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Method method = this.getSetMethod(attribute.getName(), attribute.getValue());
            if (method == null) {
                throw new AttributeNotFoundException(attribute.getName());
            }
            method.invoke(this._impl, attribute.getValue());
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new MBeanException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.toString());
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Method method = this.getGetMethod(attributes[i]);
                if (method == null) continue;
                list.add(new Attribute(attributes[i], method.invoke(this._impl, null)));
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            try {
                Attribute attr = (Attribute)attributes.get(i);
                Method method = this.getSetMethod(attr.getName(), attr.getValue());
                if (method == null) continue;
                method.invoke(this._impl, attr.getValue());
                list.add(new Attribute(attr.getName(), attr.getValue()));
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return list;
    }

    private Method getGetMethod(String name) {
        String getName = "get" + name;
        String isName = "is" + name;
        Method[] methods = this._mbeanInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] args;
            if (!methods[i].getName().equals(getName) && !methods[i].getName().equals(isName) || (args = methods[i].getParameterTypes()).length != 0 || methods[i].getReturnType().equals(Void.TYPE)) continue;
            return methods[i];
        }
        return null;
    }

    private Method getSetMethod(String name, Object value) {
        name = "set" + name;
        Method[] methods = this._mbeanInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] args;
            if (!methods[i].getName().equals(name) || (args = methods[i].getParameterTypes()).length != 1) continue;
            return methods[i];
        }
        return null;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            Method[] methods = this._mbeanInterface.getMethods();
            int length = 0;
            if (signature != null) {
                length = signature.length;
            }
            if (params != null) {
                length = params.length;
            }
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] args;
                if (!methods[i].getName().equals(actionName) || (args = methods[i].getParameterTypes()).length != length) continue;
                boolean isMatch = true;
                for (int j = length - 1; j >= 0; --j) {
                    if (args[j].getName().equals(signature[j])) continue;
                    isMatch = false;
                }
                if (!isMatch) continue;
                return methods[i].invoke(this._impl, params);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw new ReflectionException((Exception)e.getCause());
            }
            throw (Error)e.getCause();
        }
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = this.getCachedMBeanInfo();
        if (info != null) {
            return info;
        }
        info = this.calculateMBeanInfo(this.getReflectedInfo());
        this.cacheMBeanInfo(info);
        return info;
    }

    protected String getClassName(MBeanInfo info) {
        return info.getClassName();
    }

    protected String getDescription(MBeanInfo info) {
        return info.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo info) {
        return info.getDescription();
    }

    protected String getDescription(MBeanAttributeInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return param.getDescription();
    }

    protected String getParameterName(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return param.getName();
    }

    protected String getDescription(MBeanOperationInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected int getImpact(MBeanOperationInfo info) {
        return info.getImpact();
    }

    protected String getParameterName(MBeanOperationInfo info, MBeanParameterInfo param, int sequence) {
        return param.getName();
    }

    protected String getDescription(MBeanOperationInfo info, MBeanParameterInfo param, int sequence) {
        return param.getDescription();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] ctors, Object impl) {
        if (impl != this.getImplementation()) {
            return null;
        }
        return ctors;
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return this._mbeanInfo;
    }

    protected void cacheMBeanInfo(MBeanInfo info) {
        this._mbeanInfo = info;
    }

    private MBeanInfo getReflectedInfo() {
        return this._reflectedInfo;
    }

    private MBeanInfo calculateMBeanInfo(MBeanInfo reflectedInfo) {
        String className = this.getClassName(reflectedInfo);
        String description = this.getDescription(reflectedInfo);
        MBeanConstructorInfo[] oldCtors = this.getConstructors(reflectedInfo.getConstructors(), this.getImplementation());
        MBeanConstructorInfo[] ctors = null;
        if (oldCtors != null) {
            ctors = new MBeanConstructorInfo[oldCtors.length];
            for (int i = 0; i < oldCtors.length; ++i) {
                String name = oldCtors[i].getName();
                String ctorDescription = this.getDescription(oldCtors[i]);
                MBeanParameterInfo[] oldSig = oldCtors[i].getSignature();
                MBeanParameterInfo[] sig = new MBeanParameterInfo[oldSig.length];
                for (int j = 0; j < sig.length; ++j) {
                    String paramName = this.getParameterName(oldCtors[i], oldSig[j], j);
                    String paramType = oldSig[j].getType();
                    String paramDesc = this.getDescription(oldCtors[i], oldSig[j], j);
                    sig[j] = new MBeanParameterInfo(paramName, paramType, paramDesc);
                }
                ctors[i] = new MBeanConstructorInfo(name, ctorDescription, sig);
            }
        }
        MBeanAttributeInfo[] oldAttrs = reflectedInfo.getAttributes();
        MBeanAttributeInfo[] attrs = null;
        if (oldAttrs != null) {
            attrs = new MBeanAttributeInfo[oldAttrs.length];
            for (int i = 0; i < oldAttrs.length; ++i) {
                String name = oldAttrs[i].getName();
                String attrDescription = this.getDescription(oldAttrs[i]);
                String type = oldAttrs[i].getType();
                boolean isIs = oldAttrs[i].isIs();
                boolean isReadable = oldAttrs[i].isReadable();
                boolean isWritable = oldAttrs[i].isWritable();
                attrs[i] = new MBeanAttributeInfo(name, type, attrDescription, isReadable, isWritable, isIs);
            }
        }
        MBeanOperationInfo[] oldOps = reflectedInfo.getOperations();
        MBeanOperationInfo[] ops = null;
        if (oldOps != null) {
            ops = new MBeanOperationInfo[oldOps.length];
            for (int i = 0; i < oldOps.length; ++i) {
                String name = oldOps[i].getName();
                String opDescription = this.getDescription(oldOps[i]);
                String returnType = oldOps[i].getReturnType();
                int impact = this.getImpact(oldOps[i]);
                MBeanParameterInfo[] oldSig = oldOps[i].getSignature();
                MBeanParameterInfo[] sig = new MBeanParameterInfo[oldSig.length];
                for (int j = 0; j < sig.length; ++j) {
                    String paramName = this.getParameterName(oldOps[i], oldSig[j], j);
                    String paramType = oldSig[j].getType();
                    String paramDesc = this.getDescription(oldOps[i], oldSig[j], j);
                    sig[j] = new MBeanParameterInfo(paramName, paramType, paramDesc);
                }
                ops[i] = new MBeanOperationInfo(name, opDescription, sig, returnType, impact);
            }
        }
        MBeanNotificationInfo[] notifs = null;
        Object obj = this.getImplementation();
        if (obj instanceof NotificationBroadcaster) {
            NotificationBroadcaster broadcaster = (NotificationBroadcaster)obj;
            notifs = broadcaster.getNotificationInfo();
        }
        if (notifs == null) {
            notifs = new MBeanNotificationInfo[]{};
        }
        return new MBeanInfo(className, description, attrs, ctors, ops, notifs);
    }

    static MBeanInfo introspect(Class cl) throws NotCompliantMBeanException {
        try {
            MBeanInfo info;
            SoftReference ref = (SoftReference)_introspectionCache.get(cl);
            if (ref != null && (info = (MBeanInfo)ref.get()) != null) {
                return info;
            }
            String className = cl.getName();
            String description = "Standard MBean for " + className;
            ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
            ArrayList constructors = new ArrayList();
            ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
            Method[] methods = cl.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method getter;
                Method setter;
                String name;
                Method method = methods[i];
                String methodName = method.getName();
                Class<?>[] args = method.getParameterTypes();
                Class<?> retType = method.getReturnType();
                if (methodName.startsWith("get") && args.length == 0 && !retType.equals(Void.TYPE)) {
                    name = methodName.substring(3);
                    setter = StandardMBean.getSetter(methods, name, retType);
                    attributes.add(new MBeanAttributeInfo(name, name, method, setter));
                } else if (methodName.startsWith("is") && args.length == 0 && (retType.equals(Boolean.TYPE) || retType.equals(class$java$lang$Boolean == null ? StandardMBean.class$("java.lang.Boolean") : class$java$lang$Boolean))) {
                    name = methodName.substring(2);
                    setter = StandardMBean.getSetter(methods, name, retType);
                    attributes.add(new MBeanAttributeInfo(name, name, method, setter));
                } else if (methodName.startsWith("set") && args.length == 1 && (getter = StandardMBean.getGetter(methods, name = methodName.substring(3), args[0])) == null) {
                    attributes.add(new MBeanAttributeInfo(name, name, null, method));
                }
                operations.add(new MBeanOperationInfo(methodName, method));
            }
            MBeanNotificationInfo[] notifs = new MBeanNotificationInfo[]{};
            MBeanAttributeInfo[] attrArray = new MBeanAttributeInfo[attributes.size()];
            attributes.toArray(attrArray);
            MBeanConstructorInfo[] conArray = new MBeanConstructorInfo[constructors.size()];
            constructors.toArray(conArray);
            MBeanOperationInfo[] opArray = new MBeanOperationInfo[operations.size()];
            operations.toArray(opArray);
            info = new MBeanInfo(className, description, attrArray, conArray, opArray, notifs);
            _introspectionCache.put(cl, new SoftReference<MBeanInfo>(info));
            return info;
        }
        catch (Exception e) {
            throw new NotCompliantMBeanException(String.valueOf(e));
        }
    }

    static Method getSetter(Method[] methods, String property, Class type) {
        String name = "set" + property;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] args;
            if (!methods[i].getName().equals(name) || (args = methods[i].getParameterTypes()).length != 1 || !args[0].equals(type)) continue;
            return methods[i];
        }
        return null;
    }

    static Method getGetter(Method[] methods, String property, Class type) {
        String getName = "get" + property;
        String isName = "is" + property;
        for (int i = 0; i < methods.length; ++i) {
            Class<?> retType;
            Class<?>[] args;
            if (!methods[i].getName().equals(getName) && !methods[i].getName().equals(isName) || (args = methods[i].getParameterTypes()).length != 0 || !(retType = methods[i].getReturnType()).equals(type)) continue;
            return methods[i];
        }
        return null;
    }
}

