/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.caucho.jmx.JobManager;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class RequiredModelMBean
extends NotificationBroadcasterSupport
implements ModelMBean {
    private static final Logger log = Logger.getLogger(RequiredModelMBean.class.getName());
    private ModelMBeanInfo _modelInfo;
    private MBeanInfo _info;
    private Object _resource;
    private ObjectName _name;
    private transient int _sequence;

    public RequiredModelMBean() throws MBeanException, RuntimeOperationsException {
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport("java.lang.Object", "null", new ModelMBeanAttributeInfo[0], new ModelMBeanConstructorInfo[0], new ModelMBeanOperationInfo[0], new ModelMBeanNotificationInfo[0]);
        this.setModelMBeanInfo(info);
    }

    public RequiredModelMBean(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        this.setModelMBeanInfo(info);
    }

    public void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (this._name != null) {
            throw new IllegalStateException("setModelMBeanInfo must occur before registration.");
        }
        this._modelInfo = (ModelMBeanInfo)info.clone();
        this._info = new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), info.getOperations(), info.getNotifications());
    }

    public void setManagedResource(Object resource, String resourceType) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (!"ObjectReference".equals(resourceType)) {
            throw new InvalidTargetObjectTypeException(resourceType);
        }
        this._resource = resource;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method getter = this.getGetter(attribute);
        if (getter == null) {
            throw new AttributeNotFoundException(attribute);
        }
        try {
            return getter.invoke(this._resource, null);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method setter = this.getSetter(attribute.getName());
        if (setter == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        try {
            setter.invoke(this._resource, attribute.getValue());
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public AttributeList getAttributes(String[] attributes) throws RuntimeOperationsException {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object value = this.getAttribute(attributes[i]);
                list.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            try {
                Attribute attr = (Attribute)attributes.get(i);
                this.setAttribute(attr);
                list.add(attr);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return list;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Method method = this.getOperation(actionName, signature);
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(this._resource, params);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw new ReflectionException((Exception)cause);
            }
            throw new ReflectionException(e);
        }
    }

    private Method getGetter(String attribute) throws MBeanException {
        ModelMBeanAttributeInfo info = this._modelInfo.getAttribute(attribute);
        if (info == null) {
            return null;
        }
        String name = (String)info.getDescriptor().getFieldValue("getMethod");
        if (name == null) {
            return null;
        }
        try {
            Method method = this._resource.getClass().getMethod(name, new Class[0]);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Method getSetter(String attribute) throws MBeanException {
        ModelMBeanAttributeInfo info = this._modelInfo.getAttribute(attribute);
        if (info == null) {
            return null;
        }
        String name = (String)info.getDescriptor().getFieldValue("setMethod");
        if (name == null) {
            return null;
        }
        Method[] methods = this._resource.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] param;
            Method method = methods[i];
            if (!method.getName().equals(name) || (param = method.getParameterTypes()).length != 1) continue;
            return method;
        }
        return null;
    }

    private Method getOperation(String name, String[] signature) throws MBeanException {
        ModelMBeanOperationInfo op = this._modelInfo.getOperation(name);
        if (op == null) {
            return null;
        }
        Method[] methods = this._resource.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] param;
            Method method = methods[i];
            if (!method.getName().equals(name) || (param = method.getParameterTypes()).length != signature.length) continue;
            return method;
        }
        return null;
    }

    public MBeanInfo getMBeanInfo() {
        return this._info;
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void sendNotification(String text) throws MBeanException, RuntimeOperationsException {
        Notification notif = new Notification("jmx.modelmbean.general", this, this._sequence++, JobManager.getCurrentTime(), text);
        this.sendNotification(notif);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException, RuntimeOperationsException {
        this.sendNotification(notification);
    }

    public void sendAttributeChangeNotification(Attribute oldValue, Attribute newValue) throws MBeanException, RuntimeOperationsException {
        AttributeChangeNotification notif = new AttributeChangeNotification(this, this._sequence++, JobManager.getCurrentTime(), "attribute change", oldValue.getName(), "java.lang.Object", oldValue.getValue(), newValue.getValue());
        this.sendAttributeChangeNotification(notif);
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException, RuntimeOperationsException {
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute(attributeName);
        this.addNotificationListener(listener, filter, handback);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        this.removeNotificationListener(listener);
    }
}

