/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.caucho.jmx.JobManager;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private boolean _differenceMode;
    private Number _modulus = new Long(Long.MAX_VALUE);
    private boolean _notify;
    private Number _offset = new Long(0L);
    private Number _threshold = new Long(-1L);
    private long _sequence;

    public Number getDerivedGauge(ObjectName name) {
        CounterValue value = (CounterValue)this.getObjectValue(name);
        if (value == null) {
            return null;
        }
        if (this._differenceMode) {
            return new Long(value.getDifferenceValue());
        }
        return new Long(value.getCounterValue());
    }

    public long getDerivedGaugeTimeStamp(ObjectName name) {
        CounterValue value = (CounterValue)this.getObjectValue(name);
        if (value == null) {
            return 0L;
        }
        return value.getTimestamp();
    }

    public Number getThreshold(ObjectName name) {
        CounterValue value = (CounterValue)this.getObjectValue(name);
        return new Long(value.getCounterValue());
    }

    public Number getInitThreshold() {
        return this._threshold;
    }

    public void setInitThreshold(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("setInitThreshold cannot be null");
        }
        this._threshold = value;
    }

    public void setThreshold(Number value) throws IllegalArgumentException {
        this.setThreshold(value);
    }

    public Number getOffset() {
        return this._offset;
    }

    public void setOffset(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("offset cannot be null");
        }
        this._offset = value;
    }

    public Number getModulus() {
        return this._modulus;
    }

    public void setModulus(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("modulus cannot be null");
        }
        this._modulus = value;
    }

    public boolean getNotify() {
        return this._notify;
    }

    public void setNotify(boolean value) throws IllegalArgumentException {
        this._notify = value;
    }

    public boolean getDifferenceMode() {
        return this._differenceMode;
    }

    public void setDifferenceMode(boolean value) throws IllegalArgumentException {
        this._differenceMode = value;
    }

    public Number getDerivedGauge() {
        return this.getDerivedGauge(this.getObservedObject());
    }

    public Number getThreshold() {
        return this.getThreshold(this.getObservedObject());
    }

    public long getDerivedGaugeTimeStamp() {
        return this.getDerivedGaugeTimeStamp(this.getObservedObject());
    }

    protected Monitor.ObjectValue createObjectValue(ObjectName name, Object initValue) {
        long counterValue = ((Number)initValue).longValue();
        CounterValue value = new CounterValue(name);
        value.setValue(initValue);
        value.setTimestamp(JobManager.getCurrentTime());
        value.setCounterValue(counterValue);
        value.setDifferenceValue(0L);
        return value;
    }

    protected void checkUpdate(Monitor.ObjectValue objValue, Object newValue) {
        CounterValue counter = (CounterValue)objValue;
        Number numberValue = (Number)newValue;
        long value = 0L;
        if (numberValue != null) {
            value = numberValue.longValue();
        }
        long oldValue = counter.getCounterValue();
        long oldDifference = counter.getDifferenceValue();
        long difference = value - oldValue;
        counter.setCounterValue(value);
        counter.setDifferenceValue(value - oldValue);
        if (!this._notify) {
            return;
        }
        String matchType = null;
        if (oldValue < this._threshold.longValue() && this._threshold.longValue() <= value) {
            matchType = "jmx.monitor.counter.threshold";
        }
        if (matchType == null) {
            return;
        }
        MonitorNotification notif = new MonitorNotification(matchType, this.getName(), this._sequence++, JobManager.getCurrentTime(), "change message", objValue.getName(), this.getObservedAttribute(), "gauge", "trigger");
        this.sendNotification(notif);
    }

    static class CounterValue
    extends Monitor.ObjectValue {
        private long _counterValue;
        private long _differenceValue;

        CounterValue(ObjectName name) {
            super(name);
        }

        void setCounterValue(long counterValue) {
            this._counterValue = counterValue;
        }

        long getCounterValue() {
            return this._counterValue;
        }

        void setDifferenceValue(long differenceValue) {
            this._differenceValue = differenceValue;
        }

        long getDifferenceValue() {
            return this._differenceValue;
        }
    }
}

