/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.caucho.jmx.JobManager;
import javax.management.ObjectName;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private boolean _differenceMode;
    private boolean _notifyLow;
    private boolean _notifyHigh;
    private Number _lowThreshold = new Double(Double.MIN_VALUE);
    private Number _highThreshold = new Double(Double.MAX_VALUE);
    private long _sequence;

    public Number getDerivedGauge(ObjectName name) {
        GaugeValue value = (GaugeValue)this.getObjectValue(name);
        if (value == null) {
            return null;
        }
        if (this._differenceMode) {
            return new Double(value.getDifferenceValue());
        }
        return new Double(value.getGaugeValue());
    }

    public Number getHighThreshold() {
        return this._highThreshold;
    }

    public Number getLowThreshold() {
        return this._lowThreshold;
    }

    public void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null || lowValue == null) {
            throw new IllegalArgumentException();
        }
        if (highValue.doubleValue() < lowValue.doubleValue()) {
            throw new IllegalArgumentException();
        }
        this._lowThreshold = lowValue;
        this._highThreshold = highValue;
    }

    public boolean getNotifyHigh() {
        return this._notifyHigh;
    }

    public void setNotifyHigh(boolean value) throws IllegalArgumentException {
        this._notifyHigh = value;
    }

    public boolean getNotifyLow() {
        return this._notifyLow;
    }

    public void setNotifyLow(boolean value) throws IllegalArgumentException {
        this._notifyLow = value;
    }

    public boolean getDifferenceMode() {
        return this._differenceMode;
    }

    public void setDifferenceMode(boolean value) throws IllegalArgumentException {
        this._differenceMode = value;
    }

    public Number getDerivedGauge() {
        return this.getDerivedGauge(this.getObservedObject());
    }

    public long getDerivedGaugeTimeStamp() {
        return this.getDerivedGaugeTimeStamp(this.getObservedObject());
    }

    protected Monitor.ObjectValue createObjectValue(ObjectName name, Object initValue) {
        double gaugeValue = ((Number)initValue).longValue();
        GaugeValue value = new GaugeValue(name);
        value.setValue(initValue);
        value.setTimestamp(JobManager.getCurrentTime());
        value.setGaugeValue(gaugeValue);
        value.setDifferenceValue(0.0);
        value.setMatchValue((this._lowThreshold.doubleValue() + this._highThreshold.doubleValue()) / 2.0);
        return value;
    }

    protected void checkUpdate(Monitor.ObjectValue objValue, Object newValue) {
        GaugeValue gauge = (GaugeValue)objValue;
        Number numberValue = (Number)newValue;
        double value = 0.0;
        if (numberValue != null) {
            value = numberValue.longValue();
        }
        double oldValue = gauge.getGaugeValue();
        double oldDifference = gauge.getDifferenceValue();
        double difference = value - oldValue;
        gauge.setGaugeValue(value);
        gauge.setDifferenceValue(difference);
        double lowThreshold = this._lowThreshold.doubleValue();
        double highThreshold = this._highThreshold.doubleValue();
        String matchType = null;
        if (this._differenceMode) {
            if (difference < lowThreshold && (lowThreshold < gauge.getMatchValue() || highThreshold == gauge.getMatchValue())) {
                gauge.setMatchValue(lowThreshold);
                if (this._notifyLow) {
                    matchType = "jmx.monitor.gauge.low";
                }
            } else if (highThreshold < difference && (gauge.getMatchValue() < highThreshold || lowThreshold == gauge.getMatchValue())) {
                gauge.setMatchValue(highThreshold);
                if (this._notifyHigh) {
                    matchType = "jmx.monitor.gauge.high";
                }
            }
        } else if (value < lowThreshold && (lowThreshold < gauge.getMatchValue() || highThreshold == gauge.getMatchValue())) {
            gauge.setMatchValue(lowThreshold);
            if (this._notifyLow) {
                matchType = "jmx.monitor.gauge.low";
            }
        } else if (highThreshold < value && (gauge.getMatchValue() < highThreshold || lowThreshold == gauge.getMatchValue())) {
            gauge.setMatchValue(highThreshold);
            if (this._notifyHigh) {
                matchType = "jmx.monitor.gauge.high";
            }
        }
        if (matchType == null) {
            return;
        }
        MonitorNotification notif = new MonitorNotification(matchType, this.getName(), this._sequence++, JobManager.getCurrentTime(), "change message", objValue.getName(), this.getObservedAttribute(), "gauge", "trigger");
        this.sendNotification(notif);
    }

    static class GaugeValue
    extends Monitor.ObjectValue {
        private double _gaugeValue;
        private double _differenceValue;
        private double _matchValue;

        GaugeValue(ObjectName name) {
            super(name);
        }

        void setGaugeValue(double gaugeValue) {
            this._gaugeValue = gaugeValue;
        }

        double getGaugeValue() {
            return this._gaugeValue;
        }

        void setDifferenceValue(double differenceValue) {
            this._differenceValue = differenceValue;
        }

        double getDifferenceValue() {
            return this._differenceValue;
        }

        void setMatchValue(double matchValue) {
            this._matchValue = matchValue;
        }

        double getMatchValue() {
            return this._matchValue;
        }
    }
}

