/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.caucho.jmx.JobManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration,
Serializable {
    private static final Logger log = Logger.getLogger(Monitor.class.getName());
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 1;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 4;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 8;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected MBeanServer server;
    private ObjectName _name;
    protected int _alreadyNotified;
    private long _granularityPeriod = 10000L;
    private ArrayList _objects = new ArrayList();
    private ArrayList _runValues = new ArrayList();
    private String _attribute;
    private boolean _isActive;
    private Job _job = new Job(this);

    public void start() {
        if (this._isActive) {
            return;
        }
        this._isActive = true;
        this._job.run();
    }

    public void stop() {
        if (!this._isActive) {
            return;
        }
        this._isActive = false;
        JobManager.dequeue(this._job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObservedObject(ObjectName name) {
        try {
            Object newValue = this.server.getAttribute(name, this._attribute);
            ObjectValue value = this.createObjectValue(name, newValue);
            ArrayList arrayList = this._objects;
            synchronized (arrayList) {
                this._objects.add(value);
            }
        }
        catch (MBeanException e) {
            this.sendNotification("jmx.monitor.error.mbean", String.valueOf(e), name);
        }
        catch (InstanceNotFoundException e) {
            this.sendNotification("jmx.monitor.error.mbean", String.valueOf(e), name);
        }
        catch (ReflectionException e) {
            this.sendNotification("jmx.monitor.error.mbean", String.valueOf(e.getCause()), name);
        }
        catch (AttributeNotFoundException e) {
            this.sendNotification("jmx.monitor.error.attribute", String.valueOf(e), name);
        }
    }

    protected ObjectValue createObjectValue(ObjectName name, Object initValue) {
        ObjectValue value = new ObjectValue(name);
        value.setValue(initValue);
        value.setTimestamp(JobManager.getCurrentTime());
        return value;
    }

    private void sendNotification(String type, String msg, ObjectName name) {
        MonitorNotification notif = new MonitorNotification("jmx.monitor.error.mbean", this._name, 0L, new Date().getTime(), msg, name, this._attribute, null, null);
        this.sendNotification(notif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObservedObject(ObjectName name) {
        ArrayList arrayList = this._objects;
        synchronized (arrayList) {
            for (int i = this._objects.size() - 1; i >= 0; --i) {
                ObjectValue value = (ObjectValue)this._objects.get(i);
                if (!value.getName().equals(name)) continue;
                this._objects.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObservedObject(ObjectName name) {
        ArrayList arrayList = this._objects;
        synchronized (arrayList) {
            for (int i = this._objects.size() - 1; i >= 0; --i) {
                ObjectValue value = (ObjectValue)this._objects.get(i);
                if (!value.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getObservedObjects() {
        ObjectName[] values = new ObjectName[this._objects.size()];
        ArrayList arrayList = this._objects;
        synchronized (arrayList) {
            for (int i = this._objects.size() - 1; i >= 0; --i) {
                values[i] = ((ObjectValue)this._objects.get(i)).getName();
            }
        }
        return values;
    }

    public String getObservedAttribute() {
        return this._attribute;
    }

    public void setObservedAttribute(String name) {
        this._attribute = name;
    }

    public long getGranularityPeriod() {
        return this._granularityPeriod;
    }

    public void setGranularityPeriod(long period) {
        this._granularityPeriod = period;
    }

    public boolean isActive() {
        return this._isActive;
    }

    protected ObjectName getName() {
        return this._name;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this._name = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    public ObjectName getObservedObject() {
        if (this._objects.size() > 0) {
            return ((ObjectValue)this._objects.get(0)).getName();
        }
        return null;
    }

    public void setObservedObject(ObjectName name) {
        this.addObservedObject(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        this._runValues.clear();
        ArrayList arrayList = this._objects;
        synchronized (arrayList) {
            this._runValues.addAll(this._objects);
        }
        for (int i = 0; i < this._runValues.size(); ++i) {
            ObjectValue value = (ObjectValue)this._runValues.get(i);
            Object oldValue = value.getValue();
            try {
                Object newValue = this.server.getAttribute(value.getName(), this._attribute);
                value.setValue(newValue);
                if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) continue;
                value.setTimestamp(JobManager.getCurrentTime());
                this.checkUpdate(value, newValue);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectValue getObjectValue(ObjectName name) {
        ObjectValue value = null;
        ArrayList arrayList = this._objects;
        synchronized (arrayList) {
            for (int i = this._runValues.size() - 1; i >= 0; --i) {
                ObjectValue testValue = (ObjectValue)this._runValues.get(i);
                if (!testValue.getName().equals(name)) continue;
                value = testValue;
                break;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDerivedGaugeTimeStamp(ObjectName name) {
        ArrayList arrayList = this._objects;
        synchronized (arrayList) {
            for (int i = this._runValues.size() - 1; i >= 0; --i) {
                ObjectValue testValue = (ObjectValue)this._runValues.get(i);
                if (!testValue.getName().equals(name)) continue;
                return testValue.getTimestamp();
            }
        }
        return 0L;
    }

    protected void checkUpdate(ObjectValue value, Object newValue) {
    }

    static class Job
    extends TimerTask {
        private Monitor _monitor;

        Job(Monitor monitor) {
            this._monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this._monitor.run();
            }
            finally {
                try {
                    if (this._monitor.isActive()) {
                        JobManager.queueRelative(this, this._monitor.getGranularityPeriod());
                    }
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    static class ObjectValue {
        private ObjectName _name;
        private Object _value;
        private long _timestamp;

        ObjectValue(ObjectName name) {
            this._name = name;
        }

        ObjectName getName() {
            return this._name;
        }

        Object getValue() {
            return this._value;
        }

        void setValue(Object value) {
            this._value = value;
        }

        void setTimestamp(long time) {
            this._timestamp = time;
        }

        long getTimestamp() {
            return this._timestamp;
        }
    }
}

